/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.kernel;

import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import ptolemy.kernel.Entity;
import ptolemy.kernel.Relation;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.CrossRefList;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public class Port
extends NamedObj {
    protected CrossRefList _insideLinks = new CrossRefList(this);
    protected CrossRefList _relationsList = new CrossRefList(this);
    private Entity _container;

    public Port() {
        this._elementName = "port";
    }

    public Port(Workspace workspace) {
        super(workspace);
        this._elementName = "port";
    }

    public Port(Entity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container.workspace(), name);
        this._elementName = "port";
        this.setContainer(container);
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        Port newObject = (Port)super.clone(workspace);
        newObject._relationsList = new CrossRefList(newObject);
        newObject._insideLinks = new CrossRefList(newObject);
        newObject._container = null;
        return newObject;
    }

    public List connectedPortList() {
        try {
            this._workspace.getReadAccess();
            LinkedList result = new LinkedList();
            for (Relation relation : this.linkedRelationList()) {
                if (relation == null) continue;
                result.addAll(relation.linkedPortList(this));
            }
            List list = Collections.unmodifiableList(result);
            return list;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    public Enumeration connectedPorts() {
        return Collections.enumeration(this.connectedPortList());
    }

    public NamedObj getContainer() {
        return this._container;
    }

    public void insertLink(int index, Relation relation) throws IllegalActionException {
        if (this._workspace != relation.workspace()) {
            throw new IllegalActionException((Nameable)this, relation, "Cannot link because workspaces are different.");
        }
        try {
            this._workspace.getWriteAccess();
            this._checkLink(relation);
            this._relationsList.insertLink(index, relation._linkList);
            if (this._container != null) {
                this._container.connectionsChanged(this);
            }
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    public boolean isGroupLinked(Relation r) {
        try {
            this._workspace.getReadAccess();
            for (Relation groupRelation : r.relationGroupList()) {
                if (!this._relationsList.isLinked(groupRelation)) continue;
                return true;
            }
            return false;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    public boolean isLinked(Relation r) {
        try {
            this._workspace.getReadAccess();
            boolean bl = this._relationsList.isLinked(r);
            return bl;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    public void link(Relation relation) throws IllegalActionException {
        if (relation != null && this._workspace != relation.workspace()) {
            throw new IllegalActionException((Nameable)this, relation, "Cannot link because workspaces are different.");
        }
        try {
            this._workspace.getWriteAccess();
            if (relation != null) {
                this._checkLink(relation);
                this._relationsList.link(relation._linkList);
            } else {
                this._relationsList.link(null);
            }
            if (this._container != null) {
                this._container.connectionsChanged(this);
            }
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    public List linkedRelationList() {
        try {
            this._workspace.getReadAccess();
            LinkedList result = new LinkedList();
            Enumeration relations = this._relationsList.getContainers();
            while (relations.hasMoreElements()) {
                result.add(relations.nextElement());
            }
            LinkedList linkedList = result;
            return linkedList;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    public Enumeration linkedRelations() {
        try {
            this._workspace.getReadAccess();
            Enumeration enumeration = this._relationsList.getContainers();
            return enumeration;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    public int moveDown() throws IllegalActionException {
        Entity container = (Entity)this.getContainer();
        if (container == null) {
            throw new IllegalActionException((Nameable)this, "Has no container.");
        }
        try {
            this._workspace.getWriteAccess();
            int result = container._portList.moveDown(this);
            for (NamedObj derived : this.getDerivedList()) {
                container = (Entity)derived.getContainer();
                container._portList.moveDown(derived);
            }
            int n = result;
            return n;
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    public int moveToFirst() throws IllegalActionException {
        Entity container = (Entity)this.getContainer();
        if (container == null) {
            throw new IllegalActionException((Nameable)this, "Has no container.");
        }
        try {
            this._workspace.getWriteAccess();
            int result = container._portList.moveToFirst(this);
            for (NamedObj derived : this.getDerivedList()) {
                container = (Entity)derived.getContainer();
                container._portList.moveToFirst(derived);
            }
            int n = result;
            return n;
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    public int moveToIndex(int index) throws IllegalActionException {
        Entity container = (Entity)this.getContainer();
        if (container == null) {
            throw new IllegalActionException((Nameable)this, "Has no container.");
        }
        try {
            this._workspace.getWriteAccess();
            int result = container._portList.moveToIndex(this, index);
            for (NamedObj derived : this.getDerivedList()) {
                container = (Entity)derived.getContainer();
                container._portList.moveToIndex(derived, index);
            }
            int n = result;
            return n;
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    public int moveToLast() throws IllegalActionException {
        Entity container = (Entity)this.getContainer();
        if (container == null) {
            throw new IllegalActionException((Nameable)this, "Has no container.");
        }
        try {
            this._workspace.getWriteAccess();
            int result = container._portList.moveToLast(this);
            for (NamedObj derived : this.getDerivedList()) {
                container = (Entity)derived.getContainer();
                container._portList.moveToLast(derived);
            }
            int n = result;
            return n;
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    public int moveUp() throws IllegalActionException {
        Entity container = (Entity)this.getContainer();
        if (container == null) {
            throw new IllegalActionException((Nameable)this, "Has no container.");
        }
        try {
            this._workspace.getWriteAccess();
            int result = container._portList.moveUp(this);
            for (NamedObj derived : this.getDerivedList()) {
                container = (Entity)derived.getContainer();
                container._portList.moveUp(derived);
            }
            int n = result;
            return n;
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    public int numLinks() {
        try {
            this._workspace.getReadAccess();
            int n = this._relationsList.size();
            return n;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    public void setContainer(Entity entity) throws IllegalActionException, NameDuplicationException {
        if (entity != null && this._workspace != entity.workspace()) {
            throw new IllegalActionException((Nameable)this, entity, "Cannot set container because workspaces are different.");
        }
        try {
            this._workspace.getWriteAccess();
            this._checkContainer(entity);
            Entity previousContainer = this._container;
            if (previousContainer == entity) {
                return;
            }
            this._container = entity;
            if (entity != null) {
                try {
                    entity._addPort(this);
                }
                catch (IllegalActionException ex) {
                    this._container = previousContainer;
                    throw (IllegalActionException)ex.fillInStackTrace();
                }
                catch (NameDuplicationException ex) {
                    this._container = previousContainer;
                    throw (NameDuplicationException)ex.fillInStackTrace();
                }
                if (previousContainer == null) {
                    this._workspace.remove(this);
                }
            }
            if (previousContainer != null) {
                previousContainer._removePort(this);
            }
            if (entity == null) {
                this.unlinkAll();
            } else if (this._changeRequests != null) {
                for (ChangeRequest request : this._changeRequests) {
                    entity.requestChange(request);
                }
                this._changeRequests = null;
            }
            this.validateSettables();
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    public void setName(String name) throws IllegalActionException, NameDuplicationException {
        Port another;
        Entity container;
        if (name == null) {
            name = "";
        }
        if ((container = (Entity)this.getContainer()) != null && (another = container.getPort(name)) != null && another != this) {
            throw new NameDuplicationException((Nameable)container, "Name duplication: " + name);
        }
        super.setName(name);
    }

    public void unlink(int index) {
        try {
            this._workspace.getWriteAccess();
            this._relationsList.unlink(index);
            if (this._container != null) {
                this._container.connectionsChanged(this);
            }
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    public void unlink(Relation relation) {
        try {
            this._workspace.getWriteAccess();
            this._relationsList.unlink(relation);
            if (this._container != null) {
                this._container.connectionsChanged(this);
            }
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    public void unlinkAll() {
        try {
            this._workspace.getWriteAccess();
            this._relationsList.unlinkAll();
            if (this._container != null) {
                this._container.connectionsChanged(this);
            }
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    protected void _checkContainer(Entity container) throws IllegalActionException {
    }

    protected void _checkLink(Relation relation) throws IllegalActionException {
        if (relation != null) {
            if (this._container == null) {
                throw new IllegalActionException((Nameable)this, relation, "Port must have a container to establish a link.");
            }
            relation._checkPort(this);
        }
    }

    protected String _description(int detail, int indent, int bracket) {
        try {
            this._workspace.getReadAccess();
            StringBuffer result = new StringBuffer();
            if (bracket == 1 || bracket == 2) {
                result.append(super._description(detail, indent, 1));
            } else {
                result.append(super._description(detail, indent, 0));
            }
            if ((detail & 4) != 0) {
                if (result.toString().trim().length() > 0) {
                    result.append(" ");
                }
                detail &= 0xFFFFFFFB;
                result.append("links {\n");
                Enumeration linkedRelations = this.linkedRelations();
                while (linkedRelations.hasMoreElements()) {
                    Relation relation = (Relation)linkedRelations.nextElement();
                    if (relation != null) {
                        result.append(String.valueOf(relation._description(detail, indent + 1, 2)) + "\n");
                        continue;
                    }
                    result.append(String.valueOf(Port._getIndentPrefix(indent + 1)) + "null\n");
                }
                result.append(String.valueOf(Port._getIndentPrefix(indent)) + "}");
            }
            if (bracket == 2) {
                result.append("}");
            }
            String string = result.toString();
            return string;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    protected NamedObj _getContainedObject(NamedObj container, String relativeName) throws IllegalActionException {
        if (!(container instanceof Entity)) {
            throw new IllegalActionException((Nameable)this, "Expected " + container.getFullName() + " to be an instance of ptolemy.kernel.Entity," + " but it is " + container.getClass().getName());
        }
        Port candidate = ((Entity)container).getPort(relativeName);
        if (candidate != null && !this.getClass().isInstance(candidate)) {
            throw new IllegalActionException((Nameable)this, "Expected " + candidate.getFullName() + " to be an instance of " + this.getClass().getName() + ", but it is " + candidate.getClass().getName());
        }
        return candidate;
    }

    protected NamedObj _propagateExistence(NamedObj container) throws IllegalActionException {
        try {
            Port newObject = (Port)super._propagateExistence(container);
            newObject.setContainer((Entity)container);
            return newObject;
        }
        catch (NameDuplicationException e) {
            throw new InternalErrorException(e);
        }
    }
}

