/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.kernel;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import ptolemy.kernel.InstantiableNamedObj;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.InvalidStateException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedList;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.Workspace;

public class Entity
extends InstantiableNamedObj {
    NamedList _portList = new NamedList(this);
    private transient LinkedList _connectedPorts;
    private transient long _connectedPortsVersion = -1L;
    private transient LinkedList _linkedRelations;
    private transient long _linkedRelationsVersion = -1L;

    public Entity() {
    }

    public Entity(String name) throws IllegalActionException {
        super(name);
    }

    public Entity(Workspace workspace) {
        super(workspace);
    }

    public Entity(Workspace workspace, String name) throws IllegalActionException {
        super(workspace, name);
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        try {
            this.workspace().getReadAccess();
            Entity newEntity = (Entity)super.clone(workspace);
            newEntity._portList = new NamedList(newEntity);
            for (Port port : this.portList()) {
                Port newPort = (Port)port.clone(workspace);
                try {
                    newPort.setContainer(newEntity);
                }
                catch (KernelException ex) {
                    workspace.remove(newEntity);
                    throw new InvalidStateException(this, "Failed to clone an Entity: " + ex.getMessage());
                }
            }
            Class<?> myClass = this.getClass();
            Field[] fields = myClass.getFields();
            int i = 0;
            while (i < fields.length) {
                try {
                    if (fields[i].get(newEntity) instanceof Port) {
                        String portName = ((Port)fields[i].get(this)).getName();
                        Port port = newEntity.getPort(portName);
                        if (port == null) {
                            throw new IllegalActionException((Nameable)this, "Could not find a port named '" + portName + "';");
                        }
                        fields[i].set(newEntity, port);
                    }
                }
                catch (Exception ex) {
                    CloneNotSupportedException cloneException = new CloneNotSupportedException("Problem cloning '" + fields[i].getName() + "'");
                    cloneException.initCause(ex);
                    throw cloneException;
                }
                ++i;
            }
            this._cloneFixAttributeFields(newEntity);
            Entity entity = newEntity;
            return entity;
        }
        finally {
            this.workspace().doneReading();
        }
    }

    public List connectedPortList() {
        try {
            this._workspace.getReadAccess();
            if (this._workspace.getVersion() != this._connectedPortsVersion) {
                this._connectedPorts = new LinkedList();
                for (Port port : this._portList.elementList()) {
                    this._connectedPorts.addAll(port.connectedPortList());
                }
                this._connectedPortsVersion = this._workspace.getVersion();
            }
            List list = Collections.unmodifiableList(this._connectedPorts);
            return list;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    public Enumeration connectedPorts() {
        return Collections.enumeration(this.connectedPortList());
    }

    public void connectionsChanged(Port port) {
    }

    public Iterator containedObjectsIterator() {
        return new ContainedObjectsIterator();
    }

    public Attribute getAttribute(String name) {
        try {
            Port match;
            String[] subnames;
            this._workspace.getReadAccess();
            Attribute result = super.getAttribute(name);
            if (result == null && (subnames = Entity._splitName(name))[1] != null && (match = this.getPort(subnames[0])) != null) {
                result = match.getAttribute(subnames[1]);
            }
            Attribute attribute = result;
            return attribute;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    public Port getPort(String name) {
        try {
            this._workspace.getReadAccess();
            Port port = (Port)this._portList.get(name);
            return port;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    public Enumeration getPorts() {
        return Collections.enumeration(this.portList());
    }

    public List linkedRelationList() {
        try {
            this._workspace.getReadAccess();
            if (this._workspace.getVersion() != this._linkedRelationsVersion) {
                this._linkedRelations = new LinkedList();
                for (Port port : this._portList.elementList()) {
                    this._linkedRelations.addAll(port.linkedRelationList());
                }
                this._linkedRelationsVersion = this._workspace.getVersion();
            }
            List list = Collections.unmodifiableList(this._linkedRelations);
            return list;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    public Enumeration linkedRelations() {
        return Collections.enumeration(this.linkedRelationList());
    }

    public Port newPort(String name) throws IllegalActionException, NameDuplicationException {
        try {
            Port port;
            this._workspace.getWriteAccess();
            Port port2 = port = new Port(this, name);
            return port2;
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    public List portList() {
        try {
            this._workspace.getReadAccess();
            List list = this._portList.elementList();
            return list;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    public void removeAllPorts() {
        try {
            this._workspace.getWriteAccess();
            NamedList portListCopy = new NamedList(this._portList);
            for (Port port : portListCopy.elementList()) {
                try {
                    port.setContainer(null);
                }
                catch (KernelException ex) {
                    throw new InternalErrorException("Internal error in Port constructor!" + ex.getMessage());
                }
            }
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    public void setClassDefinition(boolean isClass) throws IllegalActionException {
        if (isClass && !this.isClassDefinition()) {
            for (Port port : this.portList()) {
                if (port.numLinks() <= 0) continue;
                throw new IllegalActionException((Nameable)this, "Cannot convert an entity to a class definition while it contains ports with links.");
            }
        }
        super.setClassDefinition(isClass);
    }

    public String uniqueName(String prefix) {
        if (prefix == null) {
            prefix = "null";
        }
        String candidate = prefix = Entity._stripNumericSuffix(prefix);
        int uniqueNameIndex = 2;
        while (this.getAttribute(candidate) != null || this.getPort(candidate) != null) {
            candidate = String.valueOf(prefix) + uniqueNameIndex++;
        }
        return candidate;
    }

    protected void _addPort(Port port) throws IllegalActionException, NameDuplicationException {
        this._portList.append(port);
    }

    protected String _description(int detail, int indent, int bracket) {
        try {
            this._workspace.getReadAccess();
            StringBuffer result = new StringBuffer();
            if (bracket == 1 || bracket == 2) {
                result.append(super._description(detail, indent, 1));
            } else {
                result.append(super._description(detail, indent, 0));
            }
            if ((detail & 8) != 0 || (detail & 4) != 0) {
                if (result.toString().trim().length() > 0) {
                    result.append(" ");
                }
                result.append("ports {\n");
                for (Port port : this.portList()) {
                    result.append(String.valueOf(port._description(detail, indent + 1, 2)) + "\n");
                }
                result.append(String.valueOf(Entity._getIndentPrefix(indent)) + "}");
            }
            if (bracket == 2) {
                result.append("}");
            }
            String string = result.toString();
            return string;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    protected void _exportMoMLContents(Writer output, int depth) throws IOException {
        super._exportMoMLContents(output, depth);
        for (Port port : this.portList()) {
            port.exportMoML(output, depth);
        }
    }

    protected void _removePort(Port port) {
        this._portList.remove(port);
    }

    protected void _validateSettables(Collection attributesValidated) throws IllegalActionException {
        super._validateSettables(attributesValidated);
        for (Port port : this.portList()) {
            block5: {
                if (port instanceof Settable) {
                    try {
                        Collection validated = ((Settable)((Object)port)).validate();
                        if (validated != null) {
                            attributesValidated.addAll(validated);
                        }
                        attributesValidated.add(port);
                    }
                    catch (IllegalActionException ex) {
                        if (this.handleModelError(this, ex)) break block5;
                        throw ex;
                    }
                }
            }
            port.validateSettables();
        }
    }

    protected class ContainedObjectsIterator
    extends NamedObj.ContainedObjectsIterator {
        private Iterator _portListIterator;

        public ContainedObjectsIterator() {
            super(Entity.this);
            this._portListIterator = null;
            this._portListIterator = Entity.this.portList().iterator();
        }

        public boolean hasNext() {
            if (super.hasNext()) {
                return true;
            }
            return this._portListIterator.hasNext();
        }

        public Object next() {
            if (super.hasNext()) {
                return super.next();
            }
            return this._portListIterator.next();
        }

        public void remove() {
            super.remove();
        }
    }
}

