/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.graph.analysis.strategy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import ptolemy.graph.DirectedGraph;
import ptolemy.graph.Edge;
import ptolemy.graph.Graph;
import ptolemy.graph.Node;
import ptolemy.graph.analysis.SingleSourceLongestPathAnalysis;
import ptolemy.graph.analysis.analyzer.MaximumProfitToCostRatioAnalyzer;
import ptolemy.graph.analysis.strategy.CachedStrategy;
import ptolemy.graph.analysis.strategy.FloydWarshallCycleExistenceStrategy;
import ptolemy.graph.analysis.strategy.KarpCycleMeanStrategy;
import ptolemy.graph.mapping.ToDoubleMapMapping;
import ptolemy.graph.mapping.ToDoubleMapping;
import ptolemy.graph.mapping.ToIntMapping;

public class ParhiMaximumProfitToCostRatioStrategy
extends CachedStrategy
implements MaximumProfitToCostRatioAnalyzer {
    private double[][] _firstOrderLongestPathMatrix;
    private List _delayCycle;
    private ArrayList _delayNodeList;
    private ArrayList _maximumProfitToCostRatioCycle;
    private ToDoubleMapping _edgeProfits;
    private ToIntMapping _edgeCosts;

    public ParhiMaximumProfitToCostRatioStrategy(Graph graph, ToDoubleMapping edgeProfits, ToIntMapping edgeCosts) {
        super(graph);
        this._edgeProfits = edgeProfits;
        this._edgeCosts = edgeCosts;
    }

    public List cycle() {
        this._result();
        return this._maximumProfitToCostRatioCycle;
    }

    public double maximumRatio() {
        return (Double)this._result();
    }

    public String toString() {
        return "All pair shortest path analyzer based on Parhi's algorithm.";
    }

    public boolean valid() {
        boolean result = false;
        if (this.graph() instanceof DirectedGraph) {
            FloydWarshallCycleExistenceStrategy analyzer = new FloydWarshallCycleExistenceStrategy(this.graph());
            result = analyzer.hasCycle();
        }
        return result;
    }

    protected Object _compute() {
        this._delayNodeList = new ArrayList();
        this._maximumProfitToCostRatioCycle = new ArrayList();
        DirectedGraph originalGraph = (DirectedGraph)this.graph();
        DirectedGraph graphPlusDelaysAsNodes = (DirectedGraph)originalGraph.cloneAs(new DirectedGraph());
        Object[] edges = graphPlusDelaysAsNodes.edges().toArray();
        HashMap<Edge, Double> edgeProfitsMap = new HashMap<Edge, Double>();
        int j = 0;
        while (j < edges.length) {
            Edge edge = (Edge)edges[j];
            Node source = edge.source();
            Node sink = edge.sink();
            if (this._edgeCosts.toInt(edge) != 0) {
                graphPlusDelaysAsNodes.removeEdge(edge);
                int delays = this._edgeCosts.toInt(edge);
                int i = 0;
                while (i < delays) {
                    Node addedNode = graphPlusDelaysAsNodes.addNodeWeight("D" + j + i);
                    this._delayNodeList.add(addedNode);
                    Edge addedEdge = graphPlusDelaysAsNodes.addEdge(source, addedNode);
                    edgeProfitsMap.put(addedEdge, 0.0);
                    source = addedNode;
                    ++i;
                }
                Edge lastAddedEdge = graphPlusDelaysAsNodes.addEdge(source, sink);
                edgeProfitsMap.put(lastAddedEdge, this._edgeProfits.toDouble(edge));
            } else {
                edgeProfitsMap.put(edge, this._edgeProfits.toDouble(edge));
            }
            ++j;
        }
        HashMap<Node, SingleSourceLongestPathAnalysis> D = new HashMap<Node, SingleSourceLongestPathAnalysis>(this._delayNodeList.size());
        edges = graphPlusDelaysAsNodes.edges().toArray();
        HashMap<Node, Node> predecessorMap = new HashMap<Node, Node>();
        for (Node delayNode : this._delayNodeList) {
            DirectedGraph thisRoundGraph = (DirectedGraph)graphPlusDelaysAsNodes.clone();
            HashMap delayGraphProfitMap = new HashMap();
            int j2 = 0;
            while (j2 < edges.length) {
                Edge edge = (Edge)edges[j2];
                Node source = edge.source();
                Node sink = edge.sink();
                if (sink == delayNode) {
                    predecessorMap.put(delayNode, source);
                }
                if (this._delayNodeList.contains(source) || this._delayNodeList.contains(sink)) {
                    if (source == delayNode) {
                        delayGraphProfitMap.put(edge, edgeProfitsMap.get(edge));
                    }
                    if (sink == delayNode) {
                        thisRoundGraph.removeEdge(edge);
                    }
                    if (source != delayNode && sink != delayNode) {
                        if (this._delayNodeList.contains(source)) {
                            thisRoundGraph.removeEdge(edge);
                        } else {
                            delayGraphProfitMap.put(edge, edgeProfitsMap.get(edge));
                        }
                    }
                } else {
                    delayGraphProfitMap.put(edge, edgeProfitsMap.get(edge));
                }
                ++j2;
            }
            SingleSourceLongestPathAnalysis longestPath = null;
            longestPath = new SingleSourceLongestPathAnalysis(thisRoundGraph, delayNode, new ToDoubleMapMapping(delayGraphProfitMap));
            D.put(delayNode, longestPath);
        }
        this._makeFirstOrderLongestPathMatrix(D, graphPlusDelaysAsNodes, predecessorMap);
        DirectedGraph delayGraph = new DirectedGraph();
        HashMap<Edge, Double> delayGraphEdgeProfits = new HashMap<Edge, Double>();
        int i = 0;
        while (i < this._delayNodeList.size()) {
            delayGraph.addNode((Node)this._delayNodeList.get(i));
            ++i;
        }
        i = 0;
        while (i < this._delayNodeList.size()) {
            int j3 = 0;
            while (j3 < this._delayNodeList.size()) {
                Node source = (Node)this._delayNodeList.get(i);
                Node sink = (Node)this._delayNodeList.get(j3);
                if (this._firstOrderLongestPathMatrix[i][j3] >= 0.0 && (source != sink || this._firstOrderLongestPathMatrix[i][j3] != 0.0)) {
                    Edge addedEdge = delayGraph.addEdge(source, sink);
                    delayGraphEdgeProfits.put(addedEdge, this._firstOrderLongestPathMatrix[i][j3]);
                }
                ++j3;
            }
            ++i;
        }
        double result = this._computeMCM(delayGraph, new ToDoubleMapMapping(delayGraphEdgeProfits));
        edges = graphPlusDelaysAsNodes.edges().toArray();
        Object[] delayNodes = this._delayCycle.toArray();
        int i2 = 0;
        while (i2 < delayNodes.length) {
            Node delayNode = (Node)delayNodes[i2];
            int j4 = 0;
            while (j4 < delayNodes.length) {
                Node predecessor;
                int k;
                List path;
                if (i2 != j4 || delayNodes.length != 1) {
                    Node endDelayNode = (Node)delayNodes[j4];
                    path = ((SingleSourceLongestPathAnalysis)D.get(delayNode)).path(endDelayNode);
                    k = 0;
                    while (k < path.size()) {
                        if (!this._delayNodeList.contains(path.get(k))) {
                            this._maximumProfitToCostRatioCycle.add(path.get(k));
                        }
                        ++k;
                    }
                } else if (delayNodes.length == 1 && !this._delayNodeList.contains(predecessor = (Node)predecessorMap.get(delayNode))) {
                    path = ((SingleSourceLongestPathAnalysis)D.get(delayNode)).path(predecessor);
                    k = 0;
                    while (k < path.size()) {
                        if (!this._delayNodeList.contains(path.get(k))) {
                            this._maximumProfitToCostRatioCycle.add(path.get(k));
                        }
                        ++k;
                    }
                }
                ++j4;
            }
            ++i2;
        }
        return result;
    }

    private double _computeMCM(DirectedGraph graph, ToDoubleMapping edgeLength) {
        KarpCycleMeanStrategy cycleMean = new KarpCycleMeanStrategy(graph, edgeLength);
        double result = cycleMean.maximumCycleMean();
        this._delayCycle = cycleMean.cycle();
        return result;
    }

    private double[][] _makeFirstOrderLongestPathMatrix(HashMap D, DirectedGraph graph, HashMap predecessorMap) {
        this._firstOrderLongestPathMatrix = new double[this._delayNodeList.size()][this._delayNodeList.size()];
        int i = 0;
        while (i < this._delayNodeList.size()) {
            int j = 0;
            while (j < this._delayNodeList.size()) {
                Node column = (Node)this._delayNodeList.get(i);
                Node row = (Node)this._delayNodeList.get(j);
                double value = 0.0;
                double[] distances = ((SingleSourceLongestPathAnalysis)D.get(column)).distance();
                Node predecessor = (Node)predecessorMap.get(row);
                value = i != j || this._delayNodeList.contains(predecessor) ? distances[graph.nodeLabel(row)] : distances[graph.nodeLabel(predecessor)];
                this._firstOrderLongestPathMatrix[i][j] = value;
                ++j;
            }
            ++i;
        }
        return this._firstOrderLongestPathMatrix;
    }
}

