/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.graph.analysis.strategy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import ptolemy.graph.DirectedGraph;
import ptolemy.graph.Edge;
import ptolemy.graph.Graph;
import ptolemy.graph.Node;
import ptolemy.graph.analysis.analyzer.CycleMeanAnalyzer;
import ptolemy.graph.analysis.strategy.CachedStrategy;
import ptolemy.graph.analysis.strategy.FloydWarshallCycleExistenceStrategy;
import ptolemy.graph.mapping.ToDoubleMapping;

public class KarpCycleMeanStrategy
extends CachedStrategy
implements CycleMeanAnalyzer {
    private boolean _maximumAnalysis = true;
    private ArrayList _nodesOnCycle = new ArrayList();
    private ArrayList _cycle;
    private ToDoubleMapping _edgeLengths;

    public KarpCycleMeanStrategy(Graph graph, ToDoubleMapping edgeLengths) {
        super(graph);
        this._edgeLengths = edgeLengths;
    }

    public List cycle() {
        return this._cycle;
    }

    public double cycleMean(boolean maximum) {
        if (this._maximumAnalysis != maximum) {
            this._maximumAnalysis = maximum;
            this.reset();
        }
        return (Double)this._result();
    }

    public double maximumCycleMean() {
        return this.cycleMean(true);
    }

    public double minimumCycleMean() {
        return this.cycleMean(false);
    }

    public String toString() {
        return "All pair shortest path analyzer based on Karp's algorithm.";
    }

    public boolean valid() {
        boolean result = false;
        if (this.graph() instanceof DirectedGraph) {
            FloydWarshallCycleExistenceStrategy analyzer = new FloydWarshallCycleExistenceStrategy(this.graph());
            result = analyzer.hasCycle();
        }
        return result;
    }

    protected Object _compute() {
        DirectedGraph[] graph = ((DirectedGraph)this.graph()).sccDecomposition();
        double maximumResult = -1.7976931348623157E308;
        double result = 0.0;
        int i = 0;
        while (i < graph.length) {
            if (!graph[i].isAcyclic() && (result = this._computeMCMOfSCC(graph[i])) > maximumResult) {
                maximumResult = result;
                this._cycle = new ArrayList();
                int j = 0;
                while (j < this._nodesOnCycle.size()) {
                    this._cycle.add(this._nodesOnCycle.get(j));
                    ++j;
                }
            }
            ++i;
        }
        result = this._maximumAnalysis ? maximumResult : -maximumResult;
        return result;
    }

    private double _computeMCMOfSCC(DirectedGraph directedCyclicGraph) {
        Node firstNode;
        this._nodesOnCycle.clear();
        int n = directedCyclicGraph.nodeCount();
        Node resultNode = null;
        HashMap[] maximumPathLength = new HashMap[n + 1];
        HashMap[] predecessor = new HashMap[n + 1];
        HashMap<Node, Double> cycleMean = new HashMap<Node, Double>(n);
        HashMap<Node, Integer> cycleMeanLevel = new HashMap<Node, Integer>(n);
        double result = -1.7976931348623157E308;
        Node startingNode = directedCyclicGraph.node(0);
        Collection nodeCollection = directedCyclicGraph.nodes();
        int k = 0;
        while (k <= n) {
            maximumPathLength[k] = new HashMap(n);
            predecessor[k] = new HashMap(n);
            for (Node node : nodeCollection) {
                maximumPathLength[k].put(node, -1.7976931348623157E308);
            }
            ++k;
        }
        maximumPathLength[0].put(startingNode, 0.0);
        predecessor[0].put(startingNode, null);
        k = 1;
        while (k <= n) {
            for (Node node : nodeCollection) {
                Collection predecessorCollection = directedCyclicGraph.predecessors(node);
                for (Node nodePredecessor : predecessorCollection) {
                    double distance;
                    double dKMinusOneU;
                    double cost;
                    double dKOfV = (Double)maximumPathLength[k].get(node);
                    if (!(dKOfV < (cost = (dKMinusOneU = ((Double)maximumPathLength[k - 1].get(nodePredecessor)).doubleValue()) + (distance = this._getCost(nodePredecessor, node))))) continue;
                    predecessor[k].put(node, nodePredecessor);
                    maximumPathLength[k].put(node, cost);
                }
            }
            ++k;
        }
        for (Node node : nodeCollection) {
            cycleMean.put(node, (Double)Double.MAX_VALUE);
            int k2 = 0;
            while (k2 < n) {
                double testValue;
                double maximumPathLengthToLevelK = (Double)maximumPathLength[k2].get(node);
                double maximumPathLengthToLevelN = (Double)maximumPathLength[n].get(node);
                double cycleMeanValue = (Double)cycleMean.get(node);
                if (cycleMeanValue > (testValue = (maximumPathLengthToLevelN - maximumPathLengthToLevelK) / (double)(n - k2))) {
                    cycleMean.put(node, testValue);
                    cycleMeanLevel.put(node, k2);
                }
                ++k2;
            }
            double cycleMeanValue = (Double)cycleMean.get(node);
            if (!(result < cycleMeanValue)) continue;
            result = cycleMeanValue;
            resultNode = node;
        }
        Node secondNode = firstNode = resultNode;
        int firstNodeLevel = 0;
        int secondNodeLevel = 0;
        int i = n;
        while (i > 0) {
            int j = i;
            while (j > 0) {
                if ((secondNode = (Node)predecessor[j].get(secondNode)) == firstNode) {
                    firstNodeLevel = i;
                    secondNodeLevel = j;
                    break;
                }
                --j;
            }
            if (secondNode == firstNode) break;
            secondNode = firstNode = (Node)predecessor[i].get(firstNode);
            --i;
        }
        int k3 = firstNodeLevel;
        while (k3 >= secondNodeLevel) {
            firstNode = (Node)predecessor[k3].get(firstNode);
            this._nodesOnCycle.add(firstNode);
            --k3;
        }
        return result;
    }

    private double _getCost(Node u, Node v) {
        DirectedGraph directedCyclicGraph = (DirectedGraph)this.graph();
        Collection edgeCollection = directedCyclicGraph.predecessorEdges(v, u);
        Iterator edges = edgeCollection.iterator();
        double weight = -1.7976931348623157E308;
        if (!this._maximumAnalysis) {
            weight = Double.MAX_VALUE;
        }
        while (edges.hasNext()) {
            double nextWeight;
            Edge edge = (Edge)edges.next();
            if (this._maximumAnalysis) {
                nextWeight = this._edgeLengths.toDouble(edge);
                if (!(nextWeight > weight)) continue;
                weight = nextWeight;
                continue;
            }
            nextWeight = -this._edgeLengths.toDouble(edge);
            if (!(nextWeight < weight)) continue;
            weight = nextWeight;
        }
        return weight;
    }
}

