/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.graph.analysis.strategy;

import ptolemy.graph.DirectedGraph;
import ptolemy.graph.Graph;
import ptolemy.graph.analysis.analyzer.NegativeLengthCycleAnalyzer;
import ptolemy.graph.analysis.strategy.CachedStrategy;
import ptolemy.graph.analysis.strategy.FloydWarshallAllPairShortestPathStrategy;
import ptolemy.graph.mapping.ToDoubleMapping;

public class FloydWarshallNegativeLengthCycleStrategy
extends CachedStrategy
implements NegativeLengthCycleAnalyzer {
    private FloydWarshallAllPairShortestPathStrategy _strategy;
    private ToDoubleMapping _edgeLengths;

    public FloydWarshallNegativeLengthCycleStrategy(Graph graph, ToDoubleMapping edgeLengths) {
        super(graph);
        this._edgeLengths = edgeLengths;
        this._strategy = new FloydWarshallAllPairShortestPathStrategy(graph, this._edgeLengths);
    }

    public boolean hasNegativeLengthCycle() {
        return (Boolean)this._result();
    }

    public String toString() {
        return "Negative Length analyzer based on the Floyd-Warshall algorithm.";
    }

    public boolean valid() {
        return this.graph() instanceof DirectedGraph;
    }

    protected Object _compute() {
        double[][] allPairShortestPath = this._strategy.shortestPathMatrix();
        boolean negativeCycle = false;
        int n = this.graph().nodeCount();
        int i = 0;
        while (i < n) {
            if (allPairShortestPath[i][i] < 0.0) {
                negativeCycle = true;
                break;
            }
            ++i;
        }
        return negativeCycle;
    }
}

