/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.graph.analysis.strategy;

import java.util.ArrayList;
import java.util.List;
import ptolemy.graph.DirectedGraph;
import ptolemy.graph.Edge;
import ptolemy.graph.Graph;
import ptolemy.graph.Node;
import ptolemy.graph.analysis.analyzer.AllPairShortestPathAnalyzer;
import ptolemy.graph.analysis.strategy.FloydWarshallStrategy;
import ptolemy.graph.mapping.ToDoubleMapping;

public class FloydWarshallAllPairShortestPathStrategy
extends FloydWarshallStrategy
implements AllPairShortestPathAnalyzer {
    private ToDoubleMapping _edgeLengths;
    private int[][][] _predecessors;
    private int[][] _predecessorResult;
    private double[][][] _allPairShortestPath;

    public FloydWarshallAllPairShortestPathStrategy(Graph graph, ToDoubleMapping edgeLengths) {
        super(graph);
        this._edgeLengths = edgeLengths;
    }

    public List shortestPath(Node startNode, Node endNode) {
        ArrayList<Node> shortestPath = null;
        int startNodeLabel = this.graph().nodeLabel(startNode);
        int endNodeLabel = this.graph().nodeLabel(endNode);
        int[][] nodeLabels = this.predecessors();
        if (nodeLabels[startNodeLabel][endNodeLabel] != -1) {
            shortestPath = new ArrayList<Node>();
            shortestPath.add(endNode);
            Node nodeOnPath = endNode;
            while (nodeOnPath != startNode) {
                int nodeOnPathLabel = this.graph().nodeLabel(nodeOnPath);
                nodeOnPath = this.graph().node(nodeLabels[startNodeLabel][nodeOnPathLabel]);
                shortestPath.add(nodeOnPath);
            }
        }
        return shortestPath;
    }

    public double shortestPathLength(Node startNode, Node endNode) {
        double result = 0.0;
        double[][] shortestPathResults = (double[][])this._result();
        result = shortestPathResults[this.graph().nodeLabel(startNode)][this.graph().nodeLabel(endNode)];
        return result;
    }

    public double[][] shortestPathMatrix() {
        return (double[][])this._result();
    }

    public String toString() {
        return "All pair shortest path analyzer based on the Floyd-Warshall algorithm.";
    }

    public boolean valid() {
        return this.graph() instanceof DirectedGraph;
    }

    protected Object _compute() {
        int n = this.graph().nodeCount();
        this._allPairShortestPath = new double[n + 1][n][n];
        this._predecessors = new int[n + 1][n][n];
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                this._predecessors[0][i][j] = -1;
                this._allPairShortestPath[0][i][j] = Double.MAX_VALUE;
                ++j;
            }
            Node node = this.graph().node(i);
            for (Edge edge : ((DirectedGraph)this.graph()).outputEdges(node)) {
                int sinkLabel = ((DirectedGraph)this.graph()).nodeLabel(edge.sink());
                if (this._allPairShortestPath[0][i][sinkLabel] > this._edgeLengths.toDouble(edge)) {
                    this._allPairShortestPath[0][i][sinkLabel] = this._edgeLengths.toDouble(edge);
                }
                this._predecessors[0][i][sinkLabel] = i;
            }
            ++i;
        }
        super._compute();
        this._predecessorResult = this._predecessors[n];
        return this._allPairShortestPath[n];
    }

    protected final void _floydWarshallComputation(int k, int i, int j) {
        double b = Double.MAX_VALUE;
        double a = this._allPairShortestPath[k][i][j];
        if (i != k && k != j) {
            b = this._allPairShortestPath[k][i][k] + this._allPairShortestPath[k][k][j];
        } else if (i == k && k != j) {
            b = this._allPairShortestPath[k][k][j];
        } else if (i != k && k == j) {
            b = this._allPairShortestPath[k][i][k];
        }
        if (b >= a) {
            this._allPairShortestPath[k + 1][i][j] = a;
            this._predecessors[k + 1][i][j] = this._predecessors[k][i][j];
        } else {
            this._allPairShortestPath[k + 1][i][j] = b;
            this._predecessors[k + 1][i][j] = this._predecessors[k][k][j];
        }
    }

    private int[][] predecessors() {
        return this._predecessorResult;
    }
}

