/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.graph.analysis.strategy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import ptolemy.graph.DirectedGraph;
import ptolemy.graph.Edge;
import ptolemy.graph.Graph;
import ptolemy.graph.Node;
import ptolemy.graph.analysis.analyzer.SingleSourceLongestPathAnalyzer;
import ptolemy.graph.analysis.strategy.CachedStrategy;
import ptolemy.graph.analysis.strategy.FloydWarshallCycleExistenceStrategy;
import ptolemy.graph.mapping.ToDoubleMapping;

public class AllEdgeSingleSourceLongestPathStrategy
extends CachedStrategy
implements SingleSourceLongestPathAnalyzer {
    private ToDoubleMapping _edgeLengths;
    private Node _startNode;
    private int[] _predecessor;

    public AllEdgeSingleSourceLongestPathStrategy(Graph graph, Node startNode, ToDoubleMapping edgeLengths) {
        super(graph);
        this._startNode = startNode;
        this._edgeLengths = edgeLengths;
    }

    public double[] distance() {
        return (double[])this._result();
    }

    public Node getStartNode() {
        return this._startNode;
    }

    public List path(Node endNode) {
        int[] predecessors = this.predecessors();
        ArrayList<Node> pathNodes = new ArrayList<Node>();
        int predecessorsIndex = predecessors[this.graph().nodeLabel(endNode)];
        Node predecessor = null;
        if (predecessorsIndex != -1) {
            predecessor = this.graph().node(predecessorsIndex);
            do {
                pathNodes.add(predecessor);
            } while ((predecessorsIndex = predecessors[this.graph().nodeLabel(predecessor)]) != -1 && (predecessor = this.graph().node(predecessorsIndex)) != this._startNode);
            if (predecessor == this._startNode) {
                pathNodes.add(endNode);
            }
        }
        return pathNodes;
    }

    public double pathLength(Node endNode) {
        double[] distance = this.distance();
        return distance[this.graph().nodeLabel(endNode)];
    }

    public void setStartNode(Node startNode) {
        this._startNode = startNode;
        this.reset();
    }

    public String toString() {
        return "Single source longest path analyzer which runs in O(E) in which E is the number of edges.";
    }

    public boolean valid() {
        boolean result = false;
        if (this.graph() instanceof DirectedGraph) {
            FloydWarshallCycleExistenceStrategy analyzer = new FloydWarshallCycleExistenceStrategy(this.graph());
            result = !analyzer.hasCycle();
        }
        return result;
    }

    protected Object _compute() {
        DirectedGraph graph = (DirectedGraph)this.graph();
        ArrayList<Node> queue = new ArrayList<Node>();
        double[] distance = new double[graph.nodeCount()];
        this._predecessor = new int[graph.nodeCount()];
        for (Node node : graph.nodes()) {
            if (node != this._startNode) {
                distance[graph.nodeLabel((Node)node)] = -4.9E-324;
                this._predecessor[graph.nodeLabel((Node)node)] = -1;
                continue;
            }
            distance[graph.nodeLabel((Node)node)] = 0.0;
        }
        queue.add(this._startNode);
        this._predecessor[graph.nodeLabel((Node)this._startNode)] = -1;
        while (!queue.isEmpty()) {
            Node u = (Node)queue.get(0);
            Collection successors = graph.successors(u);
            if (successors != null) {
                for (Node v : successors) {
                    double predecessorDistance = distance[this.graph().nodeLabel(u)];
                    double actualDistance = distance[this.graph().nodeLabel(v)];
                    Collection edgeCollection = graph.predecessorEdges(v, u);
                    Iterator edges = edgeCollection.iterator();
                    double connectingEdgeCost = -1.7976931348623157E308;
                    while (edges.hasNext()) {
                        Edge edge = (Edge)edges.next();
                        if (!(this._edgeLengths.toDouble(edge) > connectingEdgeCost)) continue;
                        connectingEdgeCost = this._edgeLengths.toDouble(edge);
                    }
                    if (actualDistance < predecessorDistance + connectingEdgeCost) {
                        distance[graph.nodeLabel((Node)v)] = predecessorDistance + connectingEdgeCost;
                        this._predecessor[graph.nodeLabel((Node)v)] = graph.nodeLabel(u);
                    }
                    if (v == this._startNode) continue;
                    queue.add(v);
                }
            }
            queue.remove(0);
        }
        return distance;
    }

    private int[] predecessors() {
        return this._predecessor;
    }
}

