/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.graph.analysis;

import java.util.List;
import ptolemy.graph.Graph;
import ptolemy.graph.analysis.Analysis;
import ptolemy.graph.analysis.analyzer.Analyzer;
import ptolemy.graph.analysis.analyzer.CycleMeanAnalyzer;
import ptolemy.graph.analysis.strategy.KarpCycleMeanStrategy;
import ptolemy.graph.mapping.ToDoubleMapping;

public class CycleMeanAnalysis
extends Analysis {
    public CycleMeanAnalysis(Graph graph, ToDoubleMapping edgeLengths) {
        super(new KarpCycleMeanStrategy(graph, edgeLengths));
    }

    public CycleMeanAnalysis(CycleMeanAnalyzer analyzer) {
        super(analyzer);
    }

    public List cycle() {
        return ((CycleMeanAnalyzer)this.analyzer()).cycle();
    }

    public double maximumCycleMean() {
        return ((CycleMeanAnalyzer)this.analyzer()).maximumCycleMean();
    }

    public double minimumCycleMean() {
        return ((CycleMeanAnalyzer)this.analyzer()).minimumCycleMean();
    }

    public String toString() {
        return "Cycle mean analysis using the following analyzer:\n" + this.analyzer().toString();
    }

    public boolean validAnalyzerInterface(Analyzer analyzer) {
        return analyzer instanceof CycleMeanAnalyzer;
    }
}

