/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.graph;

import ptolemy.graph.Element;
import ptolemy.graph.Node;

public final class Edge
extends Element {
    private Node _sink;
    private Node _source;

    public Edge(Node source, Node sink) {
        this._source = source;
        this._sink = sink;
    }

    public Edge(Node source, Node sink, Object weight) {
        this(source, sink);
        this.setWeight(weight);
    }

    public String descriptor() {
        return "edge";
    }

    public boolean isSelfLoop() {
        return this._source == this._sink;
    }

    public Node sink() {
        return this._sink;
    }

    public Node source() {
        return this._source;
    }

    public String toString(boolean showWeight) {
        String result = "(" + this._source + ", " + this._sink;
        if (showWeight && this.hasWeight()) {
            result = String.valueOf(result) + ", " + this._weight;
        }
        result = String.valueOf(result) + ")";
        return result;
    }

    public String toString() {
        return this.toString(true);
    }
}

