/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data.unit;

import java.util.Vector;
import ptolemy.data.unit.BaseUnit;
import ptolemy.data.unit.UnitExpr;
import ptolemy.data.unit.UnitLibrary;
import ptolemy.data.unit.UnitPresentation;
import ptolemy.data.unit.UnitTerm;
import ptolemy.data.unit.UnitUtilities;

public class Unit
implements UnitPresentation {
    Vector _labels = new Vector();
    private static int _noLabelCounter = 0;
    private double _scale = 1.0;
    int[] _type = new int[UnitLibrary.getNumCategories()];

    public Unit() {
        int i = 0;
        while (i < UnitLibrary.getNumCategories()) {
            this._type[i] = 0;
            ++i;
        }
        this._labels.add("noLabel" + _noLabelCounter++);
    }

    public Unit(BaseUnit bu) {
        this();
        String name = bu.getName();
        this.setPrimaryLabel(name);
        int index = UnitUtilities.getUnitCategoryIndex(name);
        this._type[index] = 1;
    }

    public Unit(String name) {
        this();
        this.setPrimaryLabel(name);
    }

    public Unit copy() {
        Unit retv = new Unit();
        retv._setLabels((Vector)this.getLabels().clone());
        int[] newExponents = retv.getType();
        int i = 0;
        while (i < UnitLibrary.getNumCategories()) {
            newExponents[i] = this._type[i];
            ++i;
        }
        retv.setScale(this.getScale());
        return retv;
    }

    public String descriptiveForm() {
        StringBuffer retv = null;
        Unit unit = UnitLibrary.getUnit(this);
        if (unit != null) {
            return unit.getPrimaryLabel();
        }
        UnitExpr factorization = this.factor();
        if (factorization != null) {
            Vector<UnitTerm> numerator = new Vector<UnitTerm>();
            Vector<UnitTerm> denominator = new Vector<UnitTerm>();
            Vector uTerms = factorization.getUTerms();
            int i = 0;
            while (i < uTerms.size()) {
                UnitTerm uterm = (UnitTerm)uTerms.elementAt(i);
                if (uterm.getExponent() < 0) {
                    denominator.add(uterm.invert());
                } else if (uterm.getExponent() > 0) {
                    numerator.add(uterm);
                }
                ++i;
            }
            if (numerator.size() == 0) {
                retv = new StringBuffer("1");
            } else {
                retv = new StringBuffer(((UnitTerm)numerator.elementAt(0)).getUnit().getPrimaryLabel());
                i = 1;
                while (i < numerator.size()) {
                    retv.append(" " + ((UnitTerm)numerator.elementAt(i)).getUnit().getPrimaryLabel());
                    ++i;
                }
            }
            if (denominator.size() > 0) {
                retv.append("/" + ((UnitTerm)denominator.elementAt(0)).getUnit().getPrimaryLabel());
                i = 1;
                while (i < denominator.size()) {
                    retv.append(" " + ((UnitTerm)denominator.elementAt(i)).getUnit().getPrimaryLabel());
                    ++i;
                }
            }
            return retv.toString();
        }
        if (this._scale == 1.0) {
            int numCats = this._type.length;
            StringBuffer desc = new StringBuffer();
            int i = 0;
            while (i < numCats) {
                if (this._type[i] != 0) {
                    Unit baseUnit = UnitLibrary.getBaseUnit(i);
                    if (this._type[i] == 1) {
                        desc.append(" " + baseUnit.getPrimaryLabel());
                    } else {
                        desc.append(" " + baseUnit.getPrimaryLabel() + "^" + this._type[i]);
                    }
                }
                ++i;
            }
            return desc.toString().substring(1);
        }
        return this.toString();
    }

    public Unit divideBy(Unit divisor) {
        Unit retv = this.copy();
        int[] otherExponents = divisor.getType();
        int[] thisExponents = retv.getType();
        int i = 0;
        while (i < UnitLibrary.getNumCategories()) {
            int n = i;
            thisExponents[n] = thisExponents[n] - otherExponents[i];
            ++i;
        }
        retv.setType(thisExponents);
        retv.setScale(retv.getScale() / divisor.getScale());
        return retv;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        Unit otherUnit = null;
        if (!(object instanceof Unit)) {
            return false;
        }
        otherUnit = (Unit)object;
        int[] otherExponents = otherUnit.getType();
        int i = 0;
        while (i < UnitLibrary.getNumCategories()) {
            if (this._type[i] != otherExponents[i]) {
                return false;
            }
            ++i;
        }
        if (this._scale != otherUnit.getScale()) {
            return false;
        }
        return this.getLabelsString().equals(otherUnit.getLabelsString());
    }

    public UnitExpr factor() {
        Unit xx;
        Unit factor;
        Unit invert = UnitLibrary.getUnit(this.invert());
        if (invert != null) {
            UnitExpr retv = new UnitExpr();
            UnitTerm uTerm = new UnitTerm(invert);
            uTerm.setExponent(-1);
            retv.addUnitTerm(uTerm);
            return retv;
        }
        Vector libraryUnits = UnitLibrary.getLibrary();
        int i = 0;
        while (i < libraryUnits.size()) {
            factor = (Unit)libraryUnits.elementAt(i);
            Unit numerator = this.multiplyBy(factor);
            xx = UnitLibrary.getUnit(numerator);
            if (xx != null) {
                UnitExpr retv = new UnitExpr();
                if (xx != UnitLibrary.Identity) {
                    UnitTerm uTerm1 = new UnitTerm(xx);
                    retv.addUnitTerm(uTerm1);
                }
                UnitTerm uTerm2 = new UnitTerm(factor);
                uTerm2.setExponent(-1);
                retv.addUnitTerm(uTerm2);
                return retv;
            }
            ++i;
        }
        i = 0;
        while (i < libraryUnits.size()) {
            factor = (Unit)libraryUnits.elementAt(i);
            Unit remainder = this.divideBy(factor);
            xx = UnitLibrary.getUnit(remainder);
            if (xx != null && xx != UnitLibrary.Identity) {
                UnitExpr retv = new UnitExpr();
                UnitTerm uTerm = new UnitTerm(factor);
                retv.addUnitTerm(uTerm);
                uTerm = new UnitTerm(xx);
                retv.addUnitTerm(uTerm);
                return retv;
            }
            ++i;
        }
        return null;
    }

    public Vector getLabels() {
        return this._labels;
    }

    public String getLabelsString() {
        StringBuffer retv = null;
        if (this._labels.size() <= 0) {
            return "";
        }
        retv = new StringBuffer((String)this._labels.elementAt(0));
        int i = 1;
        while (i < this._labels.size()) {
            retv.append(String.valueOf((String)this._labels.elementAt(i)) + ",");
            ++i;
        }
        return retv.toString();
    }

    public String getPrimaryLabel() {
        return (String)this._labels.elementAt(0);
    }

    public double getScale() {
        return this._scale;
    }

    public int[] getType() {
        return this._type;
    }

    public int hashCode() {
        int hashCode = this.getLabelsString().hashCode();
        int i = 0;
        while (i < UnitLibrary.getNumCategories()) {
            hashCode >>>= this._type[i];
            ++i;
        }
        return hashCode >>>= Double.valueOf(this._scale).hashCode();
    }

    public boolean hasSameType(Unit otherUnit) {
        int[] otherType = otherUnit.getType();
        int i = 0;
        while (i < UnitLibrary.getNumCategories()) {
            if (this._type[i] != otherType[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Unit invert() {
        Unit retv = new Unit();
        int[] otherExponents = this.getType();
        int[] exponents = new int[UnitLibrary.getNumCategories()];
        int i = 0;
        while (i < UnitLibrary.getNumCategories()) {
            exponents[i] = -otherExponents[i];
            ++i;
        }
        retv.setType(exponents);
        retv.setScale(1.0 / this.getScale());
        return retv;
    }

    public Unit multiplyBy(Unit multiplicand) {
        Unit retv = this.copy();
        int[] otherExponents = multiplicand.getType();
        int[] thisExponents = retv.getType();
        int i = 0;
        while (i < UnitLibrary.getNumCategories()) {
            int n = i;
            thisExponents[n] = thisExponents[n] + otherExponents[i];
            ++i;
        }
        retv.setType(thisExponents);
        retv.setScale(retv.getScale() * multiplicand.getScale());
        return retv;
    }

    public Unit pow(double power) {
        Unit unit = this.copy();
        int[] exponents = unit.getType();
        double scale = unit.getScale();
        int i = 0;
        while (i < UnitLibrary.getNumCategories()) {
            int n = i++;
            exponents[n] = (int)((double)exponents[n] * power);
        }
        scale = Math.pow(scale, power);
        unit.setType(exponents);
        unit.setScale(scale);
        return unit;
    }

    public void setPrimaryLabel(String label) {
        this._labels.setElementAt(label, 0);
    }

    public void setScale(double d) {
        this._scale = d;
    }

    public void setType(int[] type) {
        this._type = type;
    }

    public String toString() {
        StringBuffer retv = new StringBuffer("Unit:(" + this.getLabelsString() + ") " + this._scale + "*<" + this._type[0]);
        int i = 1;
        while (i < UnitLibrary.getNumCategories()) {
            retv.append(", " + this._type[i]);
            ++i;
        }
        retv.append(">");
        return retv.toString();
    }

    protected void _setLabels(Vector labels) {
        this._labels = labels;
    }
}

