/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data.unit;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Vector;
import ptolemy.actor.IOPort;
import ptolemy.data.unit.Unit;
import ptolemy.kernel.ComponentEntity;

public class Bindings {
    Hashtable _VarLabel2Unit = new Hashtable();
    LinkedHashSet _keys = new LinkedHashSet();

    public Bindings() {
    }

    public Bindings(Vector nodes) {
        int i = 0;
        while (i < nodes.size()) {
            ComponentEntity actor = (ComponentEntity)nodes.elementAt(i);
            for (IOPort actorPort : actor.portList()) {
                String varLabel = String.valueOf(actor.getName()) + "." + actorPort.getName();
                this.put(varLabel, null);
            }
            ++i;
        }
    }

    public boolean bindingExists(String vLabel) {
        for (String key : this._keys) {
            if (!key.equals(vLabel)) continue;
            return true;
        }
        return false;
    }

    public Unit get(String vLabel) {
        Unit u = (Unit)this._VarLabel2Unit.get(vLabel);
        return u;
    }

    public String humanReadableForm() {
        StringBuffer retv = new StringBuffer("Bindings\n");
        for (String varLabel : this._keys) {
            Unit unit = (Unit)this._VarLabel2Unit.get(varLabel);
            String unitExpr = "null";
            if (unit != null) {
                unitExpr = unit.descriptiveForm();
            }
            retv.append("   " + varLabel + " = " + unitExpr + "\n");
        }
        retv.append("\\Bindings\n");
        return retv.toString();
    }

    public void put(String varLabel, Unit U) {
        this._keys.add(varLabel);
        if (U != null) {
            this._VarLabel2Unit.put(varLabel, U);
        }
    }

    public String[] variableLabels() {
        String[] retv = new String[this._keys.size()];
        Iterator iter = this._keys.iterator();
        int i = 0;
        while (iter.hasNext()) {
            retv[i++] = (String)iter.next();
        }
        return retv;
    }
}

