/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data.type;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ptolemy.data.Token;
import ptolemy.data.UnionToken;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.StructuredType;
import ptolemy.data.type.Type;
import ptolemy.data.type.TypeLattice;
import ptolemy.graph.InequalityTerm;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;

public class UnionType
extends StructuredType {
    private Map _fields = new HashMap();
    private static UnionType _representative = new UnionType(new String[0], new Type[0]);

    public UnionType(String[] labels, Type[] types) {
        if (labels.length != types.length) {
            throw new IllegalArgumentException("UnionType: the labels and types arrays do not have the same size.");
        }
        int i = 0;
        while (i < labels.length) {
            FieldType fieldType = new FieldType(types[i]);
            this._fields.put(labels[i], fieldType);
            ++i;
        }
    }

    public Object clone() {
        if (this.isConstant()) {
            return this;
        }
        Object[] labelsObj = this._fields.keySet().toArray();
        String[] labels = new String[labelsObj.length];
        Type[] types = new Type[labelsObj.length];
        int i = 0;
        while (i < labels.length) {
            labels[i] = (String)labelsObj[i];
            FieldType fieldType = (FieldType)this._fields.get(labels[i]);
            types[i] = fieldType._declaredType;
            ++i;
        }
        UnionType newObj = new UnionType(labels, types);
        try {
            newObj.updateType(this);
        }
        catch (IllegalActionException ex) {
            throw new InternalErrorException("UnionType.clone: Cannot update new instance. " + ex.getMessage());
        }
        return newObj;
    }

    public Token convert(Token token) throws IllegalActionException {
        if (!this.isCompatible(token.getType())) {
            throw new IllegalArgumentException(Token.notSupportedConversionMessage(token, this.toString()));
        }
        UnionToken unionToken = (UnionToken)token;
        String label = unionToken.label();
        Type newType = this.get(label);
        Token newValue = newType.convert(unionToken.value());
        return new UnionToken(label, newValue);
    }

    public int depth() {
        Object[] labelsObj = this._fields.keySet().toArray();
        String[] labels = new String[labelsObj.length];
        int[] depth = new int[labelsObj.length];
        int maxDepth = 1;
        int i = 0;
        while (i < labels.length) {
            labels[i] = (String)labelsObj[i];
            Type fieldType = this.get(labels[i]);
            depth[i] = 1;
            if (fieldType instanceof StructuredType) {
                int n = i;
                depth[n] = depth[n] + ((StructuredType)fieldType).depth();
            }
            if (depth[i] > maxDepth) {
                maxDepth = depth[i];
            }
            ++i;
        }
        return maxDepth;
    }

    public boolean equals(Object object) {
        Set argLabelSet;
        if (!(object instanceof UnionType)) {
            return false;
        }
        UnionType unionType = (UnionType)object;
        Set myLabelSet = this._fields.keySet();
        if (!myLabelSet.equals(argLabelSet = unionType._fields.keySet())) {
            return false;
        }
        for (String label : myLabelSet) {
            Type argType;
            Type myType = this.get(label);
            if (myType.equals(argType = unionType.get(label))) continue;
            return false;
        }
        return true;
    }

    public Type get(String label) {
        FieldType fieldType = (FieldType)this._fields.get(label);
        if (fieldType == null) {
            return null;
        }
        return fieldType._resolvedType;
    }

    public Class getTokenClass() {
        return UnionToken.class;
    }

    public InequalityTerm getTypeTerm(String label) {
        return (InequalityTerm)this._fields.get(label);
    }

    public int hashCode() {
        return this._fields.keySet().hashCode() + 2917;
    }

    public void initialize(Type type) {
        try {
            for (String label : this._fields.keySet()) {
                FieldType fieldType = (FieldType)this._fields.get(label);
                if (!fieldType.isSettable()) continue;
                fieldType.initialize(type);
            }
        }
        catch (IllegalActionException iae) {
            throw new InternalErrorException("UnionType.initialize: Cannot initialize the element type to " + type + " " + iae.getMessage());
        }
    }

    public boolean isAbstract() {
        for (String label : this._fields.keySet()) {
            Type type = this.get(label);
            if (!type.isAbstract()) continue;
            return true;
        }
        return false;
    }

    public boolean isCompatible(Type type) {
        if (type.equals(BaseType.UNKNOWN)) {
            return true;
        }
        if (!(type instanceof UnionType)) {
            return false;
        }
        UnionType argumentUnionType = (UnionType)type;
        for (String label : argumentUnionType.labelSet()) {
            Type myFieldType = this.get(label);
            if (myFieldType == null) {
                return false;
            }
            Type argumentFieldType = argumentUnionType.get(label);
            if (myFieldType.isCompatible(argumentFieldType)) continue;
            return false;
        }
        return true;
    }

    public boolean isConstant() {
        for (FieldType fieldType : this._fields.values()) {
            Type type = fieldType._declaredType;
            if (type.isConstant()) continue;
            return false;
        }
        return true;
    }

    public boolean isInstantiable() {
        for (String label : this._fields.keySet()) {
            Type type = this.get(label);
            if (type.isInstantiable()) continue;
            return false;
        }
        return true;
    }

    public boolean isSubstitutionInstance(Type type) {
        Set argLabelSet;
        if (!(type instanceof UnionType)) {
            return false;
        }
        UnionType unionType = (UnionType)type;
        Set myLabelSet = this._fields.keySet();
        if (!myLabelSet.equals(argLabelSet = unionType._fields.keySet())) {
            return false;
        }
        for (String label : myLabelSet) {
            Type argType;
            FieldType fieldType = (FieldType)this._fields.get(label);
            Type myDeclaredType = fieldType._declaredType;
            if (myDeclaredType.isSubstitutionInstance(argType = unionType.get(label))) continue;
            return false;
        }
        return true;
    }

    public Set labelSet() {
        return this._fields.keySet();
    }

    public String toString() {
        Object[] labelArray = this._fields.keySet().toArray();
        int size = labelArray.length;
        int i = 0;
        while (i < size - 1) {
            int j = i + 1;
            while (j < size) {
                String labeli = (String)labelArray[i];
                String labelj = (String)labelArray[j];
                if (labeli.compareTo(labelj) >= 0) {
                    Object temp = labelArray[i];
                    labelArray[i] = labelArray[j];
                    labelArray[j] = temp;
                }
                ++j;
            }
            ++i;
        }
        StringBuffer results = new StringBuffer("{|");
        int i2 = 0;
        while (i2 < size) {
            String label = (String)labelArray[i2];
            String type = this.get(label).toString();
            if (i2 != 0) {
                results.append(", ");
            }
            results.append(String.valueOf(label) + " = " + type);
            ++i2;
        }
        return String.valueOf(results.toString()) + "|}";
    }

    public void updateType(StructuredType newType) throws IllegalActionException {
        if (this.isConstant()) {
            if (this.equals(newType)) {
                return;
            }
            throw new IllegalActionException("UnionType.updateType: This type is a constant and the argument is not the same as this type. This type: " + this.toString() + " argument: " + newType.toString());
        }
        if (!this.isSubstitutionInstance(newType)) {
            throw new IllegalActionException("UnionType.updateType: Cannot update this type to the new type.");
        }
        for (String label : this._fields.keySet()) {
            FieldType fieldType = (FieldType)this._fields.get(label);
            if (!fieldType.isSettable()) continue;
            Type newFieldType = ((UnionType)newType).get(label);
            fieldType.setValue(newFieldType);
        }
    }

    protected int _compare(StructuredType type) {
        if (!(type instanceof UnionType)) {
            throw new IllegalArgumentException("UnionType._compare: The argument is not a UnionType.");
        }
        if (this.equals(type)) {
            return 0;
        }
        if (this._isLessThanOrEqualTo(this, (UnionType)type)) {
            return -1;
        }
        if (this._isLessThanOrEqualTo((UnionType)type, this)) {
            return 1;
        }
        return 2;
    }

    protected StructuredType _getRepresentative() {
        return _representative;
    }

    protected StructuredType _greatestLowerBound(StructuredType type) {
        if (!(type instanceof UnionType)) {
            throw new IllegalArgumentException("UnionType.greatestLowerBound: The argument is not a UnionType.");
        }
        UnionType unionType = (UnionType)type;
        HashSet intersectionSet = new HashSet();
        Set myLabelSet = this._fields.keySet();
        Set argLabelSet = unionType._fields.keySet();
        intersectionSet.addAll(myLabelSet);
        intersectionSet.retainAll(argLabelSet);
        Object[] labelArray = intersectionSet.toArray();
        int size = labelArray.length;
        String[] labels = new String[size];
        Type[] types = new Type[size];
        int i = 0;
        while (i < size) {
            labels[i] = (String)labelArray[i];
            Type type1 = this.get(labels[i]);
            Type type2 = unionType.get(labels[i]);
            types[i] = (Type)TypeLattice.lattice().greatestLowerBound(type1, type2);
            ++i;
        }
        return new UnionType(labels, types);
    }

    protected StructuredType _leastUpperBound(StructuredType type) {
        if (!(type instanceof UnionType)) {
            throw new IllegalArgumentException("UnionType.leastUpperBound: The argument is not a UnionType.");
        }
        UnionType unionType = (UnionType)type;
        HashSet unionSet = new HashSet();
        Set myLabelSet = this._fields.keySet();
        Set argLabelSet = unionType._fields.keySet();
        unionSet.addAll(myLabelSet);
        unionSet.addAll(argLabelSet);
        Object[] labelArray = unionSet.toArray();
        int size = labelArray.length;
        String[] labels = new String[size];
        Type[] types = new Type[size];
        int i = 0;
        while (i < size) {
            labels[i] = (String)labelArray[i];
            Type type1 = this.get(labels[i]);
            Type type2 = unionType.get(labels[i]);
            types[i] = type1 == null ? type2 : (type2 == null ? type1 : (Type)TypeLattice.lattice().greatestLowerBound(type1, type2));
            ++i;
        }
        return new UnionType(labels, types);
    }

    private boolean _isLessThanOrEqualTo(UnionType t1, UnionType t2) {
        Set labelSet1 = t1._fields.keySet();
        Set labelSet2 = t2._fields.keySet();
        if (!labelSet2.containsAll(labelSet1)) {
            return false;
        }
        for (String label : labelSet1) {
            Type type2;
            Type type1 = t1.get(label);
            int result = TypeLattice.compare(type1, type2 = t2.get(label));
            if (result != 1 && result != 2) continue;
            return false;
        }
        return true;
    }

    private class FieldType
    implements InequalityTerm {
        private Type _declaredType = null;
        private Type _resolvedType = null;

        private FieldType(Type declaredType) {
            try {
                this._resolvedType = this._declaredType = (Type)declaredType.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalErrorException("UnionType.FieldType: The specified type cannot be cloned.");
            }
        }

        public Object getAssociatedObject() {
            return UnionType.this;
        }

        public Object getValue() {
            return this._resolvedType;
        }

        public InequalityTerm[] getVariables() {
            if (this.isSettable()) {
                InequalityTerm[] variable = new InequalityTerm[]{this};
                return variable;
            }
            return new InequalityTerm[0];
        }

        public void initialize(Object e) throws IllegalActionException {
            if (!this.isSettable()) {
                throw new IllegalActionException("UnionType$FieldType.initialize: The type is not settable.");
            }
            if (!(e instanceof Type)) {
                throw new IllegalActionException("FieldType.initialize: The argument is not a Type.");
            }
            if (this._declaredType == BaseType.UNKNOWN) {
                this._resolvedType = (Type)e;
            } else {
                ((StructuredType)this._resolvedType).initialize((Type)e);
            }
        }

        public boolean isSettable() {
            return !this._declaredType.isConstant();
        }

        public boolean isValueAcceptable() {
            return this._resolvedType.isInstantiable();
        }

        public void setValue(Object e) throws IllegalActionException {
            if (!this.isSettable()) {
                throw new IllegalActionException("UnionType$FieldType.setValue: The type is not settable.");
            }
            if (!this._declaredType.isSubstitutionInstance((Type)e)) {
                throw new IllegalActionException("FieldType.setValue: Cannot update the field type of this UnionType to the new type. Field type: " + this._declaredType.toString() + ", New type: " + e.toString());
            }
            if (this._declaredType == BaseType.UNKNOWN) {
                try {
                    this._resolvedType = (Type)((Type)e).clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw new InternalErrorException("UnionType$FieldType.setValue: The specified type cannot be cloned.");
                }
            } else {
                ((StructuredType)this._resolvedType).updateType((StructuredType)e);
            }
        }

        public String toString() {
            return "(UnionFieldType, " + this.getValue() + ")";
        }
    }
}

