/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data.type;

import ptolemy.data.type.Type;
import ptolemy.data.type.TypeLattice;
import ptolemy.kernel.util.IllegalActionException;

public abstract class StructuredType
implements Type {
    protected static final int MAXDEPTHBOUND = 20;

    public Type add(Type rightArgumentType) {
        return TypeLattice.leastUpperBound(this, rightArgumentType);
    }

    public abstract Object clone() throws CloneNotSupportedException;

    public Type divide(Type rightArgumentType) {
        return TypeLattice.leastUpperBound(this, rightArgumentType);
    }

    public int depth() {
        return 1;
    }

    public int getTypeHash() {
        return Integer.MIN_VALUE;
    }

    public boolean isAbstract() {
        return true;
    }

    public abstract void initialize(Type var1);

    public Type modulo(Type rightArgumentType) {
        return TypeLattice.leastUpperBound(this, rightArgumentType);
    }

    public Type multiply(Type rightArgumentType) {
        return TypeLattice.leastUpperBound(this, rightArgumentType);
    }

    public Type one() {
        return this;
    }

    public Type subtract(Type rightArgumentType) {
        return TypeLattice.leastUpperBound(this, rightArgumentType);
    }

    public void updateType(StructuredType newType) throws IllegalActionException {
        if (newType.depth() >= 20) {
            throw new IllegalActionException("Large type structure detected during type resolution.  The structured type " + newType.toString() + " has depth larger than the bound " + 20 + ".  This may be an indicator of type constraints " + "in a model with no finite solution.");
        }
    }

    public Type zero() {
        return this;
    }

    protected abstract int _compare(StructuredType var1);

    protected abstract StructuredType _getRepresentative();

    protected abstract StructuredType _greatestLowerBound(StructuredType var1);

    protected abstract StructuredType _leastUpperBound(StructuredType var1);
}

