/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data.type;

import java.io.Serializable;
import ptolemy.data.FixToken;
import ptolemy.data.Token;
import ptolemy.data.type.StructuredType;
import ptolemy.data.type.Type;
import ptolemy.data.type.TypeLattice;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.math.FixPoint;
import ptolemy.math.FixPointQuantization;
import ptolemy.math.Overflow;
import ptolemy.math.Precision;
import ptolemy.math.Rounding;

public class FixType
extends StructuredType
implements Serializable {
    public static final FixType BOTTOM = new FixType();
    private Precision _precision;

    public FixType() {
        this._precision = new Precision(0, 0);
    }

    public FixType(Precision precision) {
        this._precision = precision;
    }

    public Type add(Type rightArgumentType) {
        if (rightArgumentType instanceof FixType) {
            Precision rPrecision = ((FixType)rightArgumentType).getPrecision();
            Precision newPrecision = FixPoint.addPrecision(rPrecision, this._precision);
            FixType returnType = new FixType(newPrecision);
            return returnType;
        }
        return TypeLattice.leastUpperBound(this, rightArgumentType);
    }

    public Object clone() {
        return this;
    }

    public Token convert(Token token) throws IllegalActionException {
        if (token.getType() instanceof FixType && (this._compare((FixType)token.getType()) == 0 || this._compare((FixType)token.getType()) == 1)) {
            return ((FixToken)token).quantize(new FixPointQuantization(this.getPrecision(), Overflow.GROW, Rounding.HALF_EVEN));
        }
        throw new IllegalActionException(Token.notSupportedConversionMessage(token, this.toString()));
    }

    public Type divide(Type rightArgumentType) {
        if (rightArgumentType instanceof FixType) {
            if (rightArgumentType instanceof FixType) {
                Precision rPrecision = ((FixType)rightArgumentType).getPrecision();
                Precision newPrecision = FixPoint.dividePrecision(rPrecision, this._precision);
                FixType returnType = new FixType(newPrecision);
                return returnType;
            }
            return TypeLattice.leastUpperBound(this, rightArgumentType);
        }
        return TypeLattice.leastUpperBound(this, rightArgumentType);
    }

    public boolean equals(Object object) {
        if (!(object instanceof FixType)) {
            return false;
        }
        Precision precision = ((FixType)object).getPrecision();
        return precision.equals(this._precision);
    }

    public Precision getPrecision() {
        return this._precision;
    }

    public Class getTokenClass() {
        return FixToken.class;
    }

    public int hashCode() {
        return this.getTokenClass().hashCode();
    }

    public void initialize(Type type) {
    }

    public boolean isAbstract() {
        return !this.isInstantiable();
    }

    public boolean isCompatible(Type type) {
        int typeInfo = TypeLattice.compare((Type)this, type);
        return typeInfo == 0 || typeInfo == 1;
    }

    public boolean isConstant() {
        return true;
    }

    public boolean isInstantiable() {
        return this._precision.getNumberOfBits() != 0;
    }

    public boolean isSubstitutionInstance(Type type) {
        if (type instanceof StructuredType) {
            return ((StructuredType)type)._getRepresentative() == this._getRepresentative();
        }
        return false;
    }

    public Type modulo(Type rightArgumentType) {
        return TypeLattice.leastUpperBound(this, rightArgumentType);
    }

    public Type multiply(Type rightArgumentType) {
        if (rightArgumentType instanceof FixType) {
            Precision rPrecision = ((FixType)rightArgumentType).getPrecision();
            Precision newPrecision = FixPoint.multiplyPrecision(rPrecision, this._precision);
            FixType returnType = new FixType(newPrecision);
            return returnType;
        }
        return TypeLattice.leastUpperBound(this, rightArgumentType);
    }

    public Type one() {
        return this;
    }

    public Type subtract(Type rightArgumentType) {
        if (rightArgumentType instanceof FixType) {
            Precision rPrecision = ((FixType)rightArgumentType).getPrecision();
            Precision newPrecision = FixPoint.subtractPrecision(rPrecision, this._precision);
            FixType returnType = new FixType(newPrecision);
            return returnType;
        }
        return TypeLattice.leastUpperBound(this, rightArgumentType);
    }

    public String toString() {
        return "fixedpoint" + this._precision.toString(Precision.EXPRESSION_LANGUAGE);
    }

    public void updateType(StructuredType newType) throws IllegalActionException {
        super.updateType(newType);
        if (newType._getRepresentative() != this._getRepresentative()) {
            throw new InternalErrorException("FixType.updateType: Cannot updateType the element type to " + newType + ".");
        }
    }

    public Type zero() {
        return this;
    }

    protected int _compare(StructuredType type) {
        if (!(type instanceof FixType)) {
            throw new IllegalArgumentException("FixType._compare: The argument is not a FixType.");
        }
        Precision precision = ((FixType)type).getPrecision();
        int fractionBits1 = this._precision.getFractionBitLength();
        int fractionBits2 = precision.getFractionBitLength();
        int integerBits1 = this._precision.getFractionBitLength();
        int integerBits2 = precision.getFractionBitLength();
        boolean signBit1 = this._precision.isSigned();
        boolean signBit2 = precision.isSigned();
        if (this._precision.equals(precision)) {
            return 0;
        }
        if (signBit1 == signBit2) {
            int compareBits2;
            int compareBits1;
            if (fractionBits1 < fractionBits2 && integerBits1 < integerBits2) {
                return -1;
            }
            if (fractionBits1 > fractionBits2 && integerBits1 > integerBits2) {
                return 1;
            }
            if (integerBits1 == integerBits2) {
                compareBits1 = fractionBits1;
                compareBits2 = fractionBits2;
            } else {
                compareBits1 = integerBits1;
                compareBits2 = integerBits2;
            }
            if (compareBits1 < compareBits2) {
                return -1;
            }
            if (compareBits1 > compareBits2) {
                return 1;
            }
            return 0;
        }
        if (signBit1 && !signBit2) {
            if (fractionBits1 >= fractionBits2 && integerBits1 >= integerBits2) {
                return 1;
            }
        } else if (fractionBits1 <= fractionBits2 && integerBits1 <= integerBits2) {
            return -1;
        }
        return 2;
    }

    protected StructuredType _getRepresentative() {
        return BOTTOM;
    }

    protected StructuredType _greatestLowerBound(StructuredType type) {
        if (!(type instanceof FixType)) {
            throw new IllegalArgumentException("FixType._greatestLowerBound: The argument is not a FixType.");
        }
        Precision precision = ((FixType)type).getPrecision();
        int fractionBits = Math.min(precision.getFractionBitLength(), this._precision.getFractionBitLength());
        int integerBits = Math.min(precision.getIntegerBitLength(), this._precision.getIntegerBitLength());
        return new FixType(new Precision(fractionBits + integerBits, integerBits));
    }

    protected StructuredType _leastUpperBound(StructuredType type) {
        if (!(type instanceof FixType)) {
            throw new IllegalArgumentException("FixType._greatestLowerBound: The argument is not a FixType.");
        }
        Precision precision = ((FixType)type).getPrecision();
        int fractionBits = Math.max(precision.getFractionBitLength(), this._precision.getFractionBitLength());
        int integerBits = Math.max(precision.getIntegerBitLength(), this._precision.getIntegerBitLength());
        FixType returnType = new FixType(new Precision(fractionBits + integerBits, integerBits));
        returnType._checkPrecision();
        return returnType;
    }

    protected void _checkPrecision() {
        if (this._precision.getNumberOfBits() > 128) {
            throw new RuntimeException("Large fixed point type detected during type resolution.  The structured type " + this + " has depth larger than the bound " + 128 + ".  This may be an indicator of type constraints " + "in a model with no finite solution, which may occur " + "if there is a feedback loop that requires an " + "explicit FixToFix conversion actor.");
        }
    }
}

