/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data.expr;

import java.util.List;
import java.util.Set;
import ptolemy.data.ArrayToken;
import ptolemy.data.BitwiseOperationToken;
import ptolemy.data.BooleanToken;
import ptolemy.data.FunctionToken;
import ptolemy.data.IntToken;
import ptolemy.data.MatrixToken;
import ptolemy.data.RecordToken;
import ptolemy.data.ScalarToken;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.UnionToken;
import ptolemy.data.expr.ASTPtArrayConstructNode;
import ptolemy.data.expr.ASTPtBitwiseNode;
import ptolemy.data.expr.ASTPtFunctionApplicationNode;
import ptolemy.data.expr.ASTPtFunctionDefinitionNode;
import ptolemy.data.expr.ASTPtFunctionalIfNode;
import ptolemy.data.expr.ASTPtLeafNode;
import ptolemy.data.expr.ASTPtLogicalNode;
import ptolemy.data.expr.ASTPtMatrixConstructNode;
import ptolemy.data.expr.ASTPtMethodCallNode;
import ptolemy.data.expr.ASTPtPowerNode;
import ptolemy.data.expr.ASTPtProductNode;
import ptolemy.data.expr.ASTPtRecordConstructNode;
import ptolemy.data.expr.ASTPtRelationalNode;
import ptolemy.data.expr.ASTPtRootNode;
import ptolemy.data.expr.ASTPtShiftNode;
import ptolemy.data.expr.ASTPtSumNode;
import ptolemy.data.expr.ASTPtUnaryNode;
import ptolemy.data.expr.ASTPtUnionConstructNode;
import ptolemy.data.expr.AbstractParseTreeVisitor;
import ptolemy.data.expr.CachedMethod;
import ptolemy.data.expr.Constants;
import ptolemy.data.expr.ExpressionFunction;
import ptolemy.data.expr.MatlabUtilities;
import ptolemy.data.expr.ParseTreeFreeVariableCollector;
import ptolemy.data.expr.ParseTreeSpecializer;
import ptolemy.data.expr.ParseTreeTypeInference;
import ptolemy.data.expr.ParserScope;
import ptolemy.data.expr.PtParser;
import ptolemy.data.expr.UndefinedConstantOrIdentifierException;
import ptolemy.data.type.FunctionType;
import ptolemy.data.type.Type;
import ptolemy.data.type.TypeLattice;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;

public class ParseTreeEvaluator
extends AbstractParseTreeVisitor {
    protected Token _evaluatedChildToken = null;
    private ParserScope _scope = null;
    private ParseTreeTypeInference _typeInference = null;
    private StringBuffer _trace = null;
    private int _depth = 0;

    public Token evaluateParseTree(ASTPtRootNode node) throws IllegalActionException {
        return this.evaluateParseTree(node, null);
    }

    public Token evaluateParseTree(ASTPtRootNode node, ParserScope scope) throws IllegalActionException {
        this._scope = scope;
        node.visit(this);
        this._scope = null;
        return this._evaluatedChildToken;
    }

    public String traceParseTreeEvaluation(ASTPtRootNode node, ParserScope scope) throws IllegalActionException {
        this._scope = scope;
        this._trace = new StringBuffer();
        this._depth = 0;
        this._traceEnter(node);
        try {
            node.visit(this);
            this._traceLeave(node);
        }
        catch (Exception ex) {
            this._trace(ex.toString());
        }
        this._scope = null;
        String trace = this._trace.toString();
        this._trace = null;
        return trace;
    }

    public void visitArrayConstructNode(ASTPtArrayConstructNode node) throws IllegalActionException {
        if (node.isConstant() && node.isEvaluated()) {
            this._evaluatedChildToken = node.getToken();
            return;
        }
        Token[] tokens = this._evaluateAllChildren(node);
        if (tokens.length == 0) {
            this._evaluatedChildToken = ArrayToken.NIL;
            node.setToken(this._evaluatedChildToken);
            return;
        }
        int numChildren = node.jjtGetNumChildren();
        Type elementType = tokens[0].getType();
        int i = 0;
        while (i < numChildren) {
            Type valueType = tokens[i].getType();
            if (!elementType.equals(valueType)) {
                elementType = TypeLattice.leastUpperBound(elementType, valueType);
            }
            ++i;
        }
        i = 0;
        while (i < numChildren) {
            tokens[i] = elementType.convert(tokens[i]);
            ++i;
        }
        this._evaluatedChildToken = new ArrayToken(elementType, tokens);
        if (node.isConstant()) {
            node.setToken(this._evaluatedChildToken);
        }
    }

    public void visitBitwiseNode(ASTPtBitwiseNode node) throws IllegalActionException {
        if (node.isConstant() && node.isEvaluated()) {
            this._evaluatedChildToken = node.getToken();
            return;
        }
        Token[] tokens = this._evaluateAllChildren(node);
        int numChildren = node.jjtGetNumChildren();
        this._assert(numChildren > 0, node, "The number of child nodes must be greater than zero");
        Token result = tokens[0];
        if (!(result instanceof BitwiseOperationToken)) {
            throw new IllegalActionException("Operation " + node.getOperator().image + " not defined on " + result + " which does not support bitwise operations.");
        }
        BitwiseOperationToken bitwiseResult = (BitwiseOperationToken)((Object)result);
        this._assert(node.isBitwiseAnd() ^ node.isBitwiseOr() ^ node.isBitwiseXor(), node, "Invalid operation");
        int i = 1;
        while (i < numChildren) {
            Token nextToken = tokens[i];
            if (!(nextToken instanceof BitwiseOperationToken)) {
                throw new IllegalActionException("Operation " + node.getOperator().image + " not defined on " + result + " which does not support bitwise operations.");
            }
            bitwiseResult = node.isBitwiseAnd() ? bitwiseResult.bitwiseAnd(nextToken) : (node.isBitwiseOr() ? bitwiseResult.bitwiseOr(nextToken) : bitwiseResult.bitwiseXor(nextToken));
            ++i;
        }
        this._evaluatedChildToken = (Token)((Object)bitwiseResult);
        if (node.isConstant()) {
            node.setToken(this._evaluatedChildToken);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void visitFunctionApplicationNode(ASTPtFunctionApplicationNode node) throws IllegalActionException {
        Token result;
        Token value = null;
        String functionName = node.getFunctionName();
        if (functionName != null && this._scope != null) {
            value = this._scope.get(functionName);
        }
        int argCount = node.jjtGetNumChildren() - 1;
        Type[] argTypes = new Type[argCount];
        Object[] argValues = new Token[argCount];
        int i = 0;
        while (i < argCount) {
            Token token;
            this._evaluateChild(node, i + 1);
            argValues[i] = token = this._evaluatedChildToken;
            argTypes[i] = token.getType();
            ++i;
        }
        if (value != null || functionName == null) {
            Token result2;
            if (value == null) {
                value = this._evaluateChild(node, 0);
            }
            if (value instanceof ArrayToken) {
                if (argCount != 1) throw new IllegalActionException("Wrong number of indices when referencing " + node.getFunctionName());
                result2 = this._evaluateArrayIndex(node, value, argValues[0]);
            } else if (value instanceof MatrixToken) {
                if (argCount != 2) throw new IllegalActionException("Wrong number of indices when referencing " + node.getFunctionName());
                result2 = this._evaluateMatrixIndex(node, value, argValues[0], (Token)argValues[1]);
            } else {
                if (!(value instanceof FunctionToken)) throw new IllegalActionException("Cannot index or apply arguments to " + value.toString());
                FunctionToken function = (FunctionToken)value;
                if (function.getNumberOfArguments() != argCount) {
                    throw new IllegalActionException("Wrong number of arguments when applying function " + value.toString());
                }
                result2 = function.apply((Token[])argValues);
            }
            this._evaluatedChildToken = result2;
            return;
        }
        if (node.getFunctionName().compareTo("eval") == 0) {
            Token token;
            if (argCount != 1 || !((token = argValues[0]) instanceof StringToken)) throw new IllegalActionException("The function \"eval\" is reserved for reinvoking the parser, and takes exactly one String argument.");
            PtParser parser = new PtParser();
            ASTPtRootNode tree = parser.generateParseTree(((StringToken)token).stringValue());
            tree.visit(this);
            return;
        }
        if (node.getFunctionName().compareTo("matlab") == 0) {
            this._evaluateChild(node, 1);
            Token token = this._evaluatedChildToken;
            if (!(token instanceof StringToken)) throw new IllegalActionException("The function \"matlab\" is reserved for invoking the matlab engine, and takes a string matlab expression argument followed by a list of variable names that the matlab expression refers to.");
            String expression = ((StringToken)token).stringValue();
            ParseTreeFreeVariableCollector collector = new ParseTreeFreeVariableCollector();
            Set freeVariables = collector.collectFreeVariables(node, this._scope);
            this._evaluatedChildToken = MatlabUtilities.evaluate(expression, freeVariables, this._scope);
            return;
        }
        this._evaluatedChildToken = result = this._functionCall(node.getFunctionName(), argTypes, argValues);
    }

    public void visitFunctionDefinitionNode(ASTPtFunctionDefinitionNode node) throws IllegalActionException {
        ParseTreeSpecializer specializer = new ParseTreeSpecializer();
        ASTPtRootNode cloneTree = specializer.specialize(node.getExpressionTree(), node.getArgumentNameList(), this._scope);
        if (this._typeInference == null) {
            this._typeInference = new ParseTreeTypeInference();
        }
        this._typeInference.inferTypes(node, this._scope);
        FunctionType type = (FunctionType)node.getType();
        ExpressionFunction definedFunction = new ExpressionFunction(node.getArgumentNameList(), node.getArgumentTypes(), cloneTree);
        FunctionToken result = new FunctionToken(definedFunction, type);
        this._evaluatedChildToken = result;
    }

    public void visitFunctionalIfNode(ASTPtFunctionalIfNode node) throws IllegalActionException {
        ASTPtRootNode typeChild;
        ASTPtRootNode tokenChild;
        if (node.isConstant() && node.isEvaluated()) {
            this._evaluatedChildToken = node.getToken();
            return;
        }
        int numChildren = node.jjtGetNumChildren();
        if (numChildren != 3) {
            throw new InternalErrorException("PtParser error: a functional-if node does not have three children in the parse tree.");
        }
        this._evaluateChild(node, 0);
        Token test = this._evaluatedChildToken;
        if (!(test instanceof BooleanToken)) {
            throw new IllegalActionException("Functional-if must branch on a boolean, but instead was " + test.toString() + " an instance of " + test.getClass().getName());
        }
        boolean value = ((BooleanToken)test).booleanValue();
        if (this._typeInference == null) {
            this._typeInference = new ParseTreeTypeInference();
        }
        if (value) {
            tokenChild = (ASTPtRootNode)node.jjtGetChild(1);
            typeChild = (ASTPtRootNode)node.jjtGetChild(2);
        } else {
            tokenChild = (ASTPtRootNode)node.jjtGetChild(2);
            typeChild = (ASTPtRootNode)node.jjtGetChild(1);
        }
        tokenChild.visit(this);
        Token token = this._evaluatedChildToken;
        Type type = this._typeInference.inferTypes(typeChild, this._scope);
        Type conversionType = (Type)TypeLattice.lattice().leastUpperBound(type, token.getType());
        this._evaluatedChildToken = token = conversionType.convert(token);
        if (node.isConstant()) {
            node.setToken(this._evaluatedChildToken);
        }
    }

    public void visitLeafNode(ASTPtLeafNode node) throws IllegalActionException {
        if (node.isConstant() && node.isEvaluated()) {
            this._evaluatedChildToken = node.getToken();
            return;
        }
        String name = node.getName();
        Token value = null;
        if (this._scope != null) {
            value = this._scope.get(name);
        }
        if (value == null) {
            value = Constants.get(name);
        }
        if (value != null) {
            this._evaluatedChildToken = value;
            return;
        }
        throw new UndefinedConstantOrIdentifierException(node.getName());
    }

    public void visitLogicalNode(ASTPtLogicalNode node) throws IllegalActionException {
        if (node.isConstant() && node.isEvaluated()) {
            this._evaluatedChildToken = node.getToken();
            return;
        }
        int numChildren = node.jjtGetNumChildren();
        this._assert(numChildren > 0, node, "The number of child nodes must be greater than zero");
        this._evaluateChild(node, 0);
        Token result = this._evaluatedChildToken;
        if (!(result instanceof BooleanToken)) {
            throw new IllegalActionException("Cannot perform logical operation on " + result + " which is a " + result.getClass().getName());
        }
        this._assert(node.isLogicalAnd() ^ node.isLogicalOr(), node, "Invalid operation");
        boolean flag = node.isLogicalAnd();
        int i = 0;
        while (i < numChildren) {
            ASTPtRootNode child = (ASTPtRootNode)node.jjtGetChild(i);
            child.visit(this);
            Token nextToken = this._evaluatedChildToken;
            if (!(nextToken instanceof BooleanToken)) {
                throw new IllegalActionException("Cannot perform logical operation on " + nextToken + " which is a " + result.getClass().getName());
            }
            if (flag != ((BooleanToken)nextToken).booleanValue()) {
                this._evaluatedChildToken = BooleanToken.getInstance(!flag);
                return;
            }
            ++i;
        }
        this._evaluatedChildToken = BooleanToken.getInstance(flag);
        if (node.isConstant()) {
            node.setToken(this._evaluatedChildToken);
        }
    }

    public void visitMatrixConstructNode(ASTPtMatrixConstructNode node) throws IllegalActionException {
        if (node.isConstant() && node.isEvaluated()) {
            this._evaluatedChildToken = node.getToken();
            return;
        }
        Token[] tokens = this._evaluateAllChildren(node);
        MatrixToken result = null;
        if (node.getForm() == 1) {
            result = MatrixToken.arrayToMatrix(tokens, node.getRowCount(), node.getColumnCount());
        } else if (node.getForm() == 2) {
            try {
                int columnCount = MatrixToken.determineSequenceLength((ScalarToken)tokens[0], (ScalarToken)tokens[1], (ScalarToken)tokens[2]);
                int i = 1;
                while (i < node.getRowCount()) {
                    if (columnCount != MatrixToken.determineSequenceLength((ScalarToken)tokens[3 * i], (ScalarToken)tokens[3 * i + 1], (ScalarToken)tokens[3 * i + 2])) {
                        throw new IllegalActionException("Matrix should have the same number of columns for all rows.");
                    }
                    ++i;
                }
                Token[] matrixTokens = new Token[node.getRowCount() * columnCount];
                int i2 = 0;
                while (i2 < node.getRowCount()) {
                    Token[] newTokens = MatrixToken.createSequence(tokens[3 * i2], tokens[3 * i2 + 1], columnCount);
                    System.arraycopy(newTokens, 0, matrixTokens, columnCount * i2, columnCount);
                    ++i2;
                }
                result = MatrixToken.arrayToMatrix(matrixTokens, node.getRowCount(), columnCount);
            }
            catch (IllegalActionException ex) {
                throw new IllegalActionException(null, null, ex, "Matrix Token construction failed.");
            }
        }
        this._evaluatedChildToken = result;
        if (node.isConstant()) {
            node.setToken(this._evaluatedChildToken);
        }
    }

    public void visitMethodCallNode(ASTPtMethodCallNode node) throws IllegalActionException {
        Token result;
        RecordToken record;
        int argCount = node.jjtGetNumChildren();
        Token[] tokens = this._evaluateAllChildren(node);
        if (argCount == 1 && tokens[0] instanceof RecordToken && (record = (RecordToken)tokens[0]).labelSet().contains(node.getMethodName())) {
            this._evaluatedChildToken = record.get(node.getMethodName());
            return;
        }
        Type[] argTypes = new Type[argCount];
        Object[] argValues = new Object[argCount];
        int i = 0;
        while (i < argCount) {
            Token token = tokens[i];
            argValues[i] = token;
            argTypes[i] = token.getType();
            ++i;
        }
        this._evaluatedChildToken = result = this._methodCall(node.getMethodName(), argTypes, argValues);
    }

    public void visitPowerNode(ASTPtPowerNode node) throws IllegalActionException {
        if (node.isConstant() && node.isEvaluated()) {
            this._evaluatedChildToken = node.getToken();
            return;
        }
        Token[] tokens = this._evaluateAllChildren(node);
        int numChildren = node.jjtGetNumChildren();
        this._assert(numChildren > 0, node, "The number of child nodes must be greater than zero");
        Token result = tokens[0];
        int i = 1;
        while (i < numChildren) {
            int times = 1;
            Token token = tokens[i];
            if (!(token instanceof ScalarToken)) {
                throw new IllegalActionException("Exponent must be ScalarToken and have a valid lossless conversion to integer. Integer or unsigned byte meet these criteria.\nUse pow(10, 3.5) for non-integer exponents");
            }
            try {
                times = ((ScalarToken)token).intValue();
            }
            catch (IllegalActionException illegalActionException) {
                throw new IllegalActionException("Exponent must have a valid lossless conversion to integer. Integer or unsigned byte meet this criterion.\nUse pow(10, 3.5) for non-integer exponents");
            }
            result = result.pow(times);
            ++i;
        }
        this._evaluatedChildToken = result;
        if (node.isConstant()) {
            node.setToken(this._evaluatedChildToken);
        }
    }

    public void visitProductNode(ASTPtProductNode node) throws IllegalActionException {
        if (node.isConstant() && node.isEvaluated()) {
            this._evaluatedChildToken = node.getToken();
            return;
        }
        Token[] tokens = this._evaluateAllChildren(node);
        List lexicalTokenList = node.getLexicalTokenList();
        int numChildren = node.jjtGetNumChildren();
        this._assert(numChildren > 0, node, "The number of child nodes must be greater than zero");
        this._assert(numChildren == lexicalTokenList.size() + 1, node, "The number of child nodes is not equal to number of operators plus one");
        Token result = tokens[0];
        int i = 1;
        while (i < numChildren) {
            ptolemy.data.expr.Token operator = (ptolemy.data.expr.Token)lexicalTokenList.get(i - 1);
            Token nextToken = tokens[i];
            if (operator.kind == 12) {
                result = result.multiply(nextToken);
            } else if (operator.kind == 13) {
                result = result.divide(nextToken);
            } else if (operator.kind == 14) {
                result = result.modulo(nextToken);
            } else {
                this._assert(false, node, "Invalid operation");
            }
            ++i;
        }
        this._evaluatedChildToken = result;
        if (node.isConstant()) {
            node.setToken(this._evaluatedChildToken);
        }
    }

    public void visitRecordConstructNode(ASTPtRecordConstructNode node) throws IllegalActionException {
        if (node.isConstant() && node.isEvaluated()) {
            this._evaluatedChildToken = node.getToken();
            return;
        }
        Token[] tokens = this._evaluateAllChildren(node);
        int numChildren = node.jjtGetNumChildren();
        this._assert(node.getFieldNames().size() == numChildren, node, "The number of labels and values does not match in parsing a record expression.");
        String[] labels = node.getFieldNames().toArray(new String[numChildren]);
        this._evaluatedChildToken = new RecordToken(labels, tokens);
        if (node.isConstant()) {
            node.setToken(this._evaluatedChildToken);
        }
    }

    public void visitRelationalNode(ASTPtRelationalNode node) throws IllegalActionException {
        BooleanToken result;
        if (node.isConstant() && node.isEvaluated()) {
            this._evaluatedChildToken = node.getToken();
            return;
        }
        Token[] tokens = this._evaluateAllChildren(node);
        int numChildren = node.jjtGetNumChildren();
        this._assert(numChildren == 2, node, "The number of child nodes must be two");
        ptolemy.data.expr.Token operator = node.getOperator();
        Token leftToken = tokens[0];
        Token rightToken = tokens[1];
        if (operator.kind == 33) {
            result = leftToken.isEqualTo(rightToken);
        } else if (operator.kind == 32) {
            result = leftToken.isEqualTo(rightToken).not();
        } else {
            if (!(leftToken instanceof ScalarToken) || !(rightToken instanceof ScalarToken)) {
                throw new IllegalActionException("The " + operator.image + " operator can only be applied between scalars.");
            }
            ScalarToken leftScalar = (ScalarToken)leftToken;
            ScalarToken rightScalar = (ScalarToken)rightToken;
            if (operator.kind == 30) {
                result = leftScalar.isLessThan(rightScalar).not();
            } else if (operator.kind == 28) {
                result = rightScalar.isLessThan(leftScalar);
            } else if (operator.kind == 31) {
                result = rightScalar.isLessThan(leftScalar).not();
            } else if (operator.kind == 29) {
                result = leftScalar.isLessThan(rightScalar);
            } else {
                throw new IllegalActionException("Invalid operation " + operator.image + " between " + leftToken.getClass().getName() + " and " + rightToken.getClass().getName());
            }
        }
        this._evaluatedChildToken = result;
        if (node.isConstant()) {
            node.setToken(this._evaluatedChildToken);
        }
    }

    public void visitShiftNode(ASTPtShiftNode node) throws IllegalActionException {
        if (node.isConstant() && node.isEvaluated()) {
            this._evaluatedChildToken = node.getToken();
            return;
        }
        Token[] tokens = this._evaluateAllChildren(node);
        int numChildren = node.jjtGetNumChildren();
        this._assert(numChildren == 2, node, "The number of child nodes must be two");
        ptolemy.data.expr.Token operator = node.getOperator();
        Token token = tokens[0];
        Token bitsToken = tokens[1];
        ScalarToken result = null;
        if (!(token instanceof ScalarToken)) {
            throw new IllegalActionException("The " + operator + " operator requires " + "the left operand to be a scalar.");
        }
        if (!(bitsToken instanceof ScalarToken)) {
            throw new IllegalActionException("The " + operator + " operator requires " + "the right operand to be a scalar.");
        }
        try {
            if (operator.kind == 41) {
                result = ((ScalarToken)token).leftShift(((ScalarToken)bitsToken).intValue());
            } else if (operator.kind == 42) {
                result = ((ScalarToken)token).rightShift(((ScalarToken)bitsToken).intValue());
            } else if (operator.kind == 43) {
                result = ((ScalarToken)token).logicalRightShift(((ScalarToken)bitsToken).intValue());
            } else {
                this._assert(false, node, "Invalid operation");
            }
        }
        catch (IllegalActionException illegalActionException) {
            throw new IllegalActionException("The " + operator + " operator requires " + "the right operand to have an integer value.");
        }
        this._evaluatedChildToken = result;
        if (node.isConstant()) {
            node.setToken(this._evaluatedChildToken);
        }
    }

    public void visitSumNode(ASTPtSumNode node) throws IllegalActionException {
        if (node.isConstant() && node.isEvaluated()) {
            this._evaluatedChildToken = node.getToken();
            return;
        }
        Token[] tokens = this._evaluateAllChildren(node);
        List lexicalTokenList = node.getLexicalTokenList();
        int numChildren = node.jjtGetNumChildren();
        this._assert(numChildren > 0, node, "The number of child nodes must be greater than zero");
        this._assert(numChildren == lexicalTokenList.size() + 1, node, "The number of child nodes is not equal to number of operators plus one");
        Token result = tokens[0];
        int i = 1;
        while (i < numChildren) {
            ptolemy.data.expr.Token operator = (ptolemy.data.expr.Token)lexicalTokenList.get(i - 1);
            Token nextToken = tokens[i];
            if (operator.kind == 10) {
                result = result.add(nextToken);
            } else if (operator.kind == 11) {
                result = result.subtract(nextToken);
            } else {
                this._assert(false, node, "Invalid operation");
            }
            ++i;
        }
        this._evaluatedChildToken = result;
        if (node.isConstant()) {
            node.setToken(this._evaluatedChildToken);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void visitUnaryNode(ASTPtUnaryNode node) throws IllegalActionException {
        if (node.isConstant() && node.isEvaluated()) {
            this._evaluatedChildToken = node.getToken();
            return;
        }
        Token[] tokens = this._evaluateAllChildren(node);
        this._assert(node.jjtGetNumChildren() == 1, node, "Unary node must have exactly one child!");
        Token result = tokens[0];
        if (node.isMinus()) {
            result = result.zero().subtract(result);
        } else if (node.isNot()) {
            if (!(result instanceof BooleanToken)) throw new IllegalActionException("Not operator not support for non-boolean token: " + result.toString());
            result = ((BooleanToken)result).not();
        } else if (node.isBitwiseNot()) {
            if (!(result instanceof BitwiseOperationToken)) {
                throw new IllegalActionException("Bitwise negation not defined on " + result + " which does not support bitwise operations.");
            }
            result = (Token)((Object)((BitwiseOperationToken)((Object)result)).bitwiseNot());
        } else {
            this._assert(false, node, "Unrecognized unary node");
        }
        this._evaluatedChildToken = result;
        if (!node.isConstant()) return;
        node.setToken(this._evaluatedChildToken);
    }

    public void visitUnionConstructNode(ASTPtUnionConstructNode node) throws IllegalActionException {
        if (node.isConstant() && node.isEvaluated()) {
            this._evaluatedChildToken = node.getToken();
            return;
        }
        Token[] tokens = this._evaluateAllChildren(node);
        int numChildren = node.jjtGetNumChildren();
        this._assert(node.getLabelNames().size() == numChildren, node, "The number of labels and values does not match in parsing a record expression.");
        String[] labels = node.getLabelNames().toArray(new String[numChildren]);
        if (labels.length > 0) {
            this._evaluatedChildToken = new UnionToken(labels[0], tokens[0]);
        }
        this._evaluatedChildToken = new UnionToken(labels[0], tokens[0]);
        if (node.isConstant()) {
            node.setToken(this._evaluatedChildToken);
        }
    }

    protected void _assert(boolean flag, ASTPtRootNode node, String message) {
        if (!flag) {
            throw new InternalErrorException(String.valueOf(message) + ": " + node.toString());
        }
    }

    protected Token[] _evaluateAllChildren(ASTPtRootNode node) throws IllegalActionException {
        int numChildren = node.jjtGetNumChildren();
        Token[] tokens = new Token[numChildren];
        int i = 0;
        while (i < numChildren) {
            node.jjtGetChild(i);
            tokens[i] = this._evaluateChild(node, i);
            ++i;
        }
        return tokens;
    }

    protected Token _evaluateArrayIndex(ASTPtRootNode node, Token value, Token index) throws IllegalActionException {
        if (!(value instanceof ArrayToken)) {
            throw new IllegalActionException("Array indexing cannot be applied to '" + value.toString() + "' because its value is not an array.");
        }
        if (!(index instanceof IntToken)) {
            throw new IllegalActionException("Array indexing requires an integer. Got: " + index);
        }
        int integerIndex = ((IntToken)index).intValue();
        try {
            return ((ArrayToken)value).getElement(integerIndex);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalActionException("The index '" + index + "' is out of bounds on the array '" + value + "'.");
        }
    }

    protected Token _evaluateChild(ASTPtRootNode node, int i) throws IllegalActionException {
        ASTPtRootNode child = (ASTPtRootNode)node.jjtGetChild(i);
        this._traceEnter(child);
        child.visit(this);
        this._traceLeave(child);
        return this._evaluatedChildToken;
    }

    protected Token _evaluateMatrixIndex(ASTPtRootNode node, Token value, Token rowIndex, Token columnIndex) throws IllegalActionException {
        if (!(value instanceof MatrixToken)) {
            throw new IllegalActionException("Matrix indexing cannot be applied to '" + value.toString() + "' because its value is not a matrix.");
        }
        if (!(rowIndex instanceof IntToken)) {
            throw new IllegalActionException("Matrix row index must be an integer. Got: " + rowIndex);
        }
        if (!(columnIndex instanceof IntToken)) {
            throw new IllegalActionException("Matrix column index must be an integer. Got: " + columnIndex);
        }
        int integerRowIndex = ((IntToken)rowIndex).intValue();
        int integerColumnIndex = ((IntToken)columnIndex).intValue();
        try {
            return ((MatrixToken)value).getElementAsToken(integerRowIndex, integerColumnIndex);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalActionException("The index (" + rowIndex + "," + columnIndex + ") is out of bounds on the matrix '" + value + "'.");
        }
    }

    protected Token _functionCall(String functionName, Type[] argTypes, Object[] argValues) throws IllegalActionException {
        CachedMethod method = CachedMethod.findMethod(functionName, argTypes, 8);
        if (method.isValid()) {
            if (this._trace != null) {
                this._trace("Invoking " + method.methodDescription());
                this._trace("as " + method);
            }
            Token result = method.invoke(argValues);
            return result;
        }
        throw new IllegalActionException("No function found matching " + method.toString());
    }

    protected Token _methodCall(String methodName, Type[] argTypes, Object[] argValues) throws IllegalActionException {
        CachedMethod method = CachedMethod.findMethod(methodName, argTypes, 16);
        if (method.isValid()) {
            if (this._trace != null) {
                this._trace("Invoking " + method.methodDescription());
                this._trace("as " + method);
            }
            Token result = method.invoke(argValues);
            return result;
        }
        throw new IllegalActionException("No method found matching " + method.toString());
    }

    protected void _trace(String string) {
        if (this._trace != null) {
            int i = 0;
            while (i < this._depth) {
                this._trace.append("  ");
                ++i;
            }
            this._trace.append(string);
            this._trace.append("\n");
        }
    }

    protected void _traceEnter(ASTPtRootNode node) {
        if (this._trace != null) {
            int i = 0;
            while (i < this._depth) {
                this._trace.append("  ");
                ++i;
            }
            this._trace.append("Entering node " + node.getClass().getName() + "\n");
            ++this._depth;
        }
    }

    protected void _traceLeave(ASTPtRootNode node) {
        if (this._trace != null) {
            --this._depth;
            int i = 0;
            while (i < this._depth) {
                this._trace.append("  ");
                ++i;
            }
            this._trace.append("Node " + node.getClass().getName() + " evaluated to " + this._evaluatedChildToken + "\n");
        }
    }
}

