/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data.expr;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import ptolemy.data.expr.StringParameter;
import ptolemy.kernel.attributes.FileOrURLAccessor;
import ptolemy.kernel.attributes.URIAttribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;
import ptolemy.util.FileUtilities;

public class FileParameter
extends StringParameter
implements FileOrURLAccessor {
    private URI _baseDirectory;
    private BufferedReader _reader;
    private Writer _writer;

    public FileParameter(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    public File asFile() throws IllegalActionException {
        String name = this.stringValue();
        try {
            return FileUtilities.nameToFile(name, this.getBaseDirectory());
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalActionException((Nameable)this, ex, "Failed to create a file with name '" + name + "'.");
        }
    }

    public URL asURL() throws IllegalActionException {
        String name = this.stringValue();
        try {
            return FileUtilities.nameToURL(name, this.getBaseDirectory(), this.getClass().getClassLoader());
        }
        catch (IOException ex) {
            throw new IllegalActionException((Nameable)this, ex, "Cannot read file '" + name + "'");
        }
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        FileParameter newObject = (FileParameter)super.clone(workspace);
        newObject._baseDirectory = null;
        newObject._reader = null;
        newObject._writer = null;
        return newObject;
    }

    public void close() throws IllegalActionException {
        if (this._reader != null && this._reader != FileUtilities.STD_IN) {
            try {
                this._reader.close();
            }
            catch (IOException iOException) {}
        }
        if (this._writer != null) {
            try {
                this._writer.flush();
                if (this._writer != FileUtilities.STD_OUT) {
                    this._writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public URI getBaseDirectory() {
        if (this._baseDirectory != null) {
            return this._baseDirectory;
        }
        return URIAttribute.getModelURI(this);
    }

    public BufferedReader openForReading() throws IllegalActionException {
        try {
            this._reader = FileUtilities.openForReading(this.stringValue(), this.getBaseDirectory(), this.getClass().getClassLoader());
            return this._reader;
        }
        catch (IOException ex) {
            throw new IllegalActionException((Nameable)this, ex, "Cannot open file or URL");
        }
    }

    public Writer openForWriting() throws IllegalActionException {
        return this.openForWriting(false);
    }

    public Writer openForWriting(boolean append) throws IllegalActionException {
        try {
            this._writer = FileUtilities.openForWriting(this.stringValue(), this.getBaseDirectory(), append);
            return this._writer;
        }
        catch (IOException ex) {
            throw new IllegalActionException((Nameable)this, ex, "Cannot open file for writing");
        }
    }

    public void setBaseDirectory(URI directory) {
        this._baseDirectory = directory;
    }
}

