/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data.expr;

import java.lang.reflect.Array;
import ptolemy.data.ArrayToken;
import ptolemy.data.BooleanMatrixToken;
import ptolemy.data.BooleanToken;
import ptolemy.data.ComplexMatrixToken;
import ptolemy.data.ComplexToken;
import ptolemy.data.DoubleMatrixToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.FixMatrixToken;
import ptolemy.data.FixToken;
import ptolemy.data.FloatToken;
import ptolemy.data.IntMatrixToken;
import ptolemy.data.IntToken;
import ptolemy.data.LongMatrixToken;
import ptolemy.data.LongToken;
import ptolemy.data.ObjectToken;
import ptolemy.data.RecordToken;
import ptolemy.data.ShortToken;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.UnsignedByteToken;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.FixType;
import ptolemy.data.type.RecordType;
import ptolemy.data.type.Type;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.math.Complex;
import ptolemy.math.FixPoint;

public class ConversionUtilities {
    public static Token convertJavaTypeToToken(Object object) throws IllegalActionException {
        Token returnValue = null;
        if (object instanceof Token) {
            returnValue = (Token)object;
        } else if (object instanceof Token[]) {
            returnValue = new ArrayToken((Token[])object);
        } else if (object instanceof Boolean) {
            returnValue = new BooleanToken((Boolean)object);
        } else if (object instanceof Byte) {
            returnValue = new UnsignedByteToken((Byte)object);
        } else if (object instanceof Short) {
            returnValue = new ShortToken((Short)object);
        } else if (object instanceof Integer) {
            returnValue = new IntToken((Integer)object);
        } else if (object instanceof Long) {
            returnValue = new LongToken((Long)object);
        } else if (object instanceof Double) {
            returnValue = new DoubleToken((Double)object);
        } else if (object instanceof Float) {
            returnValue = new FloatToken(((Float)object).floatValue());
        } else if (object instanceof Complex) {
            returnValue = new ComplexToken((Complex)object);
        } else if (object instanceof FixPoint) {
            returnValue = new FixToken((FixPoint)object);
        } else if (object instanceof String) {
            returnValue = new StringToken((String)object);
        } else if (object instanceof boolean[][]) {
            returnValue = new BooleanMatrixToken((boolean[][])object);
        } else if (object instanceof int[][]) {
            returnValue = new IntMatrixToken((int[][])object);
        } else if (object instanceof long[][]) {
            returnValue = new LongMatrixToken((long[][])object);
        } else if (object instanceof double[][]) {
            returnValue = new DoubleMatrixToken((double[][])object);
        } else if (object instanceof Complex[][]) {
            returnValue = new ComplexMatrixToken((Complex[][])object);
        } else if (object instanceof FixPoint[][]) {
            returnValue = new FixMatrixToken((FixPoint[][])object);
        } else if (object instanceof double[]) {
            Token[] temp = new DoubleToken[((double[])object).length];
            int j = 0;
            while (j < temp.length) {
                temp[j] = new DoubleToken(((double[])object)[j]);
                ++j;
            }
            returnValue = new ArrayToken(temp);
        } else if (object instanceof Complex[]) {
            Token[] temp = new ComplexToken[((Complex[])object).length];
            int j = 0;
            while (j < temp.length) {
                temp[j] = new ComplexToken(((Complex[])object)[j]);
                ++j;
            }
            returnValue = new ArrayToken(temp);
        } else if (object instanceof int[]) {
            Token[] temp = new IntToken[((int[])object).length];
            int j = 0;
            while (j < temp.length) {
                temp[j] = new IntToken(((int[])object)[j]);
                ++j;
            }
            returnValue = new ArrayToken(temp);
        } else if (object instanceof long[]) {
            Token[] temp = new LongToken[((long[])object).length];
            int j = 0;
            while (j < temp.length) {
                temp[j] = new LongToken(((long[])object)[j]);
                ++j;
            }
            returnValue = new ArrayToken(temp);
        } else if (object instanceof boolean[]) {
            Token[] temp = new BooleanToken[((boolean[])object).length];
            int j = 0;
            while (j < temp.length) {
                temp[j] = new BooleanToken(((boolean[])object)[j]);
                ++j;
            }
            returnValue = new ArrayToken(temp);
        } else if (object instanceof String[]) {
            Token[] temp = new StringToken[((String[])object).length];
            int j = 0;
            while (j < temp.length) {
                temp[j] = new StringToken(((String[])object)[j]);
                ++j;
            }
            returnValue = new ArrayToken(temp);
        } else if (object instanceof FixPoint[]) {
            Token[] temp = new FixToken[((FixPoint[])object).length];
            int j = 0;
            while (j < temp.length) {
                temp[j] = new FixToken(((FixPoint[])object)[j]);
                ++j;
            }
            returnValue = new ArrayToken(temp);
        } else {
            returnValue = new ObjectToken(object);
        }
        return returnValue;
    }

    public static Type convertJavaTypeToTokenType(Class tokenClass) throws IllegalActionException {
        try {
            if (tokenClass.equals(Token.class)) {
                return BaseType.GENERAL;
            }
            if (ArrayToken.class.isAssignableFrom(tokenClass)) {
                ArrayType type = new ArrayType(BaseType.GENERAL);
                return type;
            }
            if (RecordToken.class.isAssignableFrom(tokenClass)) {
                RecordType type = new RecordType(new String[0], new Type[0]);
                return type;
            }
            if (Token.class.isAssignableFrom(tokenClass)) {
                Type type = BaseType.forClassName(tokenClass.getName());
                if (type == null) {
                    throw new IllegalActionException("Could not return type for class " + tokenClass);
                }
                return type;
            }
            if (tokenClass.equals(Boolean.class) || tokenClass.equals(Boolean.TYPE)) {
                return BaseType.BOOLEAN;
            }
            if (tokenClass.equals(Byte.class) || tokenClass.equals(Byte.TYPE)) {
                return BaseType.UNSIGNED_BYTE;
            }
            if (tokenClass.equals(Short.class) || tokenClass.equals(Short.TYPE)) {
                return BaseType.SHORT;
            }
            if (tokenClass.equals(Integer.class) || tokenClass.equals(Integer.TYPE)) {
                return BaseType.INT;
            }
            if (tokenClass.equals(Long.class) || tokenClass.equals(Long.TYPE)) {
                return BaseType.LONG;
            }
            if (tokenClass.equals(Double.class) || tokenClass.equals(Double.TYPE)) {
                return BaseType.DOUBLE;
            }
            if (tokenClass.equals(Float.class) || tokenClass.equals(Float.TYPE)) {
                return BaseType.FLOAT;
            }
            if (tokenClass.equals(Complex.class)) {
                return BaseType.COMPLEX;
            }
            if (tokenClass.equals(FixPoint.class)) {
                return BaseType.UNSIZED_FIX;
            }
            if (tokenClass.equals(String.class)) {
                return BaseType.STRING;
            }
            if (tokenClass.equals(Class.forName("[[Z"))) {
                return BaseType.BOOLEAN_MATRIX;
            }
            if (tokenClass.equals(Class.forName("[[I"))) {
                return BaseType.INT_MATRIX;
            }
            if (tokenClass.equals(Class.forName("[[J"))) {
                return BaseType.LONG_MATRIX;
            }
            if (tokenClass.equals(Class.forName("[[D"))) {
                return BaseType.DOUBLE_MATRIX;
            }
            if (tokenClass.equals(Class.forName("[[Lptolemy.math.Complex;"))) {
                return BaseType.COMPLEX_MATRIX;
            }
            if (tokenClass.equals(Class.forName("[[Lptolemy.math.FixPoint;"))) {
                return BaseType.FIX_MATRIX;
            }
            if (tokenClass.isArray()) {
                return new ArrayType(ConversionUtilities.convertJavaTypeToTokenType(tokenClass.getComponentType()));
            }
            if (Object.class.isAssignableFrom(tokenClass)) {
                return BaseType.OBJECT;
            }
            throw new InternalErrorException("type not found: " + tokenClass);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalActionException(null, ex, "Could not find Class '" + tokenClass + "'");
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object convertTokenToJavaType(Token token) throws IllegalActionException {
        void var1_24;
        if (token instanceof DoubleToken) {
            Double d = ((DoubleToken)token).doubleValue();
            return var1_24;
        } else if (token instanceof IntToken) {
            Integer n = ((IntToken)token).intValue();
            return var1_24;
        } else if (token instanceof UnsignedByteToken) {
            Byte by = ((UnsignedByteToken)token).byteValue();
            return var1_24;
        } else if (token instanceof LongToken) {
            Long l = ((LongToken)token).longValue();
            return var1_24;
        } else if (token instanceof StringToken) {
            String string = ((StringToken)token).stringValue();
            return var1_24;
        } else if (token instanceof BooleanToken) {
            Boolean bl = ((BooleanToken)token).booleanValue();
            return var1_24;
        } else if (token instanceof ComplexToken) {
            Complex complex = ((ComplexToken)token).complexValue();
            return var1_24;
        } else if (token instanceof FixToken) {
            FixPoint fixPoint = ((FixToken)token).fixValue();
            return var1_24;
        } else if (token instanceof FloatToken) {
            Float f = Float.valueOf(((FloatToken)token).floatValue());
            return var1_24;
        } else if (token instanceof ShortToken) {
            Short s = ((ShortToken)token).shortValue();
            return var1_24;
        } else if (token instanceof FixMatrixToken) {
            FixPoint[][] fixPointArray = ((FixMatrixToken)token).fixMatrix();
            return var1_24;
        } else if (token instanceof IntMatrixToken) {
            int[][] nArray = ((IntMatrixToken)token).intMatrix();
            return var1_24;
        } else if (token instanceof DoubleMatrixToken) {
            double[][] dArray = ((DoubleMatrixToken)token).doubleMatrix();
            return var1_24;
        } else if (token instanceof ComplexMatrixToken) {
            Complex[][] complexArray = ((ComplexMatrixToken)token).complexMatrix();
            return var1_24;
        } else if (token instanceof LongMatrixToken) {
            long[][] lArray = ((LongMatrixToken)token).longMatrix();
            return var1_24;
        } else if (token instanceof BooleanMatrixToken) {
            boolean[][] blArray = ((BooleanMatrixToken)token).booleanMatrix();
            return var1_24;
        } else {
            if (!(token instanceof ArrayToken)) throw new InternalErrorException("token type not recognized: " + token);
            if (((ArrayToken)token).getElement(0) instanceof FixToken) {
                FixPoint[] array = new FixPoint[((ArrayToken)token).length()];
                int j = 0;
                while (j < array.length) {
                    array[j] = ((FixToken)((ArrayToken)token).getElement(j)).fixValue();
                    ++j;
                }
                FixPoint[] fixPointArray = array;
                return var1_24;
            } else if (((ArrayToken)token).getElement(0) instanceof IntToken) {
                int[] array = new int[((ArrayToken)token).length()];
                int j = 0;
                while (j < array.length) {
                    array[j] = ((IntToken)((ArrayToken)token).getElement(j)).intValue();
                    ++j;
                }
                int[] nArray = array;
                return var1_24;
            } else if (((ArrayToken)token).getElement(0) instanceof LongToken) {
                long[] array = new long[((ArrayToken)token).length()];
                int j = 0;
                while (j < array.length) {
                    array[j] = ((LongToken)((ArrayToken)token).getElement(j)).longValue();
                    ++j;
                }
                long[] lArray = array;
                return var1_24;
            } else if (((ArrayToken)token).getElement(0) instanceof DoubleToken) {
                double[] array = new double[((ArrayToken)token).length()];
                int j = 0;
                while (j < array.length) {
                    array[j] = ((DoubleToken)((ArrayToken)token).getElement(j)).doubleValue();
                    ++j;
                }
                double[] dArray = array;
                return var1_24;
            } else if (((ArrayToken)token).getElement(0) instanceof ComplexToken) {
                Complex[] array = new Complex[((ArrayToken)token).length()];
                int j = 0;
                while (j < array.length) {
                    array[j] = ((ComplexToken)((ArrayToken)token).getElement(j)).complexValue();
                    ++j;
                }
                Complex[] complexArray = array;
                return var1_24;
            } else if (((ArrayToken)token).getElement(0) instanceof StringToken) {
                String[] array = new String[((ArrayToken)token).length()];
                int j = 0;
                while (j < array.length) {
                    array[j] = ((StringToken)((ArrayToken)token).getElement(j)).stringValue();
                    ++j;
                }
                String[] stringArray = array;
                return var1_24;
            } else {
                if (!(((ArrayToken)token).getElement(0) instanceof BooleanToken)) throw new InternalErrorException("token type not recognized: " + token);
                boolean[] array = new boolean[((ArrayToken)token).length()];
                int j = 0;
                while (j < array.length) {
                    array[j] = ((BooleanToken)((ArrayToken)token).getElement(j)).booleanValue();
                    ++j;
                }
                boolean[] blArray = array;
            }
        }
        return var1_24;
    }

    public static Class convertTokenTypeToJavaType(Type type) throws IllegalActionException {
        try {
            if (type.equals(BaseType.DOUBLE)) {
                return Double.TYPE;
            }
            if (type.equals(BaseType.UNSIGNED_BYTE)) {
                return Byte.TYPE;
            }
            if (type.equals(BaseType.INT)) {
                return Integer.TYPE;
            }
            if (type.equals(BaseType.FLOAT)) {
                return Short.TYPE;
            }
            if (type.equals(BaseType.LONG)) {
                return Long.TYPE;
            }
            if (type.equals(BaseType.SHORT)) {
                return Short.TYPE;
            }
            if (type.equals(BaseType.STRING)) {
                return String.class;
            }
            if (type.equals(BaseType.BOOLEAN)) {
                return Boolean.TYPE;
            }
            if (type.equals(BaseType.COMPLEX)) {
                return Complex.class;
            }
            if (type.equals(BaseType.UNSIZED_FIX)) {
                return FixPoint.class;
            }
            if (type instanceof FixType) {
                return FixPoint.class;
            }
            if (type.equals(BaseType.BOOLEAN)) {
                return Class.forName("[[Lptolemy.math.FixPoint;");
            }
            if (type.equals(BaseType.INT_MATRIX)) {
                return Class.forName("[[I");
            }
            if (type.equals(BaseType.DOUBLE_MATRIX)) {
                return Class.forName("[[D");
            }
            if (type.equals(BaseType.COMPLEX_MATRIX)) {
                return Class.forName("[[Lptolemy.math.Complex;");
            }
            if (type.equals(BaseType.LONG_MATRIX)) {
                return Class.forName("[[J");
            }
            if (type.equals(BaseType.BOOLEAN_MATRIX)) {
                return Class.forName("[[Z");
            }
            if (type instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)type;
                Type elementType = arrayType.getElementType();
                if (elementType.equals(BaseType.DOUBLE)) {
                    return Class.forName("[D");
                }
                if (elementType.equals(BaseType.INT)) {
                    return Class.forName("[I");
                }
                if (elementType.equals(BaseType.LONG)) {
                    return Class.forName("[J");
                }
                if (elementType.equals(BaseType.BOOLEAN)) {
                    return Class.forName("[Z");
                }
                return Array.newInstance(ConversionUtilities.convertTokenTypeToJavaType(arrayType.getElementType()), 0).getClass();
            }
            return type.getTokenClass();
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalActionException(null, ex, "Could not find Type '" + type + "'");
        }
    }
}

