/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data.expr;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeMap;
import ptolemy.data.BooleanToken;
import ptolemy.data.ComplexToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.FloatToken;
import ptolemy.data.IntToken;
import ptolemy.data.LongToken;
import ptolemy.data.ObjectToken;
import ptolemy.data.RecordToken;
import ptolemy.data.ShortToken;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.UnsignedByteToken;
import ptolemy.data.UnsizedFixToken;
import ptolemy.data.XMLToken;
import ptolemy.data.expr.ConcreteMatrixToken;
import ptolemy.data.expr.ConcreteScalarToken;
import ptolemy.data.expr.GeneralToken;
import ptolemy.data.expr.UnknownToken;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.math.Complex;
import ptolemy.util.StringUtilities;

public class Constants {
    private static Hashtable _table = new Hashtable();
    private static TreeMap _types = new TreeMap();

    static {
        DoubleToken token = new DoubleToken(Math.PI);
        _table.put("PI", token);
        _table.put("pi", token);
        token = new DoubleToken(Math.E);
        _table.put("E", token);
        _table.put("e", token);
        ComplexToken i = new ComplexToken(new Complex(0.0, 1.0));
        _table.put("i", i);
        _table.put("j", i);
        _table.put("true", BooleanToken.TRUE);
        _table.put("false", BooleanToken.FALSE);
        _table.put("CLASSPATH", new StringToken("xxxxxxCLASSPATHxxxxxx"));
        try {
            Constants._putProperty("CWD", "user.dir");
            Constants._putProperty("HOME", "user.home");
            Constants._putProperty("PTII", "ptolemy.ptII.dir");
            Constants._putProperty("TMPDIR", "java.io.tmpdir");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        _table.put("NaN", new DoubleToken(Double.NaN));
        _table.put("Infinity", new DoubleToken(Double.POSITIVE_INFINITY));
        _table.put("MaxUnsignedByte", new UnsignedByteToken(255));
        _table.put("MinUnsignedByte", new UnsignedByteToken(0));
        _table.put("MaxShort", new ShortToken(Short.MAX_VALUE));
        _table.put("MinShort", new ShortToken(Short.MIN_VALUE));
        _table.put("MaxInt", new IntToken(Integer.MAX_VALUE));
        _table.put("MinInt", new IntToken(Integer.MIN_VALUE));
        _table.put("MaxLong", new LongToken(Long.MAX_VALUE));
        _table.put("MinLong", new LongToken(Long.MIN_VALUE));
        _table.put("MaxFloat", new DoubleToken(3.4028234663852886E38));
        _table.put("MinFloat", new DoubleToken(1.4E-45f));
        _table.put("MaxDouble", new DoubleToken(Double.MAX_VALUE));
        _table.put("MinDouble", new DoubleToken(Double.MIN_VALUE));
        _table.put("PositiveInfinity", new DoubleToken(Double.POSITIVE_INFINITY));
        _table.put("NegativeInfinity", new DoubleToken(Double.NEGATIVE_INFINITY));
        _types.put("boolean", BooleanToken.FALSE);
        _types.put("complex", new ComplexToken(new Complex(0.0, 0.0)));
        _types.put("float", new FloatToken(0.0f));
        _types.put("double", new DoubleToken(0.0));
        _types.put("fixedpoint", new UnsizedFixToken());
        _types.put("general", new GeneralToken());
        _types.put("short", new ShortToken(0));
        _types.put("int", new IntToken(0));
        _types.put("long", new LongToken(0L));
        _types.put("matrix", new ConcreteMatrixToken());
        _types.put("object", new ObjectToken());
        _types.put("xmltoken", new XMLToken());
        _types.put("scalar", new ConcreteScalarToken());
        _types.put("string", new StringToken(""));
        _types.put("unknown", new UnknownToken());
        _types.put("unsignedByte", new UnsignedByteToken(0));
        _table.putAll(_types);
        Token nil = Token.NIL;
        _table.put("nil", nil);
    }

    private Constants() {
    }

    public static void add(String name, Token value) {
        _table.put(name, value);
    }

    public static RecordToken constants() {
        int size = _table.size();
        String[] names = new String[size];
        Token[] values = new Token[size];
        Iterator keys = _table.keySet().iterator();
        int i = 0;
        while (keys.hasNext()) {
            String key;
            names[i] = key = (String)keys.next();
            values[i] = (Token)_table.get(key);
            ++i;
        }
        try {
            return new RecordToken(names, values);
        }
        catch (IllegalActionException illegalActionException) {
            throw new InternalErrorException("Cannot construct a record!");
        }
    }

    public static Token get(String name) {
        return (Token)_table.get(name);
    }

    public static void remove(String name) {
        _table.remove(name);
    }

    public static TreeMap types() {
        return new TreeMap(_types);
    }

    private static void _putProperty(String variableName, String property) {
        try {
            _table.put(variableName, new StringToken(StringUtilities.getProperty(property)));
        }
        catch (SecurityException securityException) {
            System.out.println("Warning: While trying to set '" + variableName + "', failed to read '" + property + "' property " + "(-sandbox always causes this)");
        }
    }
}

