/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data.expr;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import ptolemy.data.ArrayToken;
import ptolemy.data.MatrixToken;
import ptolemy.data.Token;
import ptolemy.data.expr.ConversionUtilities;
import ptolemy.data.expr.PtParser;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.MatrixType;
import ptolemy.data.type.Type;
import ptolemy.data.type.TypeLattice;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;

public class CachedMethod {
    public static final int FUNCTION = 8;
    public static final int METHOD = 16;
    public static final ArgumentConversion IMPOSSIBLE_CONVERSION = new ArgumentConversion(0);
    public static final ArgumentConversion ARRAYTOKEN_CONVERSION = new ArgumentConversion(1){

        public Object convert(Token input) throws IllegalActionException {
            return ((ArrayToken)input).arrayValue();
        }
    };
    public static final ArgumentConversion NATIVE_CONVERSION = new ArgumentConversion(3){

        public Object convert(Token input) throws IllegalActionException {
            return ConversionUtilities.convertTokenToJavaType(input);
        }
    };
    public static final ArgumentConversion IDENTITY_CONVERSION = new ArgumentConversion(4){

        public Object convert(Token input) throws IllegalActionException {
            return input;
        }
    };
    private String _methodName;
    private Type[] _argumentTypes;
    private Method _method;
    private ArgumentConversion[] _conversions;
    private int _hashcode;
    private Type _returnType;
    private int _type;
    private static Hashtable _cachedMethods = new Hashtable();

    protected CachedMethod(String methodName, Type[] argumentTypes, Method method, ArgumentConversion[] conversions, int type) throws IllegalActionException {
        this._methodName = methodName;
        this._argumentTypes = (Type[])argumentTypes.clone();
        this._method = method;
        this._conversions = conversions != null ? (ArgumentConversion[])conversions.clone() : null;
        this._type = type;
        this._returnType = null;
        this._hashcode = methodName.hashCode();
        int i = 0;
        while (i < argumentTypes.length) {
            this._hashcode += argumentTypes[i].hashCode();
            ++i;
        }
        if (this._method != null) {
            Class<?> returnClass = this._method.getReturnType();
            this._returnType = ConversionUtilities.convertJavaTypeToTokenType(returnClass);
            try {
                int args = this._argumentTypes.length;
                Object[] typeArray = new Class[args];
                Class<Type> typeClass = Type.class;
                Arrays.fill(typeArray, typeClass);
                Method typeFunction = this._method.getDeclaringClass().getMethod(String.valueOf(this._methodName) + "ReturnType", (Class<?>[])typeArray);
                try {
                    this._returnType = (Type)typeFunction.invoke(null, (Object[])this._argumentTypes);
                }
                catch (IllegalAccessException ex) {
                    throw new RuntimeException(ex);
                }
                catch (InvocationTargetException ex) {
                    throw new RuntimeException(ex);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
    }

    public static void clear() {
        _cachedMethods.clear();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CachedMethod)) {
            return false;
        }
        CachedMethod cachedMethod = (CachedMethod)object;
        if (!this._methodName.equals(cachedMethod._methodName)) {
            return false;
        }
        if ((this._type & 0x18) != (cachedMethod._type & 0x18)) {
            return false;
        }
        if (this._argumentTypes.length != cachedMethod._argumentTypes.length) {
            return false;
        }
        int i = 0;
        while (i < this._argumentTypes.length) {
            if (!this._argumentTypes[i].equals(cachedMethod._argumentTypes[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static CachedMethod findMethod(String methodName, Type[] argumentTypes, int type) throws IllegalActionException {
        Type[] newArgTypes;
        boolean[] isArrayArg;
        boolean hasArray;
        CachedMethod cachedMethod = CachedMethod._getCachedMethod(methodName, argumentTypes, type);
        if (cachedMethod != null) {
            return cachedMethod;
        }
        if (type == 16) {
            cachedMethod = CachedMethod._findMETHOD(methodName, argumentTypes);
        } else if (type == 8) {
            cachedMethod = CachedMethod._findFUNCTION(methodName, argumentTypes);
        } else {
            throw new IllegalActionException("Attempted to find a method with an invalid type = " + type);
        }
        if (cachedMethod == null) {
            CachedMethod mapCachedMethod;
            hasArray = false;
            isArrayArg = new boolean[argumentTypes.length];
            newArgTypes = new Type[argumentTypes.length];
            int i = 0;
            while (i < argumentTypes.length) {
                if (argumentTypes[i] instanceof ArrayType) {
                    hasArray = true;
                    newArgTypes[i] = ((ArrayType)argumentTypes[i]).getElementType();
                    isArrayArg[i] = true;
                } else {
                    newArgTypes[i] = argumentTypes[i];
                    isArrayArg[i] = false;
                }
                ++i;
            }
            if (hasArray && (mapCachedMethod = CachedMethod.findMethod(methodName, newArgTypes, type)).isValid()) {
                cachedMethod = new ArrayMapCachedMethod(methodName, argumentTypes, type, mapCachedMethod, isArrayArg);
            }
        }
        if (cachedMethod == null) {
            CachedMethod mapCachedMethod;
            hasArray = false;
            isArrayArg = new boolean[argumentTypes.length];
            newArgTypes = new Type[argumentTypes.length];
            int i = 0;
            while (i < argumentTypes.length) {
                if (argumentTypes[i] instanceof MatrixType) {
                    hasArray = true;
                    newArgTypes[i] = ((MatrixType)argumentTypes[i]).getElementType();
                    isArrayArg[i] = true;
                } else {
                    newArgTypes[i] = argumentTypes[i];
                    isArrayArg[i] = false;
                }
                ++i;
            }
            if (hasArray && (mapCachedMethod = CachedMethod.findMethod(methodName, newArgTypes, type)).isValid()) {
                cachedMethod = new MatrixMapCachedMethod(methodName, argumentTypes, type, mapCachedMethod, isArrayArg);
            }
        }
        if (cachedMethod == null) {
            cachedMethod = new CachedMethod(methodName, argumentTypes, null, null, type);
        }
        CachedMethod._addCachedMethod(cachedMethod);
        return cachedMethod;
    }

    public int getCachedMethodType() {
        return this._type;
    }

    public ArgumentConversion[] getConversions() {
        return this._conversions;
    }

    public Method getMethod() throws IllegalActionException {
        if (this.isValid()) {
            return this._method;
        }
        throw new IllegalActionException("No method " + this.toString() + " was found!");
    }

    public Type getReturnType() throws IllegalActionException {
        if (this._returnType == null) {
            throw new IllegalActionException("The return type of the method " + this.toString() + " cannot be determined because " + "no matching method was found.");
        }
        return this._returnType;
    }

    public int hashCode() {
        return this._hashcode;
    }

    public Token invoke(Object[] argValues) throws IllegalActionException {
        Object result = null;
        Method method = this.getMethod();
        if (this.isMethod()) {
            int num = argValues.length;
            Object[] methodArgValues = new Object[num - 1];
            if (num == 1) {
                methodArgValues = null;
            }
            int i = 1;
            while (i < num) {
                methodArgValues[i - 1] = this._conversions[i - 1].convert((Token)argValues[i]);
                ++i;
            }
            try {
                result = method.invoke(argValues[0], methodArgValues);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (InvocationTargetException ex) {
                throw new IllegalActionException(null, ex.getCause(), "Error invoking method " + method + " on object " + argValues[0] + "\n");
            }
            catch (Exception ex) {
                throw new IllegalActionException(null, ex, "Error invoking method " + method + " on object " + argValues[0] + "\n");
            }
            return ConversionUtilities.convertJavaTypeToToken(result);
        }
        if (this.isFunction()) {
            int num = argValues.length;
            Object[] methodArgValues = new Object[num];
            if (num == 0) {
                methodArgValues = null;
            }
            int i = 0;
            while (i < num) {
                methodArgValues[i] = this._conversions[i].convert((Token)argValues[i]);
                ++i;
            }
            try {
                result = method.invoke(method.getDeclaringClass(), methodArgValues);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (InvocationTargetException ex) {
                throw new IllegalActionException(null, ex.getCause(), "Error invoking function " + method + "\n");
            }
            catch (Exception ex) {
                throw new IllegalActionException(null, ex, "Error invoking function " + method + "\n");
            }
            return ConversionUtilities.convertJavaTypeToToken(result);
        }
        throw new IllegalActionException("Cannot invoke function " + method + " that is not simple function or method");
    }

    public boolean isFunction() {
        return (this._type & 8) == 8;
    }

    public boolean isMethod() {
        return (this._type & 0x10) == 16;
    }

    public boolean isValid() {
        return this._method != null;
    }

    public String methodDescription() {
        if (this.isValid()) {
            return this._method.toString();
        }
        return "INVALID METHOD!!!";
    }

    public String toString() {
        int initialArg = 0;
        StringBuffer buffer = new StringBuffer();
        if (this.isMethod()) {
            initialArg = 1;
            buffer.append(this._argumentTypes[0].toString());
            buffer.append(".");
        }
        buffer.append(this._methodName);
        buffer.append("(");
        int i = initialArg;
        while (i < this._argumentTypes.length) {
            if (i == initialArg) {
                buffer.append(this._argumentTypes[i].toString());
            } else {
                buffer.append(", " + this._argumentTypes[i].toString());
            }
            ++i;
        }
        buffer.append(")");
        return buffer.toString();
    }

    protected static boolean _areConversionsPreferable(ArgumentConversion[] conversions1, Class[] arguments1, ArgumentConversion[] conversions2, Class[] arguments2) {
        if (conversions1.length != conversions2.length) {
            throw new InternalErrorException("Conversion arrays have to have the same length.");
        }
        int j = 0;
        while (j < conversions1.length) {
            if (conversions2[j].isPreferableTo(conversions1[j])) {
                return false;
            }
            if (conversions2[j].equals(conversions1[j])) {
                Class class1 = arguments1[j];
                Class class2 = arguments2[j];
                try {
                    Type type1 = ConversionUtilities.convertJavaTypeToTokenType(class1);
                    Type type2 = ConversionUtilities.convertJavaTypeToTokenType(class2);
                    if (TypeLattice.compare(type2, type1) == -1) {
                        return false;
                    }
                }
                catch (IllegalActionException illegalActionException) {}
            }
            ++j;
        }
        return true;
    }

    protected static ArgumentConversion _getConversion(Class formal, Type actual) {
        if (formal.isAssignableFrom(actual.getTokenClass())) {
            return IDENTITY_CONVERSION;
        }
        if (actual instanceof ArrayType && formal.isArray() && formal.getComponentType().isAssignableFrom(Token.class)) {
            return ARRAYTOKEN_CONVERSION;
        }
        try {
            if (formal.isAssignableFrom(ConversionUtilities.convertTokenTypeToJavaType(actual))) {
                return NATIVE_CONVERSION;
            }
        }
        catch (IllegalActionException illegalActionException) {}
        try {
            Type type;
            if ((formal.isPrimitive() || formal.isArray()) && -1 == TypeLattice.compare(actual, type = ConversionUtilities.convertJavaTypeToTokenType(formal))) {
                return new TypeArgumentConversion(type, NATIVE_CONVERSION);
            }
        }
        catch (IllegalActionException illegalActionException) {}
        return IMPOSSIBLE_CONVERSION;
    }

    protected static Method _polymorphicGetMethod(Class library, String methodName, Type[] argumentTypes, ArgumentConversion[] conversions) {
        Method matchedMethod = null;
        ArgumentConversion[] matchedConversions = new ArgumentConversion[conversions.length];
        while (library != null) {
            Method[] methods;
            try {
                methods = library.getDeclaredMethods();
            }
            catch (SecurityException securityException) {
                methods = library.getMethods();
            }
            int i = 0;
            while (i < methods.length) {
                if (methods[i].getName().equals(methodName)) {
                    int actualArgCount;
                    Class[] arguments = methods[i].getParameterTypes();
                    if (arguments.length == (actualArgCount = argumentTypes == null ? 0 : argumentTypes.length)) {
                        boolean match = true;
                        int j = 0;
                        while (j < arguments.length && match) {
                            ArgumentConversion conversion = CachedMethod._getConversion(arguments[j], argumentTypes[j]);
                            match = match && conversion != IMPOSSIBLE_CONVERSION;
                            conversions[j] = conversion;
                            ++j;
                        }
                        if (match && matchedMethod != null) {
                            match = CachedMethod._areConversionsPreferable(conversions, arguments, matchedConversions, matchedMethod.getParameterTypes());
                        }
                        if (match) {
                            matchedMethod = methods[i];
                            System.arraycopy(conversions, 0, matchedConversions, 0, actualArgCount);
                        }
                    }
                }
                ++i;
            }
            library = library.getSuperclass();
        }
        System.arraycopy(matchedConversions, 0, conversions, 0, conversions.length);
        return matchedMethod;
    }

    private static void _addCachedMethod(CachedMethod cachedMethod) {
        _cachedMethods.put(cachedMethod, cachedMethod);
    }

    private static CachedMethod _findFUNCTION(String methodName, Type[] argumentTypes) throws IllegalActionException {
        CachedMethod cachedMethod = null;
        ArgumentConversion[] conversions = new ArgumentConversion[argumentTypes.length];
        Iterator allClasses = PtParser.getRegisteredClasses().iterator();
        Method preferredMethod = null;
        ArgumentConversion[] preferredConversions = null;
        while (allClasses.hasNext() && cachedMethod == null) {
            Class nextClass = (Class)allClasses.next();
            try {
                Method method = CachedMethod._polymorphicGetMethod(nextClass, methodName, argumentTypes, conversions);
                if (method == null || preferredMethod != null && !CachedMethod._areConversionsPreferable(conversions, method.getParameterTypes(), preferredConversions, preferredMethod.getParameterTypes())) continue;
                preferredMethod = method;
                preferredConversions = (ArgumentConversion[])conversions.clone();
            }
            catch (SecurityException securityException) {}
        }
        if (preferredMethod != null) {
            cachedMethod = new CachedMethod(methodName, argumentTypes, preferredMethod, preferredConversions, 8);
        }
        return cachedMethod;
    }

    private static CachedMethod _findMETHOD(String methodName, Type[] argumentTypes) throws IllegalActionException {
        Method method;
        Type[] methodArgTypes;
        CachedMethod cachedMethod = null;
        int num = argumentTypes.length;
        ArgumentConversion[] conversions = new ArgumentConversion[num - 1];
        Class destTokenClass = argumentTypes[0].getTokenClass();
        if (num == 1) {
            methodArgTypes = null;
        } else {
            methodArgTypes = new Type[num - 1];
            int i = 1;
            while (i < num) {
                methodArgTypes[i - 1] = argumentTypes[i];
                ++i;
            }
        }
        try {
            Method method2 = CachedMethod._polymorphicGetMethod(destTokenClass, methodName, methodArgTypes, conversions);
            if (method2 != null) {
                cachedMethod = new CachedMethod(methodName, argumentTypes, method2, conversions, 16);
            }
        }
        catch (SecurityException securityException) {}
        if (cachedMethod == null && (method = CachedMethod._polymorphicGetMethod(destTokenClass = ConversionUtilities.convertTokenTypeToJavaType(argumentTypes[0]), methodName, methodArgTypes, conversions)) != null) {
            cachedMethod = new BaseConvertCachedMethod(methodName, argumentTypes, method, NATIVE_CONVERSION, conversions);
        }
        return cachedMethod;
    }

    private static CachedMethod _getCachedMethod(String methodName, Type[] argumentTypes, int type) throws IllegalActionException {
        CachedMethod key = new CachedMethod(methodName, argumentTypes, null, null, type);
        CachedMethod method = (CachedMethod)_cachedMethods.get(key);
        return method;
    }

    public static class ArgumentConversion {
        protected int _preference;

        private ArgumentConversion(int preference) {
            this._preference = preference;
        }

        public int getPreference() {
            return this._preference;
        }

        public Object convert(Token input) throws IllegalActionException {
            throw new IllegalActionException("Cannot convert argument token " + input);
        }

        public boolean isPreferableTo(ArgumentConversion conversion) {
            return this._preference > conversion.getPreference();
        }

        public String toString() {
            return "Conversion " + this._preference;
        }

        /* synthetic */ ArgumentConversion(int n, ArgumentConversion argumentConversion, ArgumentConversion argumentConversion2) {
            this(n);
        }
    }

    public static class ArrayMapCachedMethod
    extends CachedMethod {
        private CachedMethod _cachedMethod;
        private boolean[] _reducedArgs;

        public ArrayMapCachedMethod(String methodName, Type[] argumentTypes, int type, CachedMethod cachedMethod, boolean[] reducedArgs) throws IllegalActionException {
            super(methodName, argumentTypes, null, null, type);
            this._cachedMethod = cachedMethod;
            this._reducedArgs = reducedArgs;
        }

        public Token invoke(Object[] argValues) throws IllegalActionException {
            int dim = 0;
            int i = 0;
            while (i < argValues.length) {
                if (this._reducedArgs[i]) {
                    if (argValues[i] instanceof ArrayToken) {
                        ArrayToken arrayToken = (ArrayToken)argValues[i];
                        if (dim != 0 && arrayToken.length() != dim) {
                            throw new IllegalActionException("Argument " + i + " is a reducible arrayToken that " + "does not have compatible length!");
                        }
                        dim = arrayToken.length();
                    } else {
                        throw new IllegalActionException("Argument " + i + " is not an instance of " + "ArrayToken!");
                    }
                }
                ++i;
            }
            Object[] subArgs = (Object[])argValues.clone();
            Token[] tokenArray = new Token[dim];
            int j = 0;
            while (j < dim) {
                int i2 = 0;
                while (i2 < argValues.length) {
                    if (this._reducedArgs[i2]) {
                        subArgs[i2] = ((ArrayToken)argValues[i2]).getElement(j);
                    }
                    ++i2;
                }
                tokenArray[j] = this._cachedMethod.invoke(subArgs);
                ++j;
            }
            return new ArrayToken(tokenArray);
        }

        public boolean isValid() {
            return this._cachedMethod.isValid();
        }

        public Type getReturnType() throws IllegalActionException {
            if (!this.isValid()) {
                throw new IllegalActionException("The return type of the method " + this.toString() + " cannot be determined because " + "no matching method was found.");
            }
            Type elementType = this._cachedMethod.getReturnType();
            return new ArrayType(elementType);
        }

        public String methodDescription() {
            return "ArrayMapped{" + this._cachedMethod.methodDescription() + "}";
        }
    }

    public static class BaseConvertCachedMethod
    extends CachedMethod {
        private ArgumentConversion _baseConversion;

        private BaseConvertCachedMethod(String methodName, Type[] argumentTypes, Method method, ArgumentConversion baseConversion, ArgumentConversion[] conversions) throws IllegalActionException {
            super(methodName, argumentTypes, method, conversions, 16);
            this._baseConversion = baseConversion;
        }

        public ArgumentConversion getBaseConversion() {
            return this._baseConversion;
        }

        public Token invoke(Object[] argValues) throws IllegalActionException {
            argValues[0] = this._baseConversion.convert((Token)argValues[0]);
            return super.invoke(argValues);
        }
    }

    public static class MatrixMapCachedMethod
    extends CachedMethod {
        private CachedMethod _cachedMethod;
        private boolean[] _reducedArgs;

        public MatrixMapCachedMethod(String methodName, Type[] argumentTypes, int type, CachedMethod cachedMethod, boolean[] reducedArgs) throws IllegalActionException {
            super(methodName, argumentTypes, null, null, type);
            this._cachedMethod = cachedMethod;
            this._reducedArgs = reducedArgs;
        }

        public Token invoke(Object[] argValues) throws IllegalActionException {
            int xdim = 0;
            int ydim = 0;
            int i = 0;
            while (i < argValues.length) {
                if (this._reducedArgs[i]) {
                    if (argValues[i] instanceof MatrixToken) {
                        MatrixToken matrixToken = (MatrixToken)argValues[i];
                        if (xdim != 0 && ydim != 0 && (matrixToken.getRowCount() != ydim || matrixToken.getColumnCount() != xdim)) {
                            throw new IllegalActionException("Argument " + i + " is a reducible matrixToken that " + "does not have compatible size!");
                        }
                        ydim = matrixToken.getRowCount();
                        xdim = matrixToken.getColumnCount();
                    } else {
                        throw new IllegalActionException("Argument " + i + " is not an instance of " + "MatrixToken!");
                    }
                }
                ++i;
            }
            Object[] subArgs = (Object[])argValues.clone();
            Token[] tokenArray = new Token[xdim * ydim];
            int pos = 0;
            int j = 0;
            while (j < ydim) {
                int k = 0;
                while (k < xdim) {
                    int i2 = 0;
                    while (i2 < argValues.length) {
                        if (this._reducedArgs[i2]) {
                            subArgs[i2] = ((MatrixToken)argValues[i2]).getElementAsToken(j, k);
                        }
                        ++i2;
                    }
                    tokenArray[pos++] = this._cachedMethod.invoke(subArgs);
                    ++k;
                }
                ++j;
            }
            return MatrixToken.arrayToMatrix(tokenArray, ydim, xdim);
        }

        public boolean isValid() {
            return this._cachedMethod.isValid();
        }

        public Type getReturnType() throws IllegalActionException {
            if (!this.isValid()) {
                throw new IllegalActionException("The return type of the method " + this.toString() + " cannot be determined because " + "no matching method was found.");
            }
            Type elementType = this._cachedMethod.getReturnType();
            return MatrixType.getMatrixTypeForElementType(elementType);
        }

        public String methodDescription() {
            return "MatrixMapped{" + this._cachedMethod.methodDescription() + "}";
        }
    }

    public static class TypeArgumentConversion
    extends ArgumentConversion {
        private Type _conversionType;
        private ArgumentConversion _conversion;

        private TypeArgumentConversion(Type type, ArgumentConversion conversion) {
            super(2, null, null);
            this._conversionType = type;
            this._conversion = conversion;
        }

        public Object convert(Token input) throws IllegalActionException {
            Token token = this._conversionType.convert(input);
            return this._conversion.convert(token);
        }

        public boolean isPreferableTo(ArgumentConversion conversion) {
            if (this._preference > conversion.getPreference()) {
                return true;
            }
            if (this._preference == conversion.getPreference()) {
                TypeArgumentConversion argumentConversion = (TypeArgumentConversion)conversion;
                if (TypeLattice.compare(this._conversionType, argumentConversion._conversionType) == -1) {
                    return true;
                }
                if (this._conversionType == BaseType.INT && argumentConversion._conversionType == BaseType.FLOAT) {
                    return true;
                }
                return this._conversion.isPreferableTo(argumentConversion._conversion);
            }
            return false;
        }

        public String toString() {
            return "TypeConversion(" + this._conversionType + ", " + this._conversion + ") " + this._preference;
        }
    }
}

