/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data;

import java.io.Serializable;
import ptolemy.data.BooleanToken;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.math.Complex;

public class Token
implements Serializable {
    public static final Token NIL = new Token(){

        public Type getType() {
            return BaseType.NIL;
        }
    };

    public Token add(Token rightArgument) throws IllegalActionException {
        if (this.isNil() || rightArgument.isNil()) {
            return NIL;
        }
        throw new IllegalActionException(Token.notSupportedMessage("add", this, rightArgument));
    }

    public Token addReverse(Token leftArgument) throws IllegalActionException {
        if (this.isNil() || leftArgument.isNil()) {
            return NIL;
        }
        throw new IllegalActionException(Token.notSupportedMessage("addReverse", this, leftArgument));
    }

    public Token divide(Token rightArgument) throws IllegalActionException {
        if (this.isNil() || rightArgument.isNil()) {
            return NIL;
        }
        throw new IllegalActionException(Token.notSupportedMessage("divide", this, rightArgument));
    }

    public Token divideReverse(Token leftArgument) throws IllegalActionException {
        if (this.isNil() || leftArgument.isNil()) {
            return NIL;
        }
        throw new IllegalActionException(Token.notSupportedMessage("divideReverse", this, leftArgument));
    }

    public Type getType() {
        return BaseType.GENERAL;
    }

    public final BooleanToken isCloseTo(Token token) throws IllegalActionException {
        return this.isCloseTo(token, Complex.EPSILON);
    }

    public BooleanToken isCloseTo(Token token, double epsilon) throws IllegalActionException {
        if (this.isNil() || token.isNil()) {
            return BooleanToken.FALSE;
        }
        throw new IllegalActionException(Token.notSupportedMessage("isCloseTo", this, token));
    }

    public BooleanToken isEqualTo(Token rightArgument) throws IllegalActionException {
        if (this.isNil() || rightArgument.isNil()) {
            return BooleanToken.FALSE;
        }
        throw new IllegalActionException(Token.notSupportedMessage("isEqualTo", this, rightArgument));
    }

    public boolean isNil() {
        return this.equals(NIL);
    }

    public Token modulo(Token rightArgument) throws IllegalActionException {
        if (this.isNil() || rightArgument.isNil()) {
            return NIL;
        }
        throw new IllegalActionException(Token.notSupportedMessage("modulo", this, rightArgument));
    }

    public Token moduloReverse(Token leftArgument) throws IllegalActionException {
        if (this.isNil() || leftArgument.isNil()) {
            return NIL;
        }
        throw new IllegalActionException(Token.notSupportedMessage("moduloReverse", this, leftArgument));
    }

    public Token multiply(Token rightArgument) throws IllegalActionException {
        if (this.isNil() || rightArgument.isNil()) {
            return NIL;
        }
        throw new IllegalActionException(Token.notSupportedMessage("multiply", this, rightArgument));
    }

    public Token multiplyReverse(Token leftArgument) throws IllegalActionException {
        if (this.isNil() || leftArgument.isNil()) {
            return NIL;
        }
        throw new IllegalActionException(Token.notSupportedMessage("multiplyReverse", this, leftArgument));
    }

    public static String notSupportedConversionMessage(Token token, String typeString) {
        return "Conversion is not supported from " + token.getClass().getName() + " '" + token.toString() + "' to the type " + typeString + ".";
    }

    public static String notSupportedIncomparableConversionMessage(Token token, String typeString) {
        return "Conversion is not supported from " + token.getClass().getName() + " '" + token.toString() + "' to the type " + typeString + " because the type of the token is higher " + "or incomparable with the given type.";
    }

    public static String notSupportedIncomparableMessage(String operation, Token firstToken, Token secondToken) {
        return String.valueOf(operation) + " method not supported between " + firstToken.getClass().getName() + " '" + firstToken.toString() + "' and " + secondToken.getClass().getName() + " '" + secondToken.toString() + "' because the types are incomparable.";
    }

    public static String notSupportedMessage(String operation, Token firstToken, Token secondToken) {
        return String.valueOf(operation) + " operation not supported between " + firstToken.getClass().getName() + " '" + firstToken.toString() + "' and " + secondToken.getClass().getName() + " '" + secondToken.toString() + "'";
    }

    public Token one() throws IllegalActionException {
        if (this.isNil()) {
            return NIL;
        }
        throw new IllegalActionException("Multiplicative identity not supported on " + this.getClass().getName() + ".");
    }

    public Token pow(int times) throws IllegalActionException {
        if (times == 0) {
            return this.one();
        }
        if (times < 0) {
            Token result = this;
            int k = times;
            while (k < -1) {
                result = result.multiply(this);
                ++k;
            }
            return this.one().divide(result);
        }
        Token result = this;
        int k = 0;
        while (k < times - 1) {
            result = result.multiply(this);
            ++k;
        }
        return result;
    }

    public Token subtract(Token rightArgument) throws IllegalActionException {
        if (this.isNil() || rightArgument.isNil()) {
            return NIL;
        }
        throw new IllegalActionException(Token.notSupportedMessage("subtract", this, rightArgument));
    }

    public Token subtractReverse(Token leftArgument) throws IllegalActionException {
        if (this.isNil() || leftArgument.isNil()) {
            return NIL;
        }
        throw new IllegalActionException(Token.notSupportedMessage("subtractReverse", this, leftArgument));
    }

    public String toString() {
        if (this.isNil()) {
            return "nil";
        }
        return "present";
    }

    public Token zero() throws IllegalActionException {
        if (this.isNil()) {
            return NIL;
        }
        throw new IllegalActionException("Additive identity not supported on " + this.getClass().getName() + ".");
    }

    public static Type zeroReturnType(Type type) {
        return type;
    }

    public static String notSupportedNullNilStringMessage(String type, String init) {
        return "Creating a nil token with " + type + "(" + (init == null ? "null" : "\"" + init + "\"") + ") is not supported.  Use " + type + ".NIL, or" + " the nil Constant.";
    }
}

