/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data;

import ptolemy.data.BooleanToken;
import ptolemy.data.ScalarToken;
import ptolemy.data.Token;
import ptolemy.data.UnsignedByteToken;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.data.type.TypeLattice;
import ptolemy.data.unit.UnitUtilities;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.math.Complex;
import ptolemy.math.FixPoint;

public class ShortToken
extends ScalarToken {
    public static final ShortToken NIL = new ShortToken(Short.MAX_VALUE);
    public static final ShortToken ONE = new ShortToken(1);
    public static final ShortToken ZERO = new ShortToken(0);
    private final short _value;

    public ShortToken() {
        this._value = 0;
    }

    public ShortToken(short value) {
        this._value = value;
    }

    public ShortToken(int value) {
        this._value = (short)value;
    }

    public ShortToken(String init) throws IllegalActionException {
        if (init == null || init.equals("nil")) {
            throw new IllegalActionException(ShortToken.notSupportedNullNilStringMessage("ShortToken", init));
        }
        try {
            this._value = Short.parseShort(init);
        }
        catch (NumberFormatException e) {
            throw new IllegalActionException(null, e, "Failed to parse \"" + init + "\" as a number.");
        }
    }

    public Complex complexValue() {
        return new Complex(this._value);
    }

    public static ShortToken convert(Token token) throws IllegalActionException {
        if (token instanceof ShortToken) {
            return (ShortToken)token;
        }
        if (token.isNil()) {
            return NIL;
        }
        int compare = TypeLattice.compare((Type)BaseType.SHORT, token);
        if (compare == -1 || compare == 2) {
            throw new IllegalActionException(ShortToken.notSupportedIncomparableConversionMessage(token, "short"));
        }
        compare = TypeLattice.compare((Type)BaseType.UNSIGNED_BYTE, token);
        if (compare == 0 || compare == 1) {
            UnsignedByteToken unsignedByteToken = UnsignedByteToken.convert(token);
            ShortToken result = new ShortToken(unsignedByteToken.shortValue());
            if (unsignedByteToken._unitCategoryExponents != null && !UnitUtilities.isUnitless(unsignedByteToken._unitCategoryExponents)) {
                result._unitCategoryExponents = unsignedByteToken._copyOfCategoryExponents();
            }
            return result;
        }
        throw new IllegalActionException(ShortToken.notSupportedConversionMessage(token, "short"));
    }

    public double doubleValue() {
        return this._value;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        if (this.isNil() || ((ShortToken)object).isNil()) {
            return false;
        }
        return ((ShortToken)object).shortValue() == this._value;
    }

    public FixPoint fixValue() {
        return new FixPoint(this._value);
    }

    public float floatValue() {
        return this._value;
    }

    public Type getType() {
        return BaseType.SHORT;
    }

    public int hashCode() {
        return this._value;
    }

    public int intValue() {
        return this._value;
    }

    public boolean isNil() {
        return this == NIL;
    }

    public ScalarToken leftShift(int bits) {
        if (this.isNil()) {
            return NIL;
        }
        return new ShortToken(this._value << bits);
    }

    public ScalarToken logicalRightShift(int bits) {
        if (this.isNil()) {
            return NIL;
        }
        short returnValue = (short)(this._value >>> bits);
        returnValue = (short)(returnValue & Short.MAX_VALUE);
        return new ShortToken(returnValue);
    }

    public long longValue() {
        return this._value;
    }

    public Token one() {
        return ONE;
    }

    public ScalarToken rightShift(int bits) {
        if (this.isNil()) {
            return NIL;
        }
        return new ShortToken(this._value >> bits);
    }

    public short shortValue() {
        return this._value;
    }

    public String toString() {
        String unitString = "";
        if (!this._isUnitless()) {
            unitString = " * " + this.unitsString();
        }
        if (this.isNil()) {
            return super.toString();
        }
        return String.valueOf(Short.toString(this._value)) + unitString;
    }

    public Token zero() {
        return ZERO;
    }

    protected ScalarToken _absolute() {
        ShortToken result = this._value >= 0 ? this : new ShortToken((int)(-this._value));
        return result;
    }

    protected ScalarToken _add(ScalarToken rightArgument) {
        short sum = (short)(this._value + ((ShortToken)rightArgument).shortValue());
        return new ShortToken(sum);
    }

    protected ScalarToken _bitwiseAnd(ScalarToken rightArgument) {
        short sum = (short)(this._value & ((ShortToken)rightArgument).shortValue());
        return new ShortToken(sum);
    }

    protected ScalarToken _bitwiseNot() {
        ShortToken result = new ShortToken((int)(~this._value));
        return result;
    }

    protected ScalarToken _bitwiseOr(ScalarToken rightArgument) {
        short sum = (short)(this._value | ((ShortToken)rightArgument).shortValue());
        return new ShortToken(sum);
    }

    protected ScalarToken _bitwiseXor(ScalarToken rightArgument) {
        short sum = (short)(this._value ^ ((ShortToken)rightArgument).shortValue());
        return new ShortToken(sum);
    }

    protected ScalarToken _divide(ScalarToken rightArgument) {
        short quotient = (short)(this._value / ((ShortToken)rightArgument).shortValue());
        return new ShortToken(quotient);
    }

    protected BooleanToken _isCloseTo(ScalarToken rightArgument, double epsilon) {
        double left;
        double right = ((ShortToken)rightArgument).doubleValue();
        if (right > (left = this.doubleValue()) + epsilon || right < left - epsilon) {
            return BooleanToken.FALSE;
        }
        return BooleanToken.TRUE;
    }

    protected BooleanToken _isLessThan(ScalarToken rightArgument) throws IllegalActionException {
        ShortToken convertedArgument = (ShortToken)rightArgument;
        return BooleanToken.getInstance(this._value < convertedArgument.shortValue());
    }

    protected ScalarToken _modulo(ScalarToken rightArgument) {
        short remainder = (short)(this._value % ((ShortToken)rightArgument).shortValue());
        return new ShortToken(remainder);
    }

    protected ScalarToken _multiply(ScalarToken rightArgument) {
        short product = (short)(this._value * ((ShortToken)rightArgument).shortValue());
        return new ShortToken(product);
    }

    protected ScalarToken _subtract(ScalarToken rightArgument) {
        short difference = (short)(this._value - ((ShortToken)rightArgument).shortValue());
        return new ShortToken(difference);
    }
}

