/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data;

import ptolemy.data.BitwiseOperationToken;
import ptolemy.data.BooleanToken;
import ptolemy.data.IntToken;
import ptolemy.data.MatrixToken;
import ptolemy.data.Token;
import ptolemy.data.type.Type;
import ptolemy.data.type.TypeLattice;
import ptolemy.data.unit.UnitUtilities;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.math.Complex;
import ptolemy.math.FixPoint;

public abstract class ScalarToken
extends Token
implements BitwiseOperationToken {
    protected int[] _unitCategoryExponents = null;

    public final ScalarToken absolute() {
        if (this.isNil()) {
            return this;
        }
        ScalarToken result = this._absolute();
        if (this._unitCategoryExponents != null && !this._isUnitless()) {
            result._unitCategoryExponents = this._copyOfCategoryExponents();
        }
        return result;
    }

    public final Token add(Token rightArgument) throws IllegalActionException {
        Token lub;
        int typeInfo = TypeLattice.compare(this.getType(), rightArgument);
        if (typeInfo == 0 || this.getClass() == rightArgument.getClass()) {
            return this._doAdd(rightArgument);
        }
        if (typeInfo == 1) {
            ScalarToken convertedArgument = (ScalarToken)this.getType().convert(rightArgument);
            try {
                return this._doAdd(convertedArgument);
            }
            catch (IllegalActionException ex) {
                throw new IllegalActionException(null, ex, ScalarToken.notSupportedMessage("add", this, rightArgument));
            }
        }
        if (typeInfo == -1 || rightArgument instanceof MatrixToken) {
            return rightArgument.addReverse(this);
        }
        Type lubType = (Type)TypeLattice.lattice().leastUpperBound(this.getType(), rightArgument.getType());
        if (!lubType.equals(this.getType()) && !(lub = lubType.convert(this)).getType().equals(this.getType())) {
            return lub.add(rightArgument);
        }
        throw new IllegalActionException(ScalarToken.notSupportedIncomparableMessage("add", this, rightArgument));
    }

    public final Token addReverse(Token leftArgument) throws IllegalActionException {
        int typeInfo = TypeLattice.compare(leftArgument, this.getType());
        if (typeInfo == -1) {
            ScalarToken convertedArgument = (ScalarToken)this.getType().convert(leftArgument);
            try {
                return convertedArgument._doAdd(this);
            }
            catch (IllegalActionException ex) {
                throw new IllegalActionException(null, ex, ScalarToken.notSupportedMessage("addReverse", this, leftArgument));
            }
        }
        if (typeInfo == 0) {
            return ((ScalarToken)leftArgument)._doAdd(this);
        }
        if (typeInfo == 1) {
            return leftArgument.add(this);
        }
        throw new IllegalActionException(ScalarToken.notSupportedIncomparableMessage("addReverse", this, leftArgument));
    }

    public BitwiseOperationToken bitwiseAnd(Token rightArgument) throws IllegalActionException {
        int typeInfo = TypeLattice.compare(this.getType(), rightArgument);
        if (typeInfo == 0) {
            return this._doBitwiseAnd(rightArgument);
        }
        if (typeInfo == 1) {
            ScalarToken convertedArgument = (ScalarToken)this.getType().convert(rightArgument);
            try {
                return this._doBitwiseAnd(convertedArgument);
            }
            catch (IllegalActionException ex) {
                throw new IllegalActionException(null, ex, ScalarToken.notSupportedMessage("bitwiseAnd", this, rightArgument));
            }
        }
        if (typeInfo == -1) {
            if (!(rightArgument instanceof BitwiseOperationToken)) {
                throw new IllegalActionException(ScalarToken.notSupportedMessage("bitwiseAnd", this, rightArgument));
            }
            return ((BitwiseOperationToken)((Object)rightArgument)).bitwiseAnd(this);
        }
        throw new IllegalActionException(ScalarToken.notSupportedIncomparableMessage("bitwiseAnd", this, rightArgument));
    }

    public BitwiseOperationToken bitwiseNot() throws IllegalActionException {
        ScalarToken result = this._bitwiseNot();
        if (this._unitCategoryExponents != null && !this._isUnitless()) {
            result._unitCategoryExponents = this._copyOfCategoryExponents();
        }
        return result;
    }

    public BitwiseOperationToken bitwiseOr(Token rightArgument) throws IllegalActionException {
        int typeInfo = TypeLattice.compare(this.getType(), rightArgument);
        if (typeInfo == 0) {
            return this._doBitwiseOr(rightArgument);
        }
        if (typeInfo == 1) {
            ScalarToken convertedArgument = (ScalarToken)this.getType().convert(rightArgument);
            try {
                return this._doBitwiseOr(convertedArgument);
            }
            catch (IllegalActionException ex) {
                throw new IllegalActionException(null, ex, ScalarToken.notSupportedMessage("bitwiseOr", this, rightArgument));
            }
        }
        if (typeInfo == -1) {
            if (!(rightArgument instanceof BitwiseOperationToken)) {
                throw new IllegalActionException(ScalarToken.notSupportedMessage("bitwiseOr", this, rightArgument));
            }
            return ((BitwiseOperationToken)((Object)rightArgument)).bitwiseOr(this);
        }
        throw new IllegalActionException(ScalarToken.notSupportedIncomparableMessage("bitwiseOr", this, rightArgument));
    }

    public BitwiseOperationToken bitwiseXor(Token rightArgument) throws IllegalActionException {
        int typeInfo = TypeLattice.compare(this.getType(), rightArgument);
        if (typeInfo == 0) {
            return this._doBitwiseXor(rightArgument);
        }
        if (typeInfo == 1) {
            ScalarToken convertedArgument = (ScalarToken)this.getType().convert(rightArgument);
            try {
                return this._doBitwiseXor(convertedArgument);
            }
            catch (IllegalActionException ex) {
                throw new IllegalActionException(null, ex, ScalarToken.notSupportedMessage("bitwiseXor", this, rightArgument));
            }
        }
        if (typeInfo == -1) {
            if (!(rightArgument instanceof BitwiseOperationToken)) {
                throw new IllegalActionException(ScalarToken.notSupportedMessage("bitwiseXor", this, rightArgument));
            }
            return ((BitwiseOperationToken)((Object)rightArgument)).bitwiseXor(this);
        }
        throw new IllegalActionException(ScalarToken.notSupportedIncomparableMessage("bitwiseXor", this, rightArgument));
    }

    public byte byteValue() throws IllegalActionException {
        throw new IllegalActionException(ScalarToken.notSupportedConversionMessage(this, "byte"));
    }

    public Complex complexValue() throws IllegalActionException {
        throw new IllegalActionException(ScalarToken.notSupportedConversionMessage(this, "Complex"));
    }

    public final Token divide(Token rightArgument) throws IllegalActionException {
        Token lub;
        int typeInfo = TypeLattice.compare(this.getType(), rightArgument);
        if (typeInfo == 0 || this.getClass() == rightArgument.getClass()) {
            return this._doDivide(rightArgument);
        }
        if (typeInfo == 1) {
            ScalarToken convertedArgument = (ScalarToken)this.getType().convert(rightArgument);
            try {
                return this._doDivide(convertedArgument);
            }
            catch (IllegalActionException ex) {
                throw new IllegalActionException(null, ex, ScalarToken.notSupportedMessage("divide", this, rightArgument));
            }
        }
        if (typeInfo == -1) {
            return rightArgument.divideReverse(this);
        }
        Type lubType = (Type)TypeLattice.lattice().leastUpperBound(this.getType(), rightArgument.getType());
        if (lubType != null && !lubType.equals(this.getType()) && !(lub = lubType.convert(this)).getType().equals(this.getType())) {
            return lub.divide(rightArgument);
        }
        return rightArgument.divideReverse(this);
    }

    public final Token divideReverse(Token leftArgument) throws IllegalActionException {
        int typeInfo = TypeLattice.compare(leftArgument, this.getType());
        if (typeInfo == -1) {
            ScalarToken convertedArgument = (ScalarToken)this.getType().convert(leftArgument);
            try {
                return convertedArgument._doDivide(this);
            }
            catch (IllegalActionException ex) {
                throw new IllegalActionException(null, ex, ScalarToken.notSupportedMessage("divideReverse", this, leftArgument));
            }
        }
        if (typeInfo == 0) {
            return ((ScalarToken)leftArgument)._doDivide(this);
        }
        if (typeInfo == 1) {
            return leftArgument.divide(this);
        }
        throw new IllegalActionException(ScalarToken.notSupportedIncomparableMessage("divideReverse", this, leftArgument));
    }

    public double doubleValue() throws IllegalActionException {
        throw new IllegalActionException(ScalarToken.notSupportedConversionMessage(this, "double"));
    }

    public FixPoint fixValue() throws IllegalActionException {
        throw new IllegalActionException(ScalarToken.notSupportedConversionMessage(this, "fixedpoint"));
    }

    public float floatValue() throws IllegalActionException {
        throw new IllegalActionException(ScalarToken.notSupportedConversionMessage(this, "float"));
    }

    public abstract Type getType();

    public ScalarToken inUnitsOf(ScalarToken units) throws IllegalActionException {
        if (!this._areUnitsEqual(units)) {
            throw new IllegalActionException(String.valueOf(ScalarToken.notSupportedMessage("inUnitsOf", this, units)) + " because the units are not the same.");
        }
        return (ScalarToken)this.divide(units);
    }

    public int intValue() throws IllegalActionException {
        throw new IllegalActionException(ScalarToken.notSupportedConversionMessage(this, "int"));
    }

    public final BooleanToken isCloseTo(Token rightArgument, double epsilon) throws IllegalActionException {
        int typeInfo = TypeLattice.compare(this.getType(), rightArgument);
        if (typeInfo == 0 || this.getClass() == rightArgument.getClass()) {
            return this._doIsCloseTo(rightArgument, epsilon);
        }
        if (typeInfo == 1) {
            ScalarToken convertedArgument = (ScalarToken)this.getType().convert(rightArgument);
            try {
                return this._doIsCloseTo(convertedArgument, epsilon);
            }
            catch (IllegalActionException ex) {
                throw new IllegalActionException(null, ex, ScalarToken.notSupportedMessage("isCloseTo", this, rightArgument));
            }
        }
        if (typeInfo == -1) {
            return rightArgument.isCloseTo(this, epsilon);
        }
        throw new IllegalActionException(ScalarToken.notSupportedIncomparableMessage("isCloseTo", this, rightArgument));
    }

    public final BooleanToken isEqualTo(Token rightArgument) throws IllegalActionException {
        int typeInfo = TypeLattice.compare(this.getType(), rightArgument);
        if (typeInfo == 0 || this.getClass() == rightArgument.getClass()) {
            return this._doIsEqualTo(rightArgument);
        }
        if (typeInfo == 1) {
            ScalarToken convertedArgument = (ScalarToken)this.getType().convert(rightArgument);
            try {
                return this._doIsEqualTo(convertedArgument);
            }
            catch (IllegalActionException ex) {
                throw new IllegalActionException(null, ex, ScalarToken.notSupportedMessage("isEqualTo", this, rightArgument));
            }
        }
        if (typeInfo == -1) {
            return rightArgument.isEqualTo(this);
        }
        throw new IllegalActionException(ScalarToken.notSupportedIncomparableMessage("isEqualTo", this, rightArgument));
    }

    public final BooleanToken isGreaterThan(ScalarToken rightArgument) throws IllegalActionException {
        int typeInfo = TypeLattice.compare(this.getType(), (Token)rightArgument);
        if (typeInfo == 0) {
            return rightArgument._doIsLessThan(this);
        }
        if (typeInfo == 1) {
            ScalarToken convertedArgument = (ScalarToken)this.getType().convert(rightArgument);
            try {
                return convertedArgument._doIsLessThan(this);
            }
            catch (IllegalActionException ex) {
                throw new IllegalActionException(null, ex, ScalarToken.notSupportedMessage("isGreaterThan", this, rightArgument));
            }
        }
        if (typeInfo == -1) {
            return rightArgument.isLessThan(this);
        }
        throw new IllegalActionException(ScalarToken.notSupportedIncomparableMessage("isGreaterThan", this, rightArgument));
    }

    public final BooleanToken isLessThan(ScalarToken rightArgument) throws IllegalActionException {
        int typeInfo = TypeLattice.compare(this.getType(), (Token)rightArgument);
        if (typeInfo == 0) {
            return this._doIsLessThan(rightArgument);
        }
        if (typeInfo == 1) {
            ScalarToken convertedArgument = (ScalarToken)this.getType().convert(rightArgument);
            try {
                return this._doIsLessThan(convertedArgument);
            }
            catch (IllegalActionException ex) {
                throw new IllegalActionException(null, ex, ScalarToken.notSupportedMessage("isLessThan", this, rightArgument));
            }
        }
        if (typeInfo == -1) {
            return rightArgument.isGreaterThan(this);
        }
        throw new IllegalActionException(ScalarToken.notSupportedIncomparableMessage("isLessThan", this, rightArgument));
    }

    public ScalarToken leftShift(int bits) throws IllegalActionException {
        throw new IllegalActionException(ScalarToken.notSupportedMessage("leftShift", this, new IntToken(bits)));
    }

    public ScalarToken logicalRightShift(int bits) throws IllegalActionException {
        throw new IllegalActionException(ScalarToken.notSupportedMessage("logicalRightShift", this, new IntToken(bits)));
    }

    public long longValue() throws IllegalActionException {
        throw new IllegalActionException(ScalarToken.notSupportedConversionMessage(this, "long"));
    }

    public final Token modulo(Token rightArgument) throws IllegalActionException {
        Token lub;
        int typeInfo = TypeLattice.compare(this.getType(), rightArgument);
        if (typeInfo == 0 || this.getClass() == rightArgument.getClass()) {
            return this._doModulo(rightArgument);
        }
        if (typeInfo == 1) {
            ScalarToken convertedArgument = (ScalarToken)this.getType().convert(rightArgument);
            try {
                return this._doModulo(convertedArgument);
            }
            catch (IllegalActionException ex) {
                throw new IllegalActionException(null, ex, ScalarToken.notSupportedMessage("modulo", this, rightArgument));
            }
        }
        if (typeInfo == -1) {
            return rightArgument.moduloReverse(this);
        }
        Type lubType = (Type)TypeLattice.lattice().leastUpperBound(this.getType(), rightArgument.getType());
        if (lubType != null && !lubType.equals(this.getType()) && !(lub = lubType.convert(this)).getType().equals(this.getType())) {
            return lub.modulo(rightArgument);
        }
        return rightArgument.moduloReverse(this);
    }

    public final Token moduloReverse(Token leftArgument) throws IllegalActionException {
        int typeInfo = TypeLattice.compare(leftArgument, this.getType());
        if (typeInfo == -1) {
            ScalarToken convertedArgument = (ScalarToken)this.getType().convert(leftArgument);
            try {
                return convertedArgument._doModulo(this);
            }
            catch (IllegalActionException ex) {
                throw new IllegalActionException(null, ex, ScalarToken.notSupportedMessage("moduloReverse", this, leftArgument));
            }
        }
        if (typeInfo == 0) {
            return ((ScalarToken)leftArgument)._doModulo(this);
        }
        if (typeInfo == 1) {
            return leftArgument.modulo(this);
        }
        throw new IllegalActionException(ScalarToken.notSupportedIncomparableMessage("moduloReverse", this, leftArgument));
    }

    public final Token multiply(Token rightArgument) throws IllegalActionException {
        Token lub;
        int typeInfo = TypeLattice.compare(this.getType(), rightArgument);
        if (typeInfo == 0 || this.getClass() == rightArgument.getClass()) {
            return this._doMultiply(rightArgument);
        }
        if (typeInfo == 1) {
            ScalarToken convertedArgument = (ScalarToken)this.getType().convert(rightArgument);
            try {
                return this._doMultiply(convertedArgument);
            }
            catch (IllegalActionException ex) {
                throw new IllegalActionException(null, ex, ScalarToken.notSupportedMessage("multiply", this, rightArgument));
            }
        }
        if (typeInfo == -1 || rightArgument instanceof MatrixToken) {
            return rightArgument.multiplyReverse(this);
        }
        Type lubType = (Type)TypeLattice.lattice().leastUpperBound(this.getType(), rightArgument.getType());
        if (lubType != null && !lubType.equals(this.getType()) && !(lub = lubType.convert(this)).getType().equals(this.getType())) {
            return lub.multiply(rightArgument);
        }
        return rightArgument.multiplyReverse(this);
    }

    public final Token multiplyReverse(Token leftArgument) throws IllegalActionException {
        Token lub;
        int typeInfo = TypeLattice.compare(leftArgument, this.getType());
        if (typeInfo == -1) {
            ScalarToken convertedArgument = (ScalarToken)this.getType().convert(leftArgument);
            try {
                return convertedArgument._doMultiply(this);
            }
            catch (IllegalActionException ex) {
                throw new IllegalActionException(null, ex, ScalarToken.notSupportedMessage("multiplyReverse", this, leftArgument));
            }
        }
        if (typeInfo == 0) {
            return ((ScalarToken)leftArgument)._doMultiply(this);
        }
        if (typeInfo == 1 || leftArgument instanceof MatrixToken) {
            return leftArgument.multiply(this);
        }
        Type lubType = (Type)TypeLattice.lattice().leastUpperBound(this.getType(), leftArgument.getType());
        if (!lubType.equals(this.getType()) && !(lub = lubType.convert(this)).getType().equals(this.getType())) {
            return lub.multiplyReverse(leftArgument);
        }
        throw new IllegalActionException(ScalarToken.notSupportedIncomparableMessage("multiplyReverse", leftArgument, this));
    }

    public ScalarToken rightShift(int bits) throws IllegalActionException {
        throw new IllegalActionException(ScalarToken.notSupportedMessage("rightShift", this, new IntToken(bits)));
    }

    public void setUnitCategory(int index) {
        this._unitCategoryExponents = UnitUtilities.newUnitArrayInCategory(index);
    }

    public short shortValue() throws IllegalActionException {
        throw new IllegalActionException(ScalarToken.notSupportedConversionMessage(this, "short"));
    }

    public final Token subtract(Token rightArgument) throws IllegalActionException {
        Token lub;
        int typeInfo = TypeLattice.compare(this.getType(), rightArgument);
        if (typeInfo == 0 || this.getClass() == rightArgument.getClass()) {
            return this._doSubtract(rightArgument);
        }
        if (typeInfo == 1) {
            ScalarToken convertedArgument = (ScalarToken)this.getType().convert(rightArgument);
            try {
                return this._doSubtract(convertedArgument);
            }
            catch (IllegalActionException ex) {
                throw new IllegalActionException(null, ex, ScalarToken.notSupportedMessage("subtract", this, rightArgument));
            }
        }
        if (typeInfo == -1 || rightArgument instanceof MatrixToken) {
            return rightArgument.subtractReverse(this);
        }
        Type lubType = (Type)TypeLattice.lattice().leastUpperBound(this.getType(), rightArgument.getType());
        if (!lubType.equals(this.getType()) && !(lub = lubType.convert(this)).getType().equals(this.getType())) {
            return lub.subtract(rightArgument);
        }
        throw new IllegalActionException(ScalarToken.notSupportedIncomparableMessage("subtract", this, rightArgument));
    }

    public final Token subtractReverse(Token leftArgument) throws IllegalActionException {
        int typeInfo = TypeLattice.compare(leftArgument, this.getType());
        if (typeInfo == -1) {
            ScalarToken convertedArgument = (ScalarToken)this.getType().convert(leftArgument);
            try {
                return convertedArgument._doSubtract(this);
            }
            catch (IllegalActionException ex) {
                throw new IllegalActionException(null, ex, ScalarToken.notSupportedMessage("subtractReverse", this, leftArgument));
            }
        }
        if (typeInfo == 0) {
            return ((ScalarToken)leftArgument)._doSubtract(this);
        }
        if (typeInfo == 1) {
            return leftArgument.subtract(this);
        }
        throw new IllegalActionException(ScalarToken.notSupportedIncomparableMessage("subtractReverse", this, leftArgument));
    }

    public String unitsString() {
        return UnitUtilities.unitsString(this._unitCategoryExponents);
    }

    protected abstract ScalarToken _absolute();

    protected abstract ScalarToken _add(ScalarToken var1) throws IllegalActionException;

    protected int[] _addCategoryExponents(ScalarToken token) {
        return UnitUtilities.addUnitsArray(this._unitCategoryExponents, token._unitCategoryExponents);
    }

    protected boolean _areUnitsEqual(ScalarToken scalarToken) {
        return UnitUtilities.areUnitArraysEqual(this._unitCategoryExponents, scalarToken._unitCategoryExponents);
    }

    protected abstract ScalarToken _bitwiseAnd(ScalarToken var1) throws IllegalActionException;

    protected abstract ScalarToken _bitwiseNot() throws IllegalActionException;

    protected abstract ScalarToken _bitwiseOr(ScalarToken var1) throws IllegalActionException;

    protected abstract ScalarToken _bitwiseXor(ScalarToken var1) throws IllegalActionException;

    protected int[] _copyOfCategoryExponents() {
        return UnitUtilities.copyUnitsArray(this._unitCategoryExponents);
    }

    protected abstract ScalarToken _divide(ScalarToken var1) throws IllegalActionException;

    protected abstract BooleanToken _isCloseTo(ScalarToken var1, double var2) throws IllegalActionException;

    protected BooleanToken _isEqualTo(ScalarToken token) throws IllegalActionException {
        return BooleanToken.getInstance(this.equals(token));
    }

    protected abstract BooleanToken _isLessThan(ScalarToken var1) throws IllegalActionException;

    protected boolean _isUnitless() {
        return UnitUtilities.isUnitless(this._unitCategoryExponents);
    }

    protected abstract ScalarToken _modulo(ScalarToken var1) throws IllegalActionException;

    protected abstract ScalarToken _multiply(ScalarToken var1) throws IllegalActionException;

    protected abstract ScalarToken _subtract(ScalarToken var1) throws IllegalActionException;

    protected int[] _subtractCategoryExponents(ScalarToken token) {
        return UnitUtilities.subtractUnitsArray(this._unitCategoryExponents, token._unitCategoryExponents);
    }

    private Token _doAdd(Token rightArgument) throws IllegalActionException {
        if (this.isNil() || rightArgument.isNil()) {
            return this.getType().convert(Token.NIL);
        }
        ScalarToken convertedArgument = (ScalarToken)rightArgument;
        if (!this._areUnitsEqual(convertedArgument)) {
            throw new IllegalActionException(String.valueOf(ScalarToken.notSupportedMessage("add", this, rightArgument)) + " because the units are not the same.");
        }
        ScalarToken result = this._add(convertedArgument);
        if (this._unitCategoryExponents != null && !this._isUnitless()) {
            result._unitCategoryExponents = this._copyOfCategoryExponents();
        }
        return result;
    }

    private BitwiseOperationToken _doBitwiseAnd(Token rightArgument) throws IllegalActionException {
        if (this.isNil() || rightArgument.isNil()) {
            return (BitwiseOperationToken)((Object)this.getType().convert(Token.NIL));
        }
        ScalarToken convertedArgument = (ScalarToken)rightArgument;
        if (!this._areUnitsEqual(convertedArgument)) {
            throw new IllegalActionException(String.valueOf(ScalarToken.notSupportedMessage("bitwiseAnd", this, rightArgument)) + " because the units of this token: " + this.unitsString() + " are not the same as those of the argument: " + convertedArgument.unitsString());
        }
        ScalarToken result = this._bitwiseAnd(convertedArgument);
        if (this._unitCategoryExponents != null && !this._isUnitless()) {
            result._unitCategoryExponents = this._copyOfCategoryExponents();
        }
        return result;
    }

    private BitwiseOperationToken _doBitwiseOr(Token rightArgument) throws IllegalActionException {
        if (this.isNil() || rightArgument.isNil()) {
            return (BitwiseOperationToken)((Object)this.getType().convert(Token.NIL));
        }
        ScalarToken convertedArgument = (ScalarToken)rightArgument;
        if (!this._areUnitsEqual(convertedArgument)) {
            throw new IllegalActionException(String.valueOf(ScalarToken.notSupportedMessage("bitwiseOr", this, rightArgument)) + " because the units of this token: " + this.unitsString() + " are not the same as those of the argument: " + convertedArgument.unitsString());
        }
        ScalarToken result = this._bitwiseOr(convertedArgument);
        if (this._unitCategoryExponents != null && !this._isUnitless()) {
            result._unitCategoryExponents = this._copyOfCategoryExponents();
        }
        return result;
    }

    private BitwiseOperationToken _doBitwiseXor(Token rightArgument) throws IllegalActionException {
        if (this.isNil() || rightArgument.isNil()) {
            return (BitwiseOperationToken)((Object)this.getType().convert(Token.NIL));
        }
        ScalarToken convertedArgument = (ScalarToken)rightArgument;
        if (!this._areUnitsEqual(convertedArgument)) {
            throw new IllegalActionException(String.valueOf(ScalarToken.notSupportedMessage("bitwiseXor", this, rightArgument)) + " because the units of this token: " + this.unitsString() + " are not the same as those of the argument: " + convertedArgument.unitsString());
        }
        ScalarToken result = this._bitwiseXor(convertedArgument);
        if (this._unitCategoryExponents != null && !this._isUnitless()) {
            result._unitCategoryExponents = this._copyOfCategoryExponents();
        }
        return result;
    }

    private Token _doDivide(Token rightArgument) throws IllegalActionException {
        if (this.isNil() || rightArgument.isNil()) {
            return this.getType().convert(Token.NIL);
        }
        ScalarToken convertedArgument = (ScalarToken)rightArgument;
        ScalarToken result = this._divide(convertedArgument);
        if (this._unitCategoryExponents != null && !this._isUnitless() || convertedArgument._unitCategoryExponents != null && !convertedArgument._isUnitless()) {
            result._unitCategoryExponents = this._subtractCategoryExponents(convertedArgument);
        }
        return result;
    }

    private BooleanToken _doIsCloseTo(Token rightArgument, double epsilon) throws IllegalActionException {
        if (this.isNil() || rightArgument.isNil()) {
            return BooleanToken.FALSE;
        }
        ScalarToken convertedArgument = (ScalarToken)rightArgument;
        if (!this._areUnitsEqual(convertedArgument)) {
            throw new IllegalActionException(String.valueOf(ScalarToken.notSupportedMessage("isCloseTo", this, rightArgument)) + " because the units are not the same.");
        }
        return this._isCloseTo(convertedArgument, epsilon);
    }

    private BooleanToken _doIsEqualTo(Token rightArgument) throws IllegalActionException {
        if (this.isNil() || rightArgument.isNil()) {
            return BooleanToken.FALSE;
        }
        ScalarToken convertedArgument = (ScalarToken)rightArgument;
        if (!this._areUnitsEqual(convertedArgument)) {
            return BooleanToken.FALSE;
        }
        return this._isEqualTo(convertedArgument);
    }

    private BooleanToken _doIsLessThan(Token rightArgument) throws IllegalActionException {
        if (this.isNil() || rightArgument.isNil()) {
            throw new IllegalActionException(String.valueOf(ScalarToken.notSupportedMessage("isLessThan", this, rightArgument)) + " because one or the other is nil");
        }
        ScalarToken convertedArgument = (ScalarToken)rightArgument;
        if (!this._areUnitsEqual(convertedArgument)) {
            throw new IllegalActionException(String.valueOf(ScalarToken.notSupportedMessage("isLessThan", this, rightArgument)) + " because the units are not the same.");
        }
        return this._isLessThan(convertedArgument);
    }

    private Token _doModulo(Token rightArgument) throws IllegalActionException {
        if (this.isNil() || rightArgument.isNil()) {
            return this.getType().convert(Token.NIL);
        }
        ScalarToken convertedArgument = (ScalarToken)rightArgument;
        if (!this._areUnitsEqual(convertedArgument)) {
            throw new IllegalActionException(String.valueOf(ScalarToken.notSupportedMessage("modulo", this, rightArgument)) + " because the units are not the same.");
        }
        ScalarToken result = this._modulo(convertedArgument);
        if (this._unitCategoryExponents != null && !this._isUnitless()) {
            result._unitCategoryExponents = this._copyOfCategoryExponents();
        }
        return result;
    }

    private Token _doMultiply(Token rightArgument) throws IllegalActionException {
        if (this.isNil() || rightArgument.isNil()) {
            return this.getType().convert(Token.NIL);
        }
        ScalarToken convertedArgument = (ScalarToken)rightArgument;
        ScalarToken result = this._multiply(convertedArgument);
        if (this._unitCategoryExponents != null && !this._isUnitless() || convertedArgument._unitCategoryExponents != null && !convertedArgument._isUnitless()) {
            result._unitCategoryExponents = this._addCategoryExponents(convertedArgument);
        }
        return result;
    }

    private Token _doSubtract(Token rightArgument) throws IllegalActionException {
        if (this.isNil() || rightArgument.isNil()) {
            return this.getType().convert(Token.NIL);
        }
        ScalarToken convertedArgument = (ScalarToken)rightArgument;
        if (!this._areUnitsEqual(convertedArgument)) {
            throw new IllegalActionException(String.valueOf(ScalarToken.notSupportedMessage("subtract", this, rightArgument)) + " because the units are not the same.");
        }
        ScalarToken result = this._subtract(convertedArgument);
        if (this._unitCategoryExponents != null && !this._isUnitless()) {
            result._unitCategoryExponents = this._copyOfCategoryExponents();
        }
        return result;
    }
}

