/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data;

import java.util.HashSet;
import java.util.Set;
import ptolemy.data.ArrayToken;
import ptolemy.data.BooleanMatrixToken;
import ptolemy.data.BooleanToken;
import ptolemy.data.ComplexMatrixToken;
import ptolemy.data.DoubleMatrixToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.FixMatrixToken;
import ptolemy.data.IntMatrixToken;
import ptolemy.data.LongMatrixToken;
import ptolemy.data.LongToken;
import ptolemy.data.ScalarToken;
import ptolemy.data.Token;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.FixType;
import ptolemy.data.type.MatrixType;
import ptolemy.data.type.Type;
import ptolemy.data.type.TypeLattice;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.math.Complex;
import ptolemy.math.FixPoint;

public abstract class MatrixToken
extends Token {
    public static final int DO_COPY = 0;
    public static final int DO_NOT_COPY = 1;
    protected Set _nils;

    public Token add(Token rightArgument) throws IllegalActionException {
        Token lub;
        Type elementType = this.getElementType();
        int typeInfo = TypeLattice.compare(elementType, rightArgument);
        if (typeInfo == 0) {
            MatrixToken result = this._addElement(rightArgument);
            return result;
        }
        if (typeInfo == 1) {
            Token convertedArgument = elementType.convert(rightArgument);
            try {
                MatrixToken result = this._addElement(convertedArgument);
                return result;
            }
            catch (IllegalActionException ex) {
                throw new IllegalActionException(null, ex, MatrixToken.notSupportedMessage("add", this, rightArgument));
            }
        }
        typeInfo = TypeLattice.compare(this.getType(), rightArgument);
        if (typeInfo == 0) {
            Token result = this._doAdd(rightArgument);
            return result;
        }
        if (typeInfo == 1) {
            MatrixToken convertedArgument = (MatrixToken)this.getType().convert(rightArgument);
            try {
                Token result = this._doAdd(convertedArgument);
                return result;
            }
            catch (IllegalActionException ex) {
                throw new IllegalActionException(null, ex, MatrixToken.notSupportedMessage("add", this, rightArgument));
            }
        }
        if (typeInfo == -1) {
            Token result = rightArgument.addReverse(this);
            return result;
        }
        Type lubType = (Type)TypeLattice.lattice().leastUpperBound(this.getType(), rightArgument.getType());
        if (!lubType.equals(this.getType()) && !(lub = lubType.convert(this)).getType().equals(this.getType())) {
            return lub.add(rightArgument);
        }
        throw new IllegalActionException(MatrixToken.notSupportedIncomparableMessage("add", this, rightArgument));
    }

    public Token addReverse(Token leftArgument) throws IllegalActionException {
        Token lub;
        Type elementType = this.getElementType();
        int typeInfo = TypeLattice.compare(leftArgument, elementType);
        if (typeInfo == -1) {
            Token convertedArgument = elementType.convert(leftArgument);
            try {
                MatrixToken result = this._addElement(convertedArgument);
                return result;
            }
            catch (IllegalActionException ex) {
                throw new IllegalActionException(null, ex, MatrixToken.notSupportedMessage("add", this, leftArgument));
            }
        }
        if (typeInfo == 0) {
            MatrixToken result = this._addElement(leftArgument);
            return result;
        }
        typeInfo = TypeLattice.compare(leftArgument, this.getType());
        if (typeInfo == -1) {
            MatrixToken convertedArgument = (MatrixToken)this.getType().convert(leftArgument);
            try {
                Token result = convertedArgument._doAdd(this);
                return result;
            }
            catch (IllegalActionException ex) {
                throw new IllegalActionException(null, ex, MatrixToken.notSupportedMessage("addReverse", this, leftArgument));
            }
        }
        if (typeInfo == 0) {
            Token result = ((MatrixToken)leftArgument)._doAdd(this);
            return result;
        }
        if (typeInfo == 1) {
            Token result = leftArgument.add(this);
            return result;
        }
        Type lubType = (Type)TypeLattice.lattice().leastUpperBound(this.getType(), leftArgument.getType());
        if (!lubType.equals(this.getType()) && !(lub = lubType.convert(this)).getType().equals(this.getType())) {
            return lub.addReverse(leftArgument);
        }
        throw new IllegalActionException(MatrixToken.notSupportedIncomparableMessage("addReverse", this, leftArgument));
    }

    public static MatrixToken arrayToMatrix(Token[] tokens, int rows, int columns) throws IllegalActionException {
        Object[] typeTerms = new Object[tokens.length];
        Type baseType = BaseType.GENERAL;
        int i = 0;
        while (i < tokens.length) {
            if (!tokens[i].isNil()) {
                baseType = tokens[i].getType();
                break;
            }
            ++i;
        }
        i = 0;
        while (i < tokens.length) {
            typeTerms[i] = tokens[i].isNil() ? baseType : tokens[i].getType();
            ++i;
        }
        Type type = (Type)TypeLattice.lattice().leastUpperBound(typeTerms);
        return MatrixToken.arrayToMatrix(type, tokens, rows, columns);
    }

    public static MatrixToken arrayToMatrix(Type type, Token[] tokens, int rows, int columns) throws IllegalActionException {
        MatrixToken token;
        if (type.equals(BaseType.UNKNOWN)) {
            throw new IllegalActionException("Cannot resolve type for matrix construction.");
        }
        if (type.equals(BaseType.BOOLEAN)) {
            token = new BooleanMatrixToken(tokens, rows, columns);
        } else if (type.equals(BaseType.INT)) {
            token = new IntMatrixToken(tokens, rows, columns);
        } else if (type.equals(BaseType.LONG)) {
            token = new LongMatrixToken(tokens, rows, columns);
        } else if (type.equals(BaseType.DOUBLE)) {
            token = new DoubleMatrixToken(tokens, rows, columns);
        } else if (type.equals(BaseType.COMPLEX)) {
            token = new ComplexMatrixToken(tokens, rows, columns);
        } else if (type.equals(BaseType.UNSIZED_FIX) || type instanceof FixType) {
            token = new FixMatrixToken(tokens, rows, columns);
        } else {
            throw new IllegalActionException("Unrecognized type " + type + " for matrix creation.");
        }
        return token;
    }

    public static Type arrayToMatrixReturnType(Type type1, Type type2, Type type3) throws IllegalActionException {
        if (type1 instanceof ArrayType) {
            Type elementType = ((ArrayType)type1).getElementType();
            return MatrixType.getMatrixTypeForElementType(elementType);
        }
        return BaseType.UNKNOWN;
    }

    public boolean[][] booleanMatrix() throws IllegalActionException {
        throw new IllegalActionException(MatrixToken.notSupportedConversionMessage(this, "boolean matrix"));
    }

    public Complex[][] complexMatrix() throws IllegalActionException {
        throw new IllegalActionException(MatrixToken.notSupportedConversionMessage(this, "complex matrix"));
    }

    public static MatrixToken create(Token[] tokens, int rows, int columns) throws IllegalActionException {
        return MatrixToken.arrayToMatrix(tokens, rows, columns);
    }

    public static Token[] createSequence(Token start, Token increment, int length) throws IllegalActionException {
        Token[] result = new Token[length];
        Token value = start;
        if (length > 0) {
            result[0] = start;
            int i = 1;
            while (i < length) {
                result[i] = value = value.add(increment);
                ++i;
            }
        }
        return result;
    }

    public static Type createSequenceReturnType(Type type1, Type type2, Type type3) throws IllegalActionException {
        return new ArrayType(TypeLattice.leastUpperBound(type1, type2));
    }

    public static Token[] createTokenSequence(Token start, Token increment, int length) throws IllegalActionException {
        return MatrixToken.createSequence(start, increment, length);
    }

    public MatrixToken crop(int rowStart, int colStart, int rowSpan, int colSpan) throws IllegalActionException {
        throw new IllegalActionException("crop: Operation not supported on class " + this.getClass() + ".");
    }

    public static int determineSequenceLength(ScalarToken start, ScalarToken increment, ScalarToken end) throws IllegalActionException {
        ScalarToken zero = (ScalarToken)increment.zero();
        if (increment.isEqualTo(increment.zero()).booleanValue()) {
            throw new IllegalActionException("Sequence length cannot be determined because the increment is zero.");
        }
        if (increment.isLessThan(zero).booleanValue() && start.isLessThan(end).booleanValue()) {
            throw new IllegalActionException("Sequence length cannot be determined because the increment has the wrong sign.");
        }
        if (zero.isLessThan(increment).booleanValue() && end.isLessThan(start).booleanValue()) {
            throw new IllegalActionException("Sequence length cannot be determined because the increment has the wrong sign.");
        }
        ScalarToken diff = (ScalarToken)end.subtract(start).divide(increment);
        int count = diff instanceof LongToken ? (int)diff.longValue() + 1 : (diff instanceof DoubleToken ? (int)diff.doubleValue() + 1 : diff.intValue() + 1);
        if (count < 1) {
            throw new InternalErrorException("The determined count does not make sense.");
        }
        return count;
    }

    public final Token divide(Token rightArgument) throws IllegalActionException {
        Token lub;
        Type lubType;
        Type elementType = this.getElementType();
        int typeInfo = TypeLattice.compare(elementType, rightArgument);
        if (typeInfo == 0) {
            MatrixToken result = this._divideElement(rightArgument);
            return result;
        }
        if (typeInfo == 1) {
            Token convertedArgument = elementType.convert(rightArgument);
            try {
                MatrixToken result = this._divideElement(convertedArgument);
                return result;
            }
            catch (IllegalActionException ex) {
                throw new IllegalActionException(null, ex, MatrixToken.notSupportedMessage("divide", this, rightArgument));
            }
        }
        typeInfo = TypeLattice.compare(this.getType(), rightArgument);
        if (typeInfo == 0 && ((MatrixToken)rightArgument).getRowCount() == 1 && ((MatrixToken)rightArgument).getColumnCount() == 1) {
            return this._divideElement(rightArgument);
        }
        if (typeInfo == 1 && ((MatrixToken)rightArgument).getRowCount() == 1 && ((MatrixToken)rightArgument).getColumnCount() == 1) {
            Token convertedArgument = this.getType().convert(rightArgument);
            try {
                return this._divideElement(convertedArgument);
            }
            catch (IllegalActionException ex) {
                throw new IllegalActionException(null, ex, MatrixToken.notSupportedMessage("divide", this, rightArgument));
            }
        }
        if (typeInfo == 2 && !(lubType = (Type)TypeLattice.lattice().leastUpperBound(this.getType(), rightArgument.getType())).equals(this.getType()) && !(lub = lubType.convert(this)).getType().equals(this.getType())) {
            return lub.divide(rightArgument);
        }
        throw new IllegalActionException(MatrixToken.notSupportedMessage("divide", this, rightArgument));
    }

    public Token divideReverse(Token leftArgument) throws IllegalActionException {
        throw new IllegalActionException(MatrixToken.notSupportedMessage("divideReverse", this, leftArgument));
    }

    public double[][] doubleMatrix() throws IllegalActionException {
        throw new IllegalActionException(MatrixToken.notSupportedConversionMessage(this, "double matrix"));
    }

    public FixPoint[][] fixMatrix() throws IllegalActionException {
        throw new IllegalActionException(MatrixToken.notSupportedConversionMessage(this, "FixPoint matrix"));
    }

    public abstract int getColumnCount();

    public abstract Token getElementAsToken(int var1, int var2) throws ArrayIndexOutOfBoundsException;

    public abstract Type getElementType();

    public abstract int getRowCount();

    public int[][] intMatrix() throws IllegalActionException {
        throw new IllegalActionException(MatrixToken.notSupportedConversionMessage(this, "int matrix"));
    }

    public final BooleanToken isCloseTo(Token rightArgument, double epsilon) throws IllegalActionException {
        int typeInfo = TypeLattice.compare(this.getType(), rightArgument);
        if (typeInfo == 0) {
            return this._doIsCloseTo(rightArgument, epsilon);
        }
        if (typeInfo == 1) {
            MatrixToken convertedArgument = (MatrixToken)this.getType().convert(rightArgument);
            try {
                return this._doIsCloseTo(convertedArgument, epsilon);
            }
            catch (IllegalActionException ex) {
                throw new IllegalActionException(null, null, ex, MatrixToken.notSupportedMessage("isCloseTo", this, rightArgument));
            }
        }
        if (typeInfo == -1) {
            return rightArgument.isCloseTo(this, epsilon);
        }
        throw new IllegalActionException(MatrixToken.notSupportedIncomparableMessage("isCloseTo", this, rightArgument));
    }

    public final BooleanToken isEqualTo(Token rightArgument) throws IllegalActionException {
        int typeInfo = TypeLattice.compare(this.getType(), rightArgument);
        if (typeInfo == 0) {
            return this._doIsEqualTo(rightArgument);
        }
        if (typeInfo == 1) {
            MatrixToken convertedArgument = (MatrixToken)this.getType().convert(rightArgument);
            try {
                return this._doIsEqualTo(convertedArgument);
            }
            catch (IllegalActionException ex) {
                throw new IllegalActionException(null, ex, MatrixToken.notSupportedMessage("isEqualTo", this, rightArgument));
            }
        }
        if (typeInfo == -1) {
            return rightArgument.isEqualTo(this);
        }
        throw new IllegalActionException(MatrixToken.notSupportedIncomparableMessage("isEqualTo", this, rightArgument));
    }

    public MatrixToken join(MatrixToken[][] matrices) throws IllegalActionException {
        throw new IllegalActionException("join: Operation not supported on class " + this.getClass() + ".");
    }

    public long[][] longMatrix() throws IllegalActionException {
        throw new IllegalActionException(MatrixToken.notSupportedConversionMessage(this, "long matrix"));
    }

    public static ArrayToken matrixToArray(MatrixToken matrix) {
        return matrix.toArray();
    }

    public static Type matrixToArrayReturnType(Type type) {
        return MatrixToken.toArrayReturnType(type);
    }

    public final Token modulo(Token rightArgument) throws IllegalActionException {
        Token lub;
        Type lubType;
        Type elementType = this.getElementType();
        int typeInfo = TypeLattice.compare(elementType, rightArgument);
        if (typeInfo == 0) {
            MatrixToken result = this._moduloElement(rightArgument);
            return result;
        }
        if (typeInfo == 1) {
            Token convertedArgument = elementType.convert(rightArgument);
            try {
                MatrixToken result = this._moduloElement(convertedArgument);
                return result;
            }
            catch (IllegalActionException ex) {
                throw new IllegalActionException(null, ex, MatrixToken.notSupportedMessage("modulo", this, rightArgument));
            }
        }
        typeInfo = TypeLattice.compare(this.getType(), rightArgument);
        if (typeInfo == 0) {
            return this._moduloElement(rightArgument);
        }
        if (typeInfo == 1) {
            Token convertedArgument = this.getType().convert(rightArgument);
            try {
                return this._moduloElement(convertedArgument);
            }
            catch (IllegalActionException ex) {
                throw new IllegalActionException(null, ex, MatrixToken.notSupportedMessage("modulo", this, rightArgument));
            }
        }
        if (typeInfo == 2 && !(lubType = (Type)TypeLattice.lattice().leastUpperBound(this.getType(), rightArgument.getType())).equals(this.getType()) && !(lub = lubType.convert(this)).getType().equals(this.getType())) {
            return lub.modulo(rightArgument);
        }
        throw new IllegalActionException(MatrixToken.notSupportedMessage("modulo", this, rightArgument));
    }

    public final Token moduloReverse(Token leftArgument) throws IllegalActionException {
        throw new IllegalActionException(MatrixToken.notSupportedMessage("moduloReverse", this, leftArgument));
    }

    public final Token multiply(Token rightArgument) throws IllegalActionException {
        Token lub;
        Type elementType = this.getElementType();
        int typeInfo = TypeLattice.compare(elementType, rightArgument);
        if (typeInfo == 0) {
            MatrixToken result = this._multiplyElement(rightArgument);
            return result;
        }
        if (typeInfo == 1) {
            Token convertedArgument = elementType.convert(rightArgument);
            try {
                MatrixToken result = this._multiplyElement(convertedArgument);
                return result;
            }
            catch (IllegalActionException ex) {
                throw new IllegalActionException(null, ex, MatrixToken.notSupportedMessage("multiply", this, rightArgument));
            }
        }
        typeInfo = TypeLattice.compare(this.getType(), rightArgument);
        if (typeInfo == 0) {
            Token result = this._doMultiply(rightArgument);
            return result;
        }
        if (typeInfo == 1) {
            MatrixToken convertedArgument = (MatrixToken)this.getType().convert(rightArgument);
            try {
                Token result = this._doMultiply(convertedArgument);
                return result;
            }
            catch (IllegalActionException ex) {
                throw new IllegalActionException(null, ex, MatrixToken.notSupportedMessage("multiply", this, rightArgument));
            }
        }
        if (typeInfo == -1) {
            Token result = rightArgument.multiplyReverse(this);
            return result;
        }
        Type lubType = (Type)TypeLattice.lattice().leastUpperBound(this.getType(), rightArgument.getType());
        if (!lubType.equals(this.getType()) && !(lub = lubType.convert(this)).getType().equals(this.getType())) {
            return lub.multiply(rightArgument);
        }
        throw new IllegalActionException(MatrixToken.notSupportedIncomparableMessage("multiply", this, rightArgument));
    }

    public final Token multiplyReverse(Token leftArgument) throws IllegalActionException {
        Token lub;
        Type elementType = this.getElementType();
        int typeInfo = TypeLattice.compare(leftArgument, elementType);
        if (typeInfo == -1) {
            Token convertedArgument = elementType.convert(leftArgument);
            try {
                MatrixToken result = this._multiplyElement(convertedArgument);
                return result;
            }
            catch (IllegalActionException ex) {
                throw new IllegalActionException(null, ex, MatrixToken.notSupportedMessage("multiply", this, leftArgument));
            }
        }
        if (typeInfo == 0) {
            MatrixToken result = this._multiplyElement(leftArgument);
            return result;
        }
        typeInfo = TypeLattice.compare(leftArgument, this.getType());
        if (typeInfo == -1) {
            MatrixToken convertedArgument = (MatrixToken)this.getType().convert(leftArgument);
            try {
                Token result = convertedArgument._doMultiply(this);
                return result;
            }
            catch (IllegalActionException ex) {
                throw new IllegalActionException(null, ex, MatrixToken.notSupportedMessage("multiplyReverse", this, leftArgument));
            }
        }
        if (typeInfo == 0) {
            Token result = ((MatrixToken)leftArgument)._doMultiply(this);
            return result;
        }
        if (typeInfo == 1) {
            Token result = leftArgument.multiply(this);
            return result;
        }
        Type lubType = (Type)TypeLattice.lattice().leastUpperBound(this.getType(), leftArgument.getType());
        if (!lubType.equals(this.getType()) && !(lub = lubType.convert(this)).getType().equals(this.getType())) {
            return lub.multiplyReverse(leftArgument);
        }
        throw new IllegalActionException(MatrixToken.notSupportedIncomparableMessage("multiplyReverse", leftArgument, this));
    }

    public Token oneRight() throws IllegalActionException {
        throw new IllegalActionException("Right multiplicative identity not supported on " + this.getClass().getName() + " objects.");
    }

    public MatrixToken[][] split(int[] rows, int[] columns) throws IllegalActionException {
        throw new IllegalActionException("split: Operation not supported on class " + this.getClass() + ".");
    }

    public final Token subtract(Token rightArgument) throws IllegalActionException {
        Token lub;
        Type elementType = this.getElementType();
        int typeInfo = TypeLattice.compare(elementType, rightArgument);
        if (typeInfo == 0) {
            MatrixToken result = this._subtractElement(rightArgument);
            return result;
        }
        if (typeInfo == 1) {
            Token convertedArgument = elementType.convert(rightArgument);
            try {
                MatrixToken result = this._subtractElement(convertedArgument);
                return result;
            }
            catch (IllegalActionException ex) {
                throw new IllegalActionException(null, ex, MatrixToken.notSupportedMessage("subtract", this, rightArgument));
            }
        }
        typeInfo = TypeLattice.compare(this.getType(), rightArgument);
        if (typeInfo == 0) {
            Token result = this._doSubtract(rightArgument);
            return result;
        }
        if (typeInfo == 1) {
            MatrixToken convertedArgument = (MatrixToken)this.getType().convert(rightArgument);
            try {
                Token result = this._doSubtract(convertedArgument);
                return result;
            }
            catch (IllegalActionException ex) {
                throw new IllegalActionException(null, ex, MatrixToken.notSupportedMessage("subtract", this, rightArgument));
            }
        }
        if (typeInfo == -1) {
            Token result = rightArgument.subtractReverse(this);
            return result;
        }
        Type lubType = (Type)TypeLattice.lattice().leastUpperBound(this.getType(), rightArgument.getType());
        if (!lubType.equals(this.getType()) && !(lub = lubType.convert(this)).getType().equals(this.getType())) {
            return lub.subtract(rightArgument);
        }
        throw new IllegalActionException(MatrixToken.notSupportedIncomparableMessage("subtract", this, rightArgument));
    }

    public final Token subtractReverse(Token leftArgument) throws IllegalActionException {
        Token lub;
        Type elementType = this.getElementType();
        int typeInfo = TypeLattice.compare(leftArgument, elementType);
        if (typeInfo == -1) {
            Token convertedArgument = elementType.convert(leftArgument);
            try {
                MatrixToken result = this._subtractElementReverse(convertedArgument);
                return result;
            }
            catch (IllegalActionException ex) {
                throw new IllegalActionException(null, ex, MatrixToken.notSupportedMessage("subtract", this, leftArgument));
            }
        }
        if (typeInfo == 0) {
            MatrixToken result = this._subtractElementReverse(leftArgument);
            return result;
        }
        typeInfo = TypeLattice.compare(leftArgument, this.getType());
        if (typeInfo == -1) {
            MatrixToken convertedArgument = (MatrixToken)this.getType().convert(leftArgument);
            try {
                Token result = convertedArgument._doSubtract(this);
                return result;
            }
            catch (IllegalActionException ex) {
                throw new IllegalActionException(null, ex, MatrixToken.notSupportedMessage("subtractReverse", this, leftArgument));
            }
        }
        if (typeInfo == 0) {
            Token result = ((MatrixToken)leftArgument)._doSubtract(this);
            return result;
        }
        if (typeInfo == 1) {
            Token result = leftArgument.subtract(this);
            return result;
        }
        Type lubType = (Type)TypeLattice.lattice().leastUpperBound(this.getType(), leftArgument.getType());
        if (!lubType.equals(this.getType()) && !(lub = lubType.convert(this)).getType().equals(this.getType())) {
            return lub.subtractReverse(leftArgument);
        }
        throw new IllegalActionException(MatrixToken.notSupportedIncomparableMessage("subtractReverse", this, leftArgument));
    }

    public ArrayToken toArray() {
        ArrayToken result;
        int rowCount = this.getRowCount();
        int columnCount = this.getColumnCount();
        Token[] output = new Token[rowCount * columnCount];
        int i = 0;
        int n = 0;
        while (i < rowCount) {
            int j = 0;
            while (j < columnCount) {
                output[n++] = this.getElementAsToken(i, j);
                ++j;
            }
            ++i;
        }
        try {
            result = new ArrayToken(output);
        }
        catch (IllegalActionException illegalAction) {
            throw new InternalErrorException("MatrixToken.toArray: Cannot construct ArrayToken. " + illegalAction.getMessage());
        }
        return result;
    }

    public static Type toArrayReturnType(Type type) {
        if (type instanceof MatrixType) {
            Type elementType = ((MatrixType)type).getElementType();
            return new ArrayType(elementType);
        }
        return BaseType.UNKNOWN;
    }

    public String toString() {
        int rowCount = this.getRowCount();
        int columnCount = this.getColumnCount();
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        int i = 0;
        while (i < rowCount) {
            int j = 0;
            while (j < columnCount) {
                if (this._nils != null && this._nils.contains(i * columnCount + j)) {
                    sb.append("nil");
                } else {
                    sb.append(this.getElementAsToken(i, j).toString());
                }
                if (j < columnCount - 1) {
                    sb.append(", ");
                }
                ++j;
            }
            if (i < rowCount - 1) {
                sb.append("; ");
            }
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    protected MatrixToken _add(MatrixToken rightArgument) throws IllegalActionException {
        throw new IllegalActionException(MatrixToken.notSupportedMessage("add", this, rightArgument));
    }

    protected MatrixToken _addElement(Token rightArgument) throws IllegalActionException {
        throw new IllegalActionException(MatrixToken.notSupportedMessage("add", this, rightArgument));
    }

    protected MatrixToken _divideElement(Token rightArgument) throws IllegalActionException {
        throw new IllegalActionException(MatrixToken.notSupportedMessage("divide", this, rightArgument));
    }

    protected BooleanToken _isCloseTo(MatrixToken token, double distance) throws IllegalActionException {
        int rows = this.getRowCount();
        int columns = this.getColumnCount();
        if (token.getRowCount() != rows || token.getColumnCount() != columns) {
            return BooleanToken.FALSE;
        }
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                Token other;
                Token element = this.getElementAsToken(i, j);
                if (!element.isCloseTo(other = token.getElementAsToken(i, j), distance).booleanValue()) {
                    return BooleanToken.FALSE;
                }
                ++j;
            }
            ++i;
        }
        return BooleanToken.TRUE;
    }

    protected BooleanToken _isEqualTo(MatrixToken rightArgument) throws IllegalActionException {
        return BooleanToken.getInstance(this.equals(rightArgument));
    }

    protected void _elementIsNil(int element) {
        if (this._nils == null) {
            this._nils = new HashSet();
        }
        this._nils.add(element);
    }

    protected MatrixToken _moduloElement(Token rightArgument) throws IllegalActionException {
        throw new IllegalActionException(MatrixToken.notSupportedMessage("modulo", this, rightArgument));
    }

    protected MatrixToken _multiply(MatrixToken rightArgument) throws IllegalActionException {
        throw new IllegalActionException(MatrixToken.notSupportedMessage("multiply", this, rightArgument));
    }

    protected MatrixToken _multiplyElement(Token rightArgument) throws IllegalActionException {
        throw new IllegalActionException(MatrixToken.notSupportedMessage("multiply", this, rightArgument));
    }

    protected MatrixToken _subtract(MatrixToken rightArgument) throws IllegalActionException {
        throw new IllegalActionException(MatrixToken.notSupportedMessage("subtract", this, rightArgument));
    }

    protected MatrixToken _subtractElement(Token rightArgument) throws IllegalActionException {
        throw new IllegalActionException(MatrixToken.notSupportedMessage("subtract", this, rightArgument));
    }

    protected MatrixToken _subtractElementReverse(Token rightArgument) throws IllegalActionException {
        throw new IllegalActionException(MatrixToken.notSupportedMessage("subtract", this, rightArgument));
    }

    private Token _doAdd(Token rightArgument) throws IllegalActionException {
        MatrixToken convertedArgument = (MatrixToken)rightArgument;
        if (convertedArgument.getRowCount() != this.getRowCount() || convertedArgument.getColumnCount() != this.getColumnCount()) {
            if (this.getRowCount() == 1 && this.getColumnCount() == 1) {
                return convertedArgument._addElement(this.getElementAsToken(0, 0));
            }
            if (convertedArgument.getRowCount() == 1 && convertedArgument.getColumnCount() == 1) {
                return this._addElement(convertedArgument.getElementAsToken(0, 0));
            }
            throw new IllegalActionException(String.valueOf(Token.notSupportedMessage("add", this, rightArgument)) + " because the matrices have different dimensions.");
        }
        MatrixToken result = this._add(convertedArgument);
        return result;
    }

    private BooleanToken _doIsCloseTo(Token rightArgument, double epsilon) throws IllegalActionException {
        MatrixToken convertedArgument = (MatrixToken)rightArgument;
        if (convertedArgument.getRowCount() != this.getRowCount() || convertedArgument.getColumnCount() != this.getColumnCount()) {
            return BooleanToken.FALSE;
        }
        return this._isCloseTo(convertedArgument, epsilon);
    }

    private BooleanToken _doIsEqualTo(Token rightArgument) throws IllegalActionException {
        MatrixToken convertedArgument = (MatrixToken)rightArgument;
        if (convertedArgument.getRowCount() != this.getRowCount() || convertedArgument.getColumnCount() != this.getColumnCount()) {
            return BooleanToken.FALSE;
        }
        return this._isEqualTo(convertedArgument);
    }

    private Token _doMultiply(Token rightArgument) throws IllegalActionException {
        MatrixToken convertedArgument = (MatrixToken)rightArgument;
        if (convertedArgument.getRowCount() != this.getColumnCount()) {
            if (this.getRowCount() == 1 && this.getColumnCount() == 1) {
                return convertedArgument._multiplyElement(this.getElementAsToken(0, 0));
            }
            if (convertedArgument.getRowCount() == 1 && convertedArgument.getColumnCount() == 1) {
                return this._multiplyElement(convertedArgument.getElementAsToken(0, 0));
            }
            throw new IllegalActionException(String.valueOf(Token.notSupportedMessage("multiply", this, rightArgument)) + " because the matrices have incompatible dimensions.");
        }
        MatrixToken result = this._multiply(convertedArgument);
        return result;
    }

    private Token _doSubtract(Token rightArgument) throws IllegalActionException {
        MatrixToken convertedArgument = (MatrixToken)rightArgument;
        if (convertedArgument.getRowCount() != this.getRowCount() || convertedArgument.getColumnCount() != this.getColumnCount()) {
            if (this.getRowCount() == 1 && this.getColumnCount() == 1) {
                return convertedArgument._subtractElementReverse(this.getElementAsToken(0, 0));
            }
            if (convertedArgument.getRowCount() == 1 && convertedArgument.getColumnCount() == 1) {
                return this._subtractElement(convertedArgument.getElementAsToken(0, 0));
            }
            throw new IllegalActionException(String.valueOf(Token.notSupportedMessage("subtract", this, rightArgument)) + " because the matrices have different dimensions.");
        }
        MatrixToken result = this._subtract(convertedArgument);
        return result;
    }
}

