/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data;

import ptolemy.data.BooleanToken;
import ptolemy.data.ScalarToken;
import ptolemy.data.Token;
import ptolemy.data.expr.ASTPtRootNode;
import ptolemy.data.expr.ParseTreeEvaluator;
import ptolemy.data.expr.PtParser;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.FixType;
import ptolemy.data.type.Type;
import ptolemy.data.type.TypeLattice;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.math.FixPoint;
import ptolemy.math.FixPointQuantization;
import ptolemy.math.Overflow;
import ptolemy.math.Precision;
import ptolemy.math.Quantization;
import ptolemy.math.Rounding;

public class FixToken
extends ScalarToken {
    private FixPoint _value;

    public FixToken() {
        this._value = new FixPoint(0);
    }

    public FixToken(FixPoint value) {
        this._value = value;
    }

    public FixToken(double value, Precision precision) throws IllegalArgumentException {
        try {
            FixPointQuantization q = new FixPointQuantization(precision, Overflow.SATURATE, Rounding.NEAREST);
            this._value = new FixPoint(value, (Quantization)q);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public FixToken(double value, int numberOfBits, int integerBits) throws IllegalArgumentException {
        try {
            Precision precision = new Precision(numberOfBits, integerBits);
            FixPointQuantization q = new FixPointQuantization(precision, Overflow.SATURATE, Rounding.NEAREST);
            this._value = new FixPoint(value, (Quantization)q);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public FixToken(String init) throws IllegalActionException {
        PtParser parser = new PtParser();
        ASTPtRootNode tree = parser.generateParseTree(init);
        Token token = new ParseTreeEvaluator().evaluateParseTree(tree);
        if (!(token instanceof FixToken)) {
            throw new IllegalActionException("A FixToken cannot be created from the expression '" + init + "'");
        }
        this._value = ((FixToken)token).fixValue();
    }

    public static FixToken convert(Token token) throws IllegalActionException {
        if (token instanceof FixToken) {
            return (FixToken)token;
        }
        int compare = TypeLattice.compare((Type)BaseType.FIX, token);
        if (compare == -1 || compare == 2) {
            throw new IllegalActionException(FixToken.notSupportedIncomparableConversionMessage(token, "fix"));
        }
        throw new IllegalActionException(FixToken.notSupportedConversionMessage(token, "fix"));
    }

    public double convertToDouble() {
        return this._value.doubleValue();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        return ((FixToken)object).fixValue().equals(this._value);
    }

    public FixPoint fixValue() {
        return this._value;
    }

    public Type getType() {
        return new FixType(this._value.getPrecision());
    }

    public int hashCode() {
        return this._value.hashCode();
    }

    public Token one() {
        return new FixToken(1.0, this._value.getPrecision());
    }

    public void print() {
        this._value.printFix();
    }

    public final FixToken quantize(Quantization quant) {
        FixToken result = this._quantize(quant);
        if (this._unitCategoryExponents != null && !this._isUnitless()) {
            result._unitCategoryExponents = this._copyOfCategoryExponents();
        }
        return result;
    }

    public String toString() {
        String unitString = "";
        if (!this._isUnitless()) {
            unitString = " * " + this.unitsString();
        }
        Precision precision = this._value.getPrecision();
        return "fix(" + this._value.toString() + "," + precision.getNumberOfBits() + "," + precision.getIntegerBitLength() + ")" + unitString;
    }

    public Token zero() {
        return new FixToken(0.0, this._value.getPrecision());
    }

    protected ScalarToken _absolute() {
        FixToken result = new FixToken(this._value.abs());
        return result;
    }

    protected ScalarToken _add(ScalarToken rightArgument) {
        FixPoint result = this._value.add(((FixToken)rightArgument).fixValue());
        return new FixToken(result);
    }

    protected ScalarToken _bitwiseAnd(ScalarToken rightArgument) throws IllegalActionException {
        throw new IllegalActionException(FixToken.notSupportedMessage("bitwiseAnd", this, rightArgument));
    }

    protected ScalarToken _bitwiseNot() throws IllegalActionException {
        throw new IllegalActionException(FixToken.notSupportedMessage("bitwiseNot", this, this));
    }

    protected ScalarToken _bitwiseOr(ScalarToken rightArgument) throws IllegalActionException {
        throw new IllegalActionException(FixToken.notSupportedMessage("bitwiseOr", this, rightArgument));
    }

    protected ScalarToken _bitwiseXor(ScalarToken rightArgument) throws IllegalActionException {
        throw new IllegalActionException(FixToken.notSupportedMessage("bitwiseXor", this, rightArgument));
    }

    protected ScalarToken _divide(ScalarToken rightArgument) {
        FixPoint result = this._value.divide(((FixToken)rightArgument).fixValue());
        return new FixToken(result);
    }

    protected ScalarToken _divide(ScalarToken rightArgument, Quantization quant) {
        FixPoint result = this._value.divide(((FixToken)rightArgument).fixValue(), quant);
        return new FixToken(result);
    }

    protected BooleanToken _isCloseTo(ScalarToken rightArgument, double epsilon) {
        double left;
        double right = ((FixToken)rightArgument).convertToDouble();
        if (right > (left = this.convertToDouble()) + epsilon || right < left - epsilon) {
            return BooleanToken.FALSE;
        }
        return BooleanToken.TRUE;
    }

    protected BooleanToken _isLessThan(ScalarToken rightArgument) throws IllegalActionException {
        FixToken convertedArgument = (FixToken)rightArgument;
        return BooleanToken.getInstance(this._value.doubleValue() < convertedArgument.fixValue().doubleValue());
    }

    protected ScalarToken _modulo(ScalarToken rightArgument) throws IllegalActionException {
        throw new IllegalActionException(FixToken.notSupportedMessage("modulo", this, rightArgument));
    }

    protected ScalarToken _multiply(ScalarToken rightArgument) {
        FixPoint result = this._value.multiply(((FixToken)rightArgument).fixValue());
        return new FixToken(result);
    }

    protected FixToken _quantize(Quantization quant) {
        FixPoint result = this._value.quantize(quant);
        return new FixToken(result);
    }

    protected ScalarToken _subtract(ScalarToken rightArgument) {
        FixPoint result = this._value.subtract(((FixToken)rightArgument).fixValue());
        return new FixToken(result);
    }
}

