/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data;

import ptolemy.data.FixToken;
import ptolemy.data.MatrixToken;
import ptolemy.data.ScalarToken;
import ptolemy.data.Token;
import ptolemy.data.expr.ASTPtRootNode;
import ptolemy.data.expr.ParseTreeEvaluator;
import ptolemy.data.expr.PtParser;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.data.type.TypeLattice;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.math.FixPoint;
import ptolemy.math.Precision;
import ptolemy.math.Quantizer;

public class FixMatrixToken
extends MatrixToken {
    private FixPoint[][] _value = null;
    private Precision _precision = null;
    private int _rowCount = 0;
    private int _columnCount = 0;

    public FixMatrixToken() {
        this._rowCount = 1;
        this._columnCount = 1;
        this._precision = new Precision(32, 32);
        this._value = new FixPoint[1][1];
        this._value[0][0] = Quantizer.round(0.0, this._precision);
    }

    public FixMatrixToken(FixPoint[][] value) throws IllegalActionException {
        if (value == null) {
            throw new IllegalActionException("FixMatrixToken: The specified matrix is null.");
        }
        this._initialize(value, null);
    }

    public FixMatrixToken(String init) throws IllegalActionException {
        PtParser parser = new PtParser();
        ASTPtRootNode tree = parser.generateParseTree(init);
        Token token = new ParseTreeEvaluator().evaluateParseTree(tree);
        if (!(token instanceof FixMatrixToken)) {
            throw new IllegalActionException("A FixMatrixToken cannot be created from the expression '" + init + "'");
        }
        FixPoint[][] value = ((FixMatrixToken)token).fixMatrix();
        this._initialize(value, null);
    }

    public FixMatrixToken(FixPoint[][] value, Precision precision) throws IllegalActionException {
        if (value == null) {
            throw new IllegalActionException("FixMatrixToken: The specified matrix is null.");
        }
        this._initialize(value, precision);
    }

    public FixMatrixToken(Token[] tokens, int rows, int columns) throws IllegalActionException {
        if (tokens == null) {
            throw new IllegalActionException("FixMatrixToken: The specified array is null.");
        }
        if (tokens.length != rows * columns) {
            throw new IllegalActionException("FixMatrixToken: The specified array is not of the correct length");
        }
        this._rowCount = rows;
        this._columnCount = columns;
        this._value = new FixPoint[rows][columns];
        int i = 0;
        while (i < tokens.length) {
            Token token = tokens[i];
            if (token instanceof ScalarToken) {
                this._value[i / columns][i % columns] = ((ScalarToken)token).fixValue();
            } else if (token instanceof FixToken) {
                this._value[i / columns][i % columns] = ((FixToken)token).fixValue();
            } else {
                throw new IllegalActionException("FixMatrixToken: Element " + i + " in the array with value " + token + " is not a ScalarToken");
            }
            ++i;
        }
    }

    public static FixMatrixToken convert(Token token) throws IllegalActionException {
        if (token instanceof FixMatrixToken) {
            return (FixMatrixToken)token;
        }
        int compare = TypeLattice.compare((Type)BaseType.FIX_MATRIX, token);
        if (compare == -1 || compare == 2) {
            throw new IllegalActionException(FixMatrixToken.notSupportedIncomparableConversionMessage(token, "[fix]"));
        }
        throw new IllegalActionException(FixMatrixToken.notSupportedConversionMessage(token, "[fix]"));
    }

    public MatrixToken crop(int rowStart, int colStart, int rowSpan, int colSpan) throws IllegalActionException {
        FixPoint[][] value = this.fixMatrix();
        try {
            FixPoint[][] result = new FixPoint[rowSpan][colSpan];
            int i = 0;
            while (i < rowSpan) {
                System.arraycopy(value[rowStart + i], colStart, result[i], 0, colSpan);
                ++i;
            }
            return new FixMatrixToken(result);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalActionException("Matrix crop indices out of bounds (rowStart = " + rowStart + ", colStart = " + colStart + ", rowSpan = " + rowSpan + ", colSpan = " + colSpan + ").");
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        FixMatrixToken matrixArgument = (FixMatrixToken)object;
        if (this._rowCount != matrixArgument.getRowCount()) {
            return false;
        }
        if (this._columnCount != matrixArgument.getColumnCount()) {
            return false;
        }
        FixPoint[][] matrix = matrixArgument.fixMatrix();
        int i = 0;
        while (i < this._rowCount) {
            int j = 0;
            while (j < this._columnCount) {
                if (!this._value[i][j].equals(matrix[i][j])) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public FixPoint[][] fixMatrix() {
        FixPoint[][] matrix = new FixPoint[this._rowCount][this._columnCount];
        int i = 0;
        while (i < this._rowCount) {
            int j = 0;
            while (j < this._columnCount) {
                matrix[i][j] = this._value[i][j];
                ++j;
            }
            ++i;
        }
        return matrix;
    }

    public int getColumnCount() {
        return this._columnCount;
    }

    public Token getElementAsToken(int row, int column) throws ArrayIndexOutOfBoundsException {
        return new FixToken(this._value[row][column]);
    }

    public FixPoint getElementAt(int row, int column) {
        return this._value[row][column];
    }

    public Type getElementType() {
        return BaseType.UNSIZED_FIX;
    }

    public int getRowCount() {
        return this._rowCount;
    }

    public Type getType() {
        return BaseType.FIX_MATRIX;
    }

    public int hashCode() {
        double code = 0.0;
        int i = 0;
        while (i < this._rowCount) {
            int j = 0;
            while (j < this._columnCount) {
                code += this._value[i][j].doubleValue();
                ++j;
            }
            ++i;
        }
        return (int)code;
    }

    public MatrixToken join(MatrixToken[][] matrices) throws IllegalActionException {
        if (matrices == null || matrices.length == 0 || matrices[0].length == 0) {
            throw new IllegalActionException("matrixJoin: No input matrices.");
        }
        int rows = 0;
        int columns = 0;
        int i = 0;
        while (i < matrices.length) {
            rows += matrices[i][0].getRowCount();
            ++i;
        }
        int j = 0;
        while (j < matrices[0].length) {
            columns += matrices[0][j].getColumnCount();
            ++j;
        }
        FixPoint[][] tiled = new FixPoint[rows][columns];
        int row = 0;
        int i2 = 0;
        while (i2 < matrices.length) {
            int column = 0;
            int j2 = 0;
            while (j2 < matrices[i2].length) {
                int columnCount;
                if (!(matrices[i2][j2] instanceof FixMatrixToken)) {
                    throw new IllegalActionException("matrixJoin: matrices not all of the same type.");
                }
                int rowCount = matrices[i2][j2].getRowCount();
                if (row + rowCount > rows) {
                    rowCount = rows - row;
                }
                if (column + (columnCount = matrices[i2][j2].getColumnCount()) > columns) {
                    columnCount = columns - column;
                }
                int ii = 0;
                while (ii < rowCount) {
                    System.arraycopy(matrices[i2][j2].fixMatrix()[ii], 0, tiled[row + ii], column, columnCount);
                    ++ii;
                }
                column += matrices[0][j2].getColumnCount();
                ++j2;
            }
            row += matrices[i2][0].getRowCount();
            ++i2;
        }
        return new FixMatrixToken(tiled);
    }

    public MatrixToken[][] split(int[] rows, int[] columns) {
        MatrixToken[][] result = new MatrixToken[rows.length][columns.length];
        FixPoint[][] source = this.fixMatrix();
        int row = 0;
        int i = 0;
        while (i < rows.length) {
            int column = 0;
            int j = 0;
            while (j < columns.length) {
                int columnspan;
                FixPoint[][] contents = new FixPoint[rows[i]][columns[j]];
                int rowspan = rows[i];
                if (row + rowspan > source.length) {
                    rowspan = source.length - row;
                }
                if (column + (columnspan = columns[j]) > source[0].length) {
                    columnspan = source[0].length - column;
                }
                if (columnspan > 0 && rowspan > 0) {
                    int ii = 0;
                    while (ii < rowspan) {
                        System.arraycopy(source[row + ii], column, contents[ii], 0, columnspan);
                        ++ii;
                    }
                }
                column += columns[j];
                try {
                    result[i][j] = new FixMatrixToken(contents, this.getElementAt(0, 0).getPrecision());
                }
                catch (IllegalActionException e) {
                    throw new InternalErrorException(e);
                }
                ++j;
            }
            row += rows[i];
            ++i;
        }
        return result;
    }

    public Token one() {
        FixPoint[][] result = new FixPoint[this._rowCount][this._rowCount];
        int i = 0;
        while (i < this._rowCount) {
            int j = 0;
            while (j < this._rowCount) {
                result[i][j] = Quantizer.round(0.0, this._precision);
                ++j;
            }
            result[i][i] = Quantizer.round(1.0, this._precision);
            ++i;
        }
        try {
            return new FixMatrixToken(result);
        }
        catch (IllegalActionException illegalActionException) {
            throw new InternalErrorException("Unequal precisions!");
        }
    }

    public Token oneRight() {
        FixPoint[][] result = new FixPoint[this._columnCount][this._columnCount];
        int i = 0;
        while (i < this._columnCount) {
            int j = 0;
            while (j < this._columnCount) {
                result[i][j] = Quantizer.round(0.0, this._precision);
                ++j;
            }
            result[i][i] = Quantizer.round(0.0, this._precision);
            ++i;
        }
        try {
            return new FixMatrixToken(result);
        }
        catch (IllegalActionException illegalActionException) {
            throw new InternalErrorException("Unequal precisions!");
        }
    }

    public Token zero() {
        FixPoint[][] result = new FixPoint[this._rowCount][this._columnCount];
        FixPoint zero = Quantizer.round(0.0, this._precision);
        int i = 0;
        while (i < this._rowCount) {
            int j = 0;
            while (j < this._columnCount) {
                result[i][j] = zero;
                ++j;
            }
            ++i;
        }
        try {
            return new FixMatrixToken(result);
        }
        catch (IllegalActionException illegalActionException) {
            throw new InternalErrorException("Unequal precisions!");
        }
    }

    protected MatrixToken _add(MatrixToken rightArgument) throws IllegalActionException {
        FixMatrixToken convertedArgument = (FixMatrixToken)rightArgument;
        FixPoint[][] result = convertedArgument.fixMatrix();
        int i = 0;
        while (i < this._rowCount) {
            int j = 0;
            while (j < this._columnCount) {
                result[i][j] = result[i][j].add(this._value[i][j]);
                ++j;
            }
            ++i;
        }
        return new FixMatrixToken(result);
    }

    protected MatrixToken _addElement(Token rightArgument) throws IllegalActionException {
        FixPoint scalar;
        if (rightArgument instanceof FixMatrixToken) {
            if (((FixMatrixToken)rightArgument).getRowCount() != 1 || ((FixMatrixToken)rightArgument).getColumnCount() != 1) {
                return super._moduloElement(rightArgument);
            }
            scalar = ((FixMatrixToken)rightArgument).getElementAt(0, 0);
        } else {
            scalar = ((FixToken)rightArgument).fixValue();
        }
        FixPoint[][] result = this.fixMatrix();
        int i = 0;
        while (i < this._rowCount) {
            int j = 0;
            while (j < this._columnCount) {
                result[i][j] = result[i][j].add(scalar);
                ++j;
            }
            ++i;
        }
        return new FixMatrixToken(result);
    }

    protected MatrixToken _multiply(MatrixToken rightArgument) throws IllegalActionException {
        FixMatrixToken convertedArgument = (FixMatrixToken)rightArgument;
        if (this._columnCount != convertedArgument._rowCount) {
            throw new IllegalActionException("Matrix dimensions are not compatible. Cannot multiply.");
        }
        FixPoint[][] result = new FixPoint[this._rowCount][convertedArgument._columnCount];
        int i = 0;
        while (i < this._rowCount) {
            int j = 0;
            while (j < convertedArgument._columnCount) {
                FixPoint sum = this._value[i][0].multiply(convertedArgument._value[0][j]);
                int k = 1;
                while (k < this._columnCount) {
                    sum = sum.add(this._value[i][k].multiply(convertedArgument._value[k][j]));
                    ++k;
                }
                result[i][j] = sum;
                ++j;
            }
            ++i;
        }
        return new FixMatrixToken(result);
    }

    protected MatrixToken _multiplyElement(Token rightArgument) throws IllegalActionException {
        FixPoint scalar;
        if (rightArgument instanceof FixMatrixToken) {
            if (((FixMatrixToken)rightArgument).getRowCount() != 1 || ((FixMatrixToken)rightArgument).getColumnCount() != 1) {
                return super._moduloElement(rightArgument);
            }
            scalar = ((FixMatrixToken)rightArgument).getElementAt(0, 0);
        } else {
            scalar = ((FixToken)rightArgument).fixValue();
        }
        FixPoint[][] result = this.fixMatrix();
        int i = 0;
        while (i < this._rowCount) {
            int j = 0;
            while (j < this._columnCount) {
                result[i][j] = result[i][j].multiply(scalar);
                ++j;
            }
            ++i;
        }
        return new FixMatrixToken(result);
    }

    protected MatrixToken _subtract(MatrixToken rightArgument) throws IllegalActionException {
        FixMatrixToken convertedArgument = (FixMatrixToken)rightArgument;
        FixPoint[][] result = convertedArgument.fixMatrix();
        int i = 0;
        while (i < this._rowCount) {
            int j = 0;
            while (j < this._columnCount) {
                result[i][j] = result[i][j].subtract(this._value[i][j]);
                ++j;
            }
            ++i;
        }
        return new FixMatrixToken(result);
    }

    protected MatrixToken _subtractElement(Token rightArgument) throws IllegalActionException {
        FixPoint scalar;
        if (rightArgument instanceof FixMatrixToken) {
            if (((FixMatrixToken)rightArgument).getRowCount() != 1 || ((FixMatrixToken)rightArgument).getColumnCount() != 1) {
                return super._moduloElement(rightArgument);
            }
            scalar = ((FixMatrixToken)rightArgument).getElementAt(0, 0);
        } else {
            scalar = ((FixToken)rightArgument).fixValue();
        }
        FixPoint[][] result = this.fixMatrix();
        int i = 0;
        while (i < this._rowCount) {
            int j = 0;
            while (j < this._columnCount) {
                result[i][j] = result[i][j].subtract(scalar);
                ++j;
            }
            ++i;
        }
        return new FixMatrixToken(result);
    }

    protected MatrixToken _subtractElementReverse(Token rightArgument) throws IllegalActionException {
        FixPoint scalar;
        if (rightArgument instanceof FixMatrixToken) {
            if (((FixMatrixToken)rightArgument).getRowCount() != 1 || ((FixMatrixToken)rightArgument).getColumnCount() != 1) {
                return super._moduloElement(rightArgument);
            }
            scalar = ((FixMatrixToken)rightArgument).getElementAt(0, 0);
        } else {
            scalar = ((FixToken)rightArgument).fixValue();
        }
        FixPoint[][] result = this.fixMatrix();
        int i = 0;
        while (i < this._rowCount) {
            int j = 0;
            while (j < this._columnCount) {
                result[i][j] = scalar.subtract(result[i][j]);
                ++j;
            }
            ++i;
        }
        return new FixMatrixToken(result);
    }

    private void _initialize(FixPoint[][] value, Precision precision) throws IllegalActionException {
        this._rowCount = value.length;
        this._columnCount = value[0].length;
        this._value = new FixPoint[this._rowCount][this._columnCount];
        int i = 0;
        while (i < this._rowCount) {
            int j = 0;
            while (j < this._columnCount) {
                this._value[i][j] = value[i][j];
                if (this._value[i][j] == null) {
                    this._value[i][j] = Quantizer.round(0.0, precision);
                }
                if (precision == null) {
                    precision = this._value[i][j].getPrecision();
                }
                if (this._precision != null && !this._precision.equals(precision)) {
                    throw new IllegalActionException("Attempt to create a FixMatrixToken with unequal precisions: " + this._precision + " and " + precision);
                }
                this._precision = precision;
                ++j;
            }
            ++i;
        }
    }
}

