/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.util;

import java.math.BigInteger;
import ptolemy.actor.Director;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.math.ExtendedMath;

public class Time
implements Comparable {
    private static int _NEGATIVE_INFINITY = 0;
    private static int _POSITIVE_INFINITY = 1;
    public static final Time NEGATIVE_INFINITY = new Time(_NEGATIVE_INFINITY);
    public static final Time POSITIVE_INFINITY = new Time(_POSITIVE_INFINITY);
    private Director _director;
    private boolean _isPositiveInfinite = false;
    private boolean _isNegativeInfinite = false;
    private BigInteger _timeValue = null;

    public Time(Director director) {
        this._director = director;
        this._timeValue = BigInteger.ZERO;
    }

    public Time(Director director, double timeValue) throws IllegalActionException {
        this._director = director;
        if (Double.isNaN(timeValue)) {
            throw new ArithmeticException("Time value can not be NaN.");
        }
        if (Double.isInfinite(timeValue)) {
            this._timeValue = null;
            if (timeValue < 0.0) {
                this._isNegativeInfinite = true;
            } else {
                this._isPositiveInfinite = true;
            }
        } else {
            this._timeValue = this._doubleToMultiple(timeValue);
        }
    }

    public Time(Director director, long timeValue) {
        this._director = director;
        this._timeValue = new BigInteger(Long.toString(timeValue));
    }

    private Time(Director director, BigInteger timeValue) {
        this._director = director;
        this._timeValue = timeValue;
    }

    private Time(int value) {
        if (value == _POSITIVE_INFINITY) {
            this._timeValue = null;
            this._isPositiveInfinite = true;
        } else if (value == _NEGATIVE_INFINITY) {
            this._timeValue = null;
            this._isNegativeInfinite = true;
        }
    }

    public Time add(double timeValue) {
        BigInteger quantizedValue;
        if (Double.isNaN(timeValue)) {
            throw new ArithmeticException("Time: Time value can not be NaN.");
        }
        if (Double.isInfinite(timeValue)) {
            if (timeValue < 0.0) {
                if (this._isPositiveInfinite) {
                    throw new ArithmeticException("Time: Adding a positive infinity to a negative infinity results in an invalid time.");
                }
                return NEGATIVE_INFINITY;
            }
            if (this._isNegativeInfinite) {
                throw new ArithmeticException("Time: Adding a negative infinity to a positive infinity results in an invalid time.");
            }
            return POSITIVE_INFINITY;
        }
        if (this.isInfinite()) {
            return this;
        }
        try {
            quantizedValue = this._doubleToMultiple(timeValue);
        }
        catch (IllegalActionException illegalActionException) {
            throw new ArithmeticException("Cannot guarantee the specified time resolution " + this._director.getTimeResolution() + " for the time value " + timeValue + ".\nTry " + "choosing a greater time resolution " + "by configuring the timeResolution parameter of the " + "director.\n" + "Check the stack trace to see which actor or " + "parameter caused this exception.");
        }
        return new Time(this._director, this._timeValue.add(quantizedValue));
    }

    public Time add(Time time) {
        if (time._isNegativeInfinite) {
            if (this._isPositiveInfinite) {
                throw new ArithmeticException("Time: Adding a positive infinity to a negative infinity yields an invalid time.");
            }
            return NEGATIVE_INFINITY;
        }
        if (time._isPositiveInfinite) {
            if (this._isNegativeInfinite) {
                throw new ArithmeticException("Adding a negative infinity to a positive infinity yields an invalid time.");
            }
            return POSITIVE_INFINITY;
        }
        if (this.isInfinite()) {
            return this;
        }
        try {
            double resolution = this._director.getTimeResolution();
            if (resolution != time._director.getTimeResolution()) {
                double thisValue = this.getDoubleValue();
                double thatValue = time.getDoubleValue();
                return new Time(this._director, thisValue + thatValue);
            }
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException(e);
        }
        return new Time(this._director, this._timeValue.add(time._timeValue));
    }

    public int compareTo(Object time) {
        double thatValue;
        Time castTime = (Time)time;
        if (castTime.isInfinite() || this.isInfinite()) {
            if (castTime._isNegativeInfinite) {
                if (this._isNegativeInfinite) {
                    return 0;
                }
                return 1;
            }
            if (castTime._isPositiveInfinite) {
                if (this._isPositiveInfinite) {
                    return 0;
                }
                return -1;
            }
            if (this._isNegativeInfinite) {
                return -1;
            }
            return 1;
        }
        double resolution = this._director.getTimeResolution();
        if (resolution == castTime._director.getTimeResolution()) {
            return this._timeValue.compareTo(castTime._timeValue);
        }
        double thisValue = this.getDoubleValue();
        if (thisValue < (thatValue = castTime.getDoubleValue())) {
            return -1;
        }
        if (thisValue > thatValue) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object time) {
        return this.compareTo(time) == 0;
    }

    public double getDoubleValue() {
        if (this._isPositiveInfinite) {
            return Double.POSITIVE_INFINITY;
        }
        if (this._isNegativeInfinite) {
            return Double.NEGATIVE_INFINITY;
        }
        return this._timeValue.doubleValue() * this._director.getTimeResolution();
    }

    public long getLongValue() {
        if (this._isPositiveInfinite) {
            return Long.MAX_VALUE;
        }
        if (this._isNegativeInfinite) {
            return Long.MIN_VALUE;
        }
        return this._timeValue.longValue();
    }

    public int hashCode() {
        if (this._isNegativeInfinite) {
            return Integer.MIN_VALUE;
        }
        if (this._isPositiveInfinite) {
            return Integer.MAX_VALUE;
        }
        return this._timeValue.hashCode();
    }

    public final boolean isInfinite() {
        return this._isNegativeInfinite || this._isPositiveInfinite;
    }

    public final boolean isNegativeInfinite() {
        return this._isNegativeInfinite;
    }

    public final boolean isPositiveInfinite() {
        return this._isPositiveInfinite;
    }

    public double maximumAccurateValueAsDouble() {
        int minimumNumberOfBits = (int)Math.floor(-1.0 * ExtendedMath.log2(this._director.getTimeResolution())) + 1;
        int maximumGain = 52 - minimumNumberOfBits;
        return ExtendedMath.DOUBLE_PRECISION_SIGNIFICAND_ONLY * Math.pow(2.0, maximumGain);
    }

    public Time subtract(double timeValue) {
        return this.add(-1.0 * timeValue);
    }

    public Time subtract(Time time) {
        if (time.isNegativeInfinite()) {
            return this.add(POSITIVE_INFINITY);
        }
        if (time.isPositiveInfinite()) {
            return this.add(NEGATIVE_INFINITY);
        }
        return this.add(new Time(time._director, time._timeValue.negate()));
    }

    public String toString() {
        if (this._isPositiveInfinite) {
            return "Infinity";
        }
        if (this._isNegativeInfinite) {
            return "-Infinity";
        }
        return "" + this.getDoubleValue();
    }

    private BigInteger _doubleToMultiple(double value) throws IllegalActionException {
        double precision = this._director.getTimeResolution();
        long multiple = Math.round(value / precision);
        if (Math.abs((double)multiple * precision - value) > precision) {
            throw new IllegalActionException("The given time value " + value + " is too large to be converted precisely to an " + "instance of Time with the specified time resolution of " + precision + ". The maximum value that can always be precisely converted is " + this.maximumAccurateValueAsDouble() + ". A number close to your value that can be converted is " + (double)multiple * precision);
        }
        return BigInteger.valueOf(multiple);
    }
}

