/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import ptolemy.data.expr.ASTPtRootNode;
import ptolemy.data.expr.ParseTreeFreeVariableCollector;
import ptolemy.data.expr.PtParser;
import ptolemy.data.expr.Variable;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.IllegalActionException;

public class FreeVariableModelAnalysis {
    private HashMap _entityToFreeVariableNameSet = new HashMap();

    public FreeVariableModelAnalysis(Entity model) throws IllegalActionException {
        this._freeVariables(model);
    }

    public Set getFreeVariables(Entity entity) {
        Set freeVariables = (Set)this._entityToFreeVariableNameSet.get(entity);
        if (freeVariables == null) {
            throw new RuntimeException("Entity " + entity.getFullName() + " has not been analyzed.");
        }
        return Collections.unmodifiableSet(freeVariables);
    }

    private Set _freeVariables(Entity model) throws IllegalActionException {
        HashSet set = new HashSet();
        if (model instanceof CompositeEntity) {
            for (Entity entity : ((CompositeEntity)model).entityList()) {
                set.addAll(this._freeVariables(entity));
            }
        }
        Set<String> variableNames = new HashSet();
        for (Variable variable : model.attributeList(Variable.class)) {
            variableNames.add(variable.getName());
        }
        variableNames = Collections.unmodifiableSet(variableNames);
        set.removeAll(variableNames);
        PtParser parser = new PtParser();
        ParseTreeFreeVariableCollector collector = new ParseTreeFreeVariableCollector();
        for (Variable variable : model.attributeList(Variable.class)) {
            String expression = variable.getExpression();
            ASTPtRootNode root = variable.isStringMode() ? parser.generateStringParseTree(expression) : parser.generateParseTree(expression);
            HashSet freeIdentifiers = new HashSet(collector.collectFreeVariables(root));
            HashSet tempSet = new HashSet(variableNames);
            tempSet.remove(variable.getName());
            freeIdentifiers.removeAll(tempSet);
            set.addAll(freeIdentifiers);
        }
        this._entityToFreeVariableNameSet.put(model, set);
        return set;
    }
}

