/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.util;

import ptolemy.actor.util.ConstVariableModelAnalysis;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Variable;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.MonotonicFunction;
import ptolemy.data.type.Type;
import ptolemy.data.type.Typeable;
import ptolemy.graph.InequalityTerm;
import ptolemy.kernel.util.IllegalActionException;

public class ActorTypeUtil {
    public static InequalityTerm arrayOf(Typeable typeable, Variable length) throws IllegalActionException {
        return new TypeableSizedArrayVariableTypeTerm(typeable, length);
    }

    private static class TypeableSizedArrayVariableTypeTerm
    extends MonotonicFunction {
        private Typeable _typeable;
        private ArrayType _arrayType;
        private Variable _lengthVariable;

        public TypeableSizedArrayVariableTypeTerm(Typeable typeable, Variable lengthVariable) {
            this._typeable = typeable;
            this._lengthVariable = lengthVariable;
        }

        public Object getValue() throws IllegalActionException {
            ConstVariableModelAnalysis analysis = ConstVariableModelAnalysis.getAnalysis(this._lengthVariable);
            if (analysis.isConstant(this._lengthVariable)) {
                Token lengthToken = analysis.getConstantValue(this._lengthVariable);
                int length = ((IntToken)lengthToken).intValue();
                return this._getArrayTypeRaw(length);
            }
            return this._getArrayTypeRaw();
        }

        public InequalityTerm[] getVariables() {
            InequalityTerm[] array = new InequalityTerm[]{this._typeable.getTypeTerm()};
            return array;
        }

        private ArrayType _getArrayTypeRaw() throws IllegalActionException {
            Type type = this._typeable.getType();
            if (this._arrayType == null || !this._arrayType.getElementType().equals(type)) {
                this._arrayType = new ArrayType(type);
            }
            return this._arrayType;
        }

        private ArrayType _getArrayTypeRaw(int length) throws IllegalActionException {
            Type type = this._typeable.getType();
            if (this._arrayType == null || !this._arrayType.getElementType().equals(type)) {
                this._arrayType = new ArrayType(type, length);
            }
            return this._arrayType;
        }
    }
}

