/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.sched;

import java.util.Iterator;
import ptolemy.actor.Actor;
import ptolemy.actor.Director;
import ptolemy.actor.FiringEvent;
import ptolemy.actor.sched.Firing;
import ptolemy.actor.sched.Schedule;
import ptolemy.actor.sched.Scheduler;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.DebugListener;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.Workspace;

public class StaticSchedulingDirector
extends Director {
    protected boolean _postfireReturns;
    private Scheduler _scheduler;

    public StaticSchedulingDirector() {
    }

    public StaticSchedulingDirector(Workspace workspace) {
        super(workspace);
    }

    public StaticSchedulingDirector(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    public synchronized void addDebugListener(DebugListener listener) {
        super.addDebugListener(listener);
        Scheduler scheduler = this.getScheduler();
        if (scheduler != null) {
            scheduler.addDebugListener(listener);
        }
    }

    public void fire() throws IllegalActionException {
        Scheduler scheduler = this.getScheduler();
        if (scheduler == null) {
            throw new IllegalActionException("Attempted to fire system with no scheduler");
        }
        Schedule schedule = scheduler.getSchedule();
        Iterator firings = schedule.firingIterator();
        while (firings.hasNext() && !this._stopRequested) {
            int returnValue;
            Firing firing = (Firing)firings.next();
            Actor actor = firing.getActor();
            int iterationCount = firing.getIterationCount();
            if (this._debugging) {
                this._debug(new FiringEvent(this, actor, FiringEvent.BEFORE_ITERATE, iterationCount));
            }
            if ((returnValue = actor.iterate(iterationCount)) == 2) {
                this._postfireReturns = false;
            } else if (returnValue == 1) {
                throw new IllegalActionException((Nameable)this, actor, "Actor is not ready to fire.");
            }
            if (!this._debugging) continue;
            this._debug(new FiringEvent(this, actor, FiringEvent.AFTER_ITERATE, iterationCount));
        }
    }

    public Scheduler getScheduler() {
        try {
            this.workspace().getReadAccess();
            Scheduler scheduler = this._scheduler;
            return scheduler;
        }
        finally {
            this.workspace().doneReading();
        }
    }

    public void invalidateSchedule() {
        this._debug("Invalidating schedule.");
        if (this._scheduler != null) {
            this._scheduler.setValid(false);
        }
    }

    public boolean isScheduleValid() throws IllegalActionException {
        if (this._scheduler == null) {
            throw new IllegalActionException((Nameable)this, "has no scheduler.");
        }
        return this._scheduler.isValid();
    }

    public boolean postfire() throws IllegalActionException {
        return super.postfire() && this._postfireReturns;
    }

    public boolean prefire() throws IllegalActionException {
        this._postfireReturns = true;
        return super.prefire();
    }

    public synchronized void removeDebugListener(DebugListener listener) {
        super.removeDebugListener(listener);
        Scheduler scheduler = this.getScheduler();
        if (scheduler != null) {
            scheduler.removeDebugListener(listener);
        }
    }

    public void setScheduler(Scheduler scheduler) throws IllegalActionException, NameDuplicationException {
        if (scheduler != null) {
            scheduler.setContainer(this);
        } else {
            this._setScheduler(null);
        }
    }

    protected void _setScheduler(Scheduler scheduler) throws IllegalActionException, NameDuplicationException {
        if (this._scheduler != scheduler) {
            this._scheduler = scheduler;
            this.invalidateSchedule();
        }
    }
}

