/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.sched;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import ptolemy.actor.Actor;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.IOPort;
import ptolemy.actor.Receiver;
import ptolemy.actor.sched.Firing;
import ptolemy.actor.sched.FixedPointReceiver;
import ptolemy.actor.sched.FixedPointScheduler;
import ptolemy.actor.sched.Schedule;
import ptolemy.actor.sched.StaticSchedulingDirector;
import ptolemy.data.BooleanToken;
import ptolemy.data.IntToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.Workspace;

public class FixedPointDirector
extends StaticSchedulingDirector {
    public Parameter iterations;
    public Parameter synchronizeToRealTime;
    protected int _index;
    protected List _receivers = new LinkedList();
    private Set _actorsAllowedToFire;
    private Set _actorsFinishedFiring;
    private Set _actorsFired = new HashSet();
    private Set _cachedAllInputsKnown;
    private boolean _cachedFunctionalProperty;
    private int _currentNumberOfKnownReceivers;
    private int _currentIteration;
    private transient long _functionalPropertyVersion = -1L;
    private int _lastNumberOfKnownReceivers;
    private long _realStartTime = 0L;

    public FixedPointDirector() throws IllegalActionException, NameDuplicationException {
        this._init();
    }

    public FixedPointDirector(Workspace workspace) throws IllegalActionException, NameDuplicationException {
        super(workspace);
        this._init();
    }

    public FixedPointDirector(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this._init();
    }

    public void fire() throws IllegalActionException {
        if (this._debugging) {
            this._debug("FixedPointDirector: invoking fire().");
        }
        Schedule schedule = this.getScheduler().getSchedule();
        int iterationCount = 0;
        do {
            Iterator firingIterator = schedule.firingIterator();
            while (firingIterator.hasNext() && !this._stopRequested) {
                Actor actor = ((Firing)firingIterator.next()).getActor();
                if (!this._actorsFinishedExecution.contains(actor)) {
                    if (!this._isReadyToFire(actor)) continue;
                    this._fireActor(actor);
                    this._actorsFired.add(actor);
                    continue;
                }
                if (this._debugging) {
                    this._debug("FixedPointDirector: no longer enabled (return false in postfire): " + actor.getFullName());
                }
                this._sendClearToAllUnknownOutputsOf(actor);
            }
            ++iterationCount;
        } while (!this._hasIterationConverged() && !this._stopRequested);
        if (this._debugging) {
            this._debug(String.valueOf(this.getFullName()) + ": Fixed point found after " + iterationCount + " iterations.");
        }
    }

    public int getIndex() {
        return this._index;
    }

    public void initialize() throws IllegalActionException {
        this._currentIteration = 0;
        this._index = 0;
        this._actorsAllowedToFire = new HashSet();
        this._actorsFinishedFiring = new HashSet();
        this._cachedAllInputsKnown = new HashSet();
        this._cachedFunctionalProperty = true;
        this._functionalPropertyVersion = -1L;
        super.initialize();
        this._realStartTime = System.currentTimeMillis();
    }

    public boolean isFireFunctional() {
        if (this.workspace().getVersion() == this._functionalPropertyVersion) {
            return this._cachedFunctionalProperty;
        }
        boolean result = true;
        boolean containsActors = false;
        CompositeActor container = (CompositeActor)this.getContainer();
        if (container == null) {
            return false;
        }
        Iterator actors = container.deepEntityList().iterator();
        while (result && actors.hasNext() && !this._stopRequested) {
            Actor actor = (Actor)actors.next();
            result = actor.isFireFunctional() && result;
            containsActors = true;
        }
        if (!containsActors) {
            result = false;
        }
        this._cachedFunctionalProperty = result;
        this._functionalPropertyVersion = this.workspace().getVersion();
        return result;
    }

    public boolean isStrict() {
        return false;
    }

    public Receiver newReceiver() {
        FixedPointReceiver receiver = new FixedPointReceiver(this);
        this._receivers.add(receiver);
        return receiver;
    }

    public boolean postfire() throws IllegalActionException {
        if (this._debugging) {
            this._debug("FixedPointDirector: Called postfire().");
        }
        this._synchronizeToRealTime();
        boolean needMoreIterations = true;
        int numberOfActors = this.getScheduler().getSchedule().size();
        if (numberOfActors > 0 && this._actorsFired.size() == 0) {
            needMoreIterations = false;
        }
        Iterator actors = this._actorsFired.iterator();
        while (actors.hasNext() && !this._stopRequested) {
            Actor actor = (Actor)actors.next();
            if (!this._areAllInputsKnown(actor)) {
                throw new IllegalActionException((Nameable)actor, "Unknown inputs remain. Possible causality loop.");
            }
            if (this._actorsFinishedExecution.contains(actor) || this._postfireActor(actor)) continue;
            this._actorsFinishedExecution.add(actor);
        }
        if (this._debugging) {
            this._debug(String.valueOf(this.getFullName()) + "Iteration " + this._currentIteration + " is complete.");
        }
        ++this._currentIteration;
        int numberOfIterations = ((IntToken)this.iterations.getToken()).intValue();
        if (numberOfIterations > 0 && this._currentIteration >= numberOfIterations) {
            super.postfire();
            return false;
        }
        return super.postfire() && needMoreIterations;
    }

    public boolean prefire() throws IllegalActionException {
        if (this._debugging) {
            this._debug("FixedPointDirector: Called prefire().");
        }
        this._actorsAllowedToFire.clear();
        this._actorsFinishedFiring.clear();
        this._actorsFired.clear();
        this._cachedAllInputsKnown.clear();
        this._lastNumberOfKnownReceivers = -1;
        this._resetAllReceivers();
        boolean result = super.prefire();
        return result;
    }

    public String[] suggestedModalModelDirectors() {
        String[] defaultSuggestions = new String[2];
        defaultSuggestions[1] = "ptolemy.domains.fsm.kernel.NonStrictFSMDirector";
        defaultSuggestions[0] = "ptolemy.domains.fsm.kernel.FSMDirector";
        return defaultSuggestions;
    }

    public boolean transferInputs(IOPort port) throws IllegalActionException {
        boolean result = false;
        int i = 0;
        while (i < port.getWidth()) {
            if (port.isKnown(i)) {
                if (port.hasToken(i)) {
                    result = super.transferInputs(port) || result;
                } else {
                    port.sendClearInside(i);
                }
            }
            ++i;
        }
        return result;
    }

    public boolean transferOutputs(IOPort port) throws IllegalActionException {
        boolean result = false;
        int i = 0;
        while (i < port.getWidthInside()) {
            if (port.isKnownInside(i)) {
                if (port.hasTokenInside(i)) {
                    result = super.transferOutputs(port) || result;
                } else {
                    port.sendClear(i);
                }
            }
            ++i;
        }
        return result;
    }

    protected void _receiverChanged() {
        ++this._currentNumberOfKnownReceivers;
    }

    protected void _resetAllReceivers() {
        if (this._debugging) {
            this._debug("    FixedPointDirector is resetting all receivers");
        }
        this._currentNumberOfKnownReceivers = 0;
        Iterator receiverIterator = this._receivers.iterator();
        while (receiverIterator.hasNext()) {
            ((FixedPointReceiver)receiverIterator.next()).reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _synchronizeToRealTime() throws IllegalActionException {
        boolean synchronizeValue = ((BooleanToken)this.synchronizeToRealTime.getToken()).booleanValue();
        if (synchronizeValue) {
            FixedPointDirector fixedPointDirector = this;
            synchronized (fixedPointDirector) {
                while (true) {
                    long elapsedTime = System.currentTimeMillis() - this._realStartTime;
                    double elapsedTimeInSeconds = (double)elapsedTime / 1000.0;
                    double currentTime = this.getModelTime().getDoubleValue();
                    if (currentTime <= elapsedTimeInSeconds) break;
                    long timeToWait = (long)((currentTime - elapsedTimeInSeconds) * 1000.0);
                    if (this._debugging) {
                        this._debug("Waiting for real time to pass: " + timeToWait);
                    }
                    try {
                        if (timeToWait <= 0L) continue;
                        this._workspace.wait(this, timeToWait);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    private boolean _areAllInputsKnown(Actor actor) throws IllegalActionException {
        if (this._cachedAllInputsKnown.contains(actor)) {
            return true;
        }
        for (IOPort inputPort : actor.inputPortList()) {
            if (inputPort.isKnown()) continue;
            return false;
        }
        this._cachedAllInputsKnown.add(actor);
        return true;
    }

    private void _fireActor(Actor actor) throws IllegalActionException {
        boolean prefireReturns = actor.prefire();
        if (this._debugging) {
            this._debug("FixedPointDirector: Prefiring: " + actor.getFullName() + ", which returns " + prefireReturns);
        }
        if (!prefireReturns && this._actorsAllowedToFire.contains(actor)) {
            throw new IllegalActionException((Nameable)actor, "prefire() method returns false, but it has previously returned true in this iteration.");
        }
        if (prefireReturns) {
            this._actorsAllowedToFire.add(actor);
            boolean allInputsKnownBeforeFiring = this._areAllInputsKnown(actor);
            if (this._debugging) {
                if (allInputsKnownBeforeFiring) {
                    this._debug("Firing: " + actor.getName() + ", which has all inputs known.");
                } else {
                    this._debug("Firing: " + actor.getName() + ", which has some inputs unknown.");
                }
            }
            actor.fire();
            if (allInputsKnownBeforeFiring) {
                this._actorsFinishedFiring.add(actor);
                this._sendClearToAllUnknownOutputsOf(actor);
            }
        } else {
            this._actorsFinishedFiring.add(actor);
            this._sendClearToAllUnknownOutputsOf(actor);
        }
    }

    private boolean _hasIterationConverged() {
        if (this._debugging) {
            this._debug(String.valueOf(this.getFullName()) + ":\n Number of receivers known previously is " + this._lastNumberOfKnownReceivers + ":\n Number of receivers known now is " + this._currentNumberOfKnownReceivers);
        }
        boolean converged = this._lastNumberOfKnownReceivers == this._currentNumberOfKnownReceivers;
        this._lastNumberOfKnownReceivers = this._currentNumberOfKnownReceivers;
        return converged;
    }

    private void _init() throws IllegalActionException, NameDuplicationException {
        this.iterations = new Parameter((NamedObj)this, "iterations", new IntToken(0));
        this.iterations.setTypeEquals(BaseType.INT);
        this.synchronizeToRealTime = new Parameter(this, "synchronizeToRealTime");
        this.synchronizeToRealTime.setExpression("false");
        this.synchronizeToRealTime.setTypeEquals(BaseType.BOOLEAN);
        this.timeResolution.setVisibility(Settable.FULL);
        this.timeResolution.moveToLast();
        FixedPointScheduler scheduler = new FixedPointScheduler(this, this.uniqueName("Scheduler"));
        this.setScheduler(scheduler);
    }

    private boolean _isReadyToFire(Actor actor) throws IllegalActionException {
        return !this._actorsFinishedFiring.contains(actor) && (!actor.isStrict() || this._areAllInputsKnown(actor));
    }

    private boolean _postfireActor(Actor actor) throws IllegalActionException {
        if (this._actorsAllowedToFire.contains(actor)) {
            this._debug(String.valueOf(this.getFullName()) + " is postfiring " + actor.getFullName());
            return actor.postfire();
        }
        return true;
    }

    private void _sendClearToAllUnknownOutputsOf(Actor actor) throws IllegalActionException {
        for (IOPort outputPort : actor.outputPortList()) {
            int j = 0;
            while (j < outputPort.getWidth()) {
                if (!outputPort.isKnown(j)) {
                    if (this._debugging) {
                        this._debug("  FixedPointDirector: Set output " + outputPort.getFullName() + " to absent.");
                    }
                    outputPort.sendClear(j);
                }
                ++j;
            }
        }
    }
}

