/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.process;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import ptolemy.actor.Actor;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Director;
import ptolemy.actor.IOPort;
import ptolemy.actor.Mailbox;
import ptolemy.actor.Manager;
import ptolemy.actor.Receiver;
import ptolemy.actor.process.NotifyThread;
import ptolemy.actor.process.ProcessReceiver;
import ptolemy.actor.process.ProcessThread;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public class ProcessDirector
extends Director {
    protected boolean _notDone = true;
    protected boolean _stopFireRequested = false;
    private HashSet _blockedThreads = new HashSet();
    private HashSet _pausedThreads = new HashSet();
    private HashSet _activeThreads = new HashSet();
    private LinkedList _newActorThreadList;

    public ProcessDirector() {
    }

    public ProcessDirector(Workspace workspace) {
        super(workspace);
    }

    public ProcessDirector(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    public synchronized void addThread(Thread thread) {
        this._activeThreads.add(thread);
        if (this._debugging) {
            this._debug("Adding a thread: " + thread.getName());
        }
        this.notifyAll();
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        ProcessDirector newObject = (ProcessDirector)super.clone(workspace);
        newObject._blockedThreads = new HashSet();
        newObject._pausedThreads = new HashSet();
        newObject._activeThreads = new HashSet();
        newObject._notDone = true;
        return newObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fire() throws IllegalActionException {
        if (this._debugging) {
            this._debug("Called fire().");
        }
        Workspace workspace = this.workspace();
        CompositeActor container = (CompositeActor)this.getContainer();
        Director outsideDirector = container.getExecutiveDirector();
        if (!(outsideDirector instanceof ProcessDirector)) {
            outsideDirector = null;
        }
        ProcessDirector processDirector = this;
        synchronized (processDirector) {
            while (!(this._areThreadsDeadlocked() || this._areAllThreadsStopped() || this._stopRequested)) {
                if (this._stopRequested) {
                    return;
                }
                if (this._debugging) {
                    this._debug("Waiting for actors to stop.");
                }
                try {
                    try {
                        if (outsideDirector != null) {
                            ((ProcessDirector)outsideDirector).threadBlocked(Thread.currentThread(), null);
                        }
                        workspace.wait(this);
                    }
                    catch (InterruptedException interruptedException) {
                        this.stop();
                        if (outsideDirector != null) {
                            ((ProcessDirector)outsideDirector).threadUnblocked(Thread.currentThread(), null);
                        }
                        return;
                    }
                }
                finally {
                    if (outsideDirector != null) {
                        ((ProcessDirector)outsideDirector).threadUnblocked(Thread.currentThread(), null);
                    }
                }
            }
            if (this._debugging) {
                this._debug("Actors have stopped.");
            }
            if (this._areThreadsDeadlocked() && !this._stopRequested) {
                if (this._debugging) {
                    this._debug("Deadlock detected.");
                }
                try {
                    this._notDone = this._resolveDeadlock();
                }
                catch (IllegalActionException e) {
                    this.stop();
                    throw e;
                }
            }
        }
    }

    public void initialize() throws IllegalActionException {
        super.initialize();
    }

    public void initialize(Actor actor) throws IllegalActionException {
        if (this._debugging) {
            this._debug("Initializing actor: " + ((NamedObj)((Object)actor)).getFullName());
        }
        for (IOPort port : actor.inputPortList()) {
            Receiver[][] receivers = port.getReceivers();
            int i = 0;
            while (i < receivers.length) {
                int j = 0;
                while (j < receivers[i].length) {
                    ((ProcessReceiver)receivers[i][j]).reset();
                    ++j;
                }
                ++i;
            }
        }
        ProcessThread processThread = this._newProcessThread(actor, this);
        this._activeThreads.add(processThread);
        this._newActorThreadList.addFirst(processThread);
    }

    public boolean isStopFireRequested() {
        return this._stopFireRequested;
    }

    public boolean isStopRequested() {
        return this._stopRequested;
    }

    public synchronized boolean isThreadActive(Thread thread) {
        return this._activeThreads.contains(thread);
    }

    public Receiver newReceiver() {
        return new Mailbox();
    }

    public boolean postfire() throws IllegalActionException {
        if (this._debugging) {
            this._debug("Called postfire().");
            this._debug("_notDone = " + this._notDone);
            this._debug("_stopRequested = " + this._stopRequested);
            this._debug("_stopFireRequested = " + this._stopFireRequested);
        }
        boolean bl = this._notDone = this._notDone && !this._stopRequested;
        if (this._debugging) {
            this._debug("Returning from postfire(): " + this._notDone);
        }
        return this._notDone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean prefire() throws IllegalActionException {
        this._stopFireRequested = false;
        ProcessDirector processDirector = this;
        synchronized (processDirector) {
            this.notifyAll();
        }
        for (ProcessThread procThread : this._newActorThreadList) {
            procThread.start();
        }
        this._newActorThreadList.clear();
        return true;
    }

    public void preinitialize() throws IllegalActionException {
        this._notDone = true;
        this._activeThreads.clear();
        this._blockedThreads.clear();
        this._pausedThreads.clear();
        this._newActorThreadList = new LinkedList();
        super.preinitialize();
    }

    public synchronized void removeThread(Thread thread) {
        if (this._debugging) {
            this._debug("Thread " + thread.getName() + " is exiting.");
        }
        this._activeThreads.remove(thread);
        this._pausedThreads.remove(thread);
        this._blockedThreads.remove(thread);
        this.notifyAll();
    }

    public void stop() {
        if (this._debugging) {
            this._debug("Requesting stop of all threads.");
        }
        this._stopRequested = true;
        this._stopFireRequested = true;
        LinkedList threadsCopy = new LinkedList(this._activeThreads);
        for (Thread thread : threadsCopy) {
            if (!(thread instanceof ProcessThread)) continue;
            ((ProcessThread)thread).getActor().stop();
        }
        this._requestFinishOnReceivers();
        new NotifyThread(this).start();
    }

    public void stopFire() {
        if (this._debugging) {
            this._debug("stopFire() has been called.");
        }
        this._stopFireRequested = true;
        for (Thread thread : this._activeThreads) {
            if (!(thread instanceof ProcessThread)) continue;
            ((ProcessThread)thread).getActor().stopFire();
        }
    }

    public void terminate() {
        super.terminate();
        LinkedList list = new LinkedList();
        list.addAll(this._activeThreads);
        this._activeThreads.clear();
        Iterator threads = list.iterator();
        while (threads.hasNext()) {
            ((Thread)threads.next()).stop();
        }
    }

    public synchronized void threadBlocked(Thread thread, ProcessReceiver receiver) {
        if (this._activeThreads.contains(thread) && !this._blockedThreads.contains(thread)) {
            this._blockedThreads.add(thread);
            this.notifyAll();
        }
    }

    public synchronized void threadHasPaused(Thread thread) {
        if (this._activeThreads.contains(thread) && !this._pausedThreads.contains(thread)) {
            this._pausedThreads.add(thread);
            this._blockedThreads.remove(thread);
            this.notifyAll();
        }
    }

    public synchronized void threadHasResumed(Thread thread) {
        if (this._pausedThreads.remove(thread)) {
            this.notifyAll();
        }
    }

    public synchronized void threadUnblocked(Thread thread, ProcessReceiver receiver) {
        if (this._blockedThreads.remove(thread)) {
            this.notifyAll();
        }
    }

    public boolean transferInputs(IOPort port) {
        return false;
    }

    public boolean transferOutputs(IOPort port) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void wrapup() throws IllegalActionException {
        Manager manager;
        if (this._debugging) {
            this._debug("Called wrapup().");
        }
        CompositeActor container = (CompositeActor)this.getContainer();
        this._requestFinishOnReceivers();
        NamedObj namedObj = manager = container.getManager();
        synchronized (namedObj) {
            manager.notifyAll();
        }
        namedObj = this;
        synchronized (namedObj) {
            while (true) {
                if (this._activeThreads.size() <= 0) {
                    return;
                }
                try {
                    this.workspace().wait(this);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    protected synchronized boolean _areAllThreadsStopped() {
        return this._getActiveThreadsCount() == this._getStoppedThreadsCount() + this._getBlockedThreadsCount();
    }

    protected synchronized boolean _areThreadsDeadlocked() {
        return this._activeThreads.size() == 0;
    }

    protected final synchronized int _getActiveThreadsCount() {
        return this._activeThreads.size();
    }

    protected final synchronized int _getBlockedThreadsCount() {
        return this._blockedThreads.size();
    }

    protected final synchronized int _getStoppedThreadsCount() {
        return this._pausedThreads.size();
    }

    protected ProcessThread _newProcessThread(Actor actor, ProcessDirector director) throws IllegalActionException {
        return new ProcessThread(actor, director);
    }

    protected boolean _resolveDeadlock() throws IllegalActionException {
        return false;
    }

    private void _requestFinishOnReceivers() {
        CompositeActor container = (CompositeActor)this.getContainer();
        for (Actor actor : container.deepEntityList()) {
            for (IOPort port : actor.inputPortList()) {
                Receiver[][] receivers = port.getReceivers();
                int i = 0;
                while (i < receivers.length) {
                    int j = 0;
                    while (j < receivers[i].length) {
                        ProcessReceiver nextReceiver = (ProcessReceiver)receivers[i][j];
                        nextReceiver.requestFinish();
                        ++j;
                    }
                    ++i;
                }
            }
        }
    }
}

