/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.lib.RandomSource;
import ptolemy.actor.parameters.PortParameter;
import ptolemy.data.BooleanToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.expr.SingletonParameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;

public class Uniform
extends RandomSource {
    public PortParameter lowerBound;
    public PortParameter upperBound;
    private double _current;

    public Uniform(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.output.setTypeEquals(BaseType.DOUBLE);
        this.lowerBound = new PortParameter((NamedObj)this, "lowerBound", new DoubleToken(0.0));
        this.lowerBound.setTypeEquals(BaseType.DOUBLE);
        new SingletonParameter(this.lowerBound.getPort(), "_showName").setToken(BooleanToken.TRUE);
        this.upperBound = new PortParameter((NamedObj)this, "upperBound", new DoubleToken(1.0));
        this.upperBound.setTypeEquals(BaseType.DOUBLE);
        new SingletonParameter(this.upperBound.getPort(), "_showName").setToken(BooleanToken.TRUE);
    }

    public void fire() throws IllegalActionException {
        this.lowerBound.update();
        this.upperBound.update();
        super.fire();
        this.output.send(0, new DoubleToken(this._current));
    }

    protected void _generateRandomNumber() throws IllegalActionException {
        double upperValue;
        double lowerValue = ((DoubleToken)this.lowerBound.getToken()).doubleValue();
        if (lowerValue > (upperValue = ((DoubleToken)this.upperBound.getToken()).doubleValue())) {
            throw new IllegalActionException((Nameable)this, "Invalid bounds: lowerBound is greater than upperBound.");
        }
        double rawNum = this._random.nextDouble();
        this._current = rawNum * (upperValue - lowerValue) + lowerValue;
    }
}

