/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.lib.Transformer;
import ptolemy.data.DoubleToken;
import ptolemy.data.expr.StringParameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;

public class UnaryMathFunction
extends Transformer {
    public StringParameter function = new StringParameter(this, "function");
    private int _function;
    private static final int _EXP = 0;
    private static final int _LOG = 1;
    private static final int _SIGN = 2;
    private static final int _SQUARE = 3;
    private static final int _SQRT = 4;

    public UnaryMathFunction(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.function.setExpression("exp");
        this.function.addChoice("exp");
        this.function.addChoice("log");
        this.function.addChoice("sign");
        this.function.addChoice("square");
        this.function.addChoice("sqrt");
        this._function = 0;
        this.input.setTypeEquals(BaseType.DOUBLE);
        this.output.setTypeEquals(BaseType.DOUBLE);
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-30\" y=\"-15\" width=\"60\" height=\"30\" style=\"fill:white\"/>\n</svg>\n");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.function) {
            String functionName = this.function.stringValue();
            if (functionName.equals("exp")) {
                this._function = 0;
                return;
            } else if (functionName.equals("log")) {
                this._function = 1;
                return;
            } else if (functionName.equals("sign")) {
                this._function = 2;
                return;
            } else if (functionName.equals("square")) {
                this._function = 3;
                return;
            } else {
                if (!functionName.equals("sqrt")) throw new IllegalActionException((Nameable)this, "Unrecognized math function: " + functionName);
                this._function = 4;
            }
            return;
        } else {
            super.attributeChanged(attribute);
        }
    }

    public void fire() throws IllegalActionException {
        super.fire();
        if (this.input.hasToken(0)) {
            double inputValue = ((DoubleToken)this.input.get(0)).doubleValue();
            this.output.send(0, new DoubleToken(this._doFunction(inputValue)));
        }
    }

    private double _doFunction(double input) {
        double result;
        switch (this._function) {
            case 0: {
                result = Math.exp(input);
                break;
            }
            case 1: {
                result = Math.log(input);
                break;
            }
            case 2: {
                if (input > 0.0) {
                    result = 1.0;
                    break;
                }
                if (input < 0.0) {
                    result = -1.0;
                    break;
                }
                result = 0.0;
                break;
            }
            case 3: {
                result = input * input;
                break;
            }
            case 4: {
                result = Math.sqrt(input);
                break;
            }
            default: {
                throw new InternalErrorException("Invalid value for _function private variable. MathFunction actor (" + this.getFullName() + ")" + " on function type " + this._function);
            }
        }
        return result;
    }
}

