/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import java.util.ArrayList;
import java.util.List;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.Discard;
import ptolemy.actor.lib.NonStrictTest;
import ptolemy.data.BooleanToken;
import ptolemy.data.RecordToken;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;

public class TypeTest
extends Discard {
    public Parameter parameterTypes = new Parameter(this, "parameterTypes");
    public Parameter portTypes;
    public Parameter trainingMode;

    public TypeTest(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.parameterTypes.setExpression("");
        this.portTypes = new Parameter(this, "portTypes");
        this.portTypes.setExpression("");
        this.trainingMode = new Parameter(this, "trainingMode");
        this.trainingMode.setExpression("false");
        this.trainingMode.setTypeEquals(BaseType.BOOLEAN);
    }

    public void initialize() throws IllegalActionException {
        super.initialize();
        ArrayList<String> portActorNameList = new ArrayList<String>();
        ArrayList<String> parameterActorNameList = new ArrayList<String>();
        ArrayList<RecordToken> portAssignments = new ArrayList<RecordToken>();
        ArrayList<RecordToken> parameterAssignments = new ArrayList<RecordToken>();
        List entityList = ((CompositeEntity)this.getContainer()).entityList();
        for (ComponentEntity entity : entityList) {
            if (entity.equals(this)) continue;
            ArrayList<String> portNames = new ArrayList<String>();
            ArrayList<StringToken> portTypes = new ArrayList<StringToken>();
            for (TypedIOPort port : entity.portList()) {
                portNames.add(port.getName());
                portTypes.add(new StringToken(port.getType().toString()));
            }
            if (portNames.size() > 0) {
                portActorNameList.add(entity.getName());
                portAssignments.add(new RecordToken(portNames.toArray(new String[portNames.size()]), portTypes.toArray(new Token[portTypes.size()])));
            }
            ArrayList<String> paramNames = new ArrayList<String>();
            ArrayList<StringToken> paramTypes = new ArrayList<StringToken>();
            for (Parameter param : entity.attributeList(Parameter.class)) {
                paramNames.add(param.getName());
                paramTypes.add(new StringToken(param.getType().toString()));
            }
            if (paramNames.size() <= 0) continue;
            parameterActorNameList.add(entity.getName());
            parameterAssignments.add(new RecordToken(paramNames.toArray(new String[paramNames.size()]), paramTypes.toArray(new Token[paramTypes.size()])));
        }
        RecordToken actualPortTypes = new RecordToken(portActorNameList.toArray(new String[portActorNameList.size()]), portAssignments.toArray(new Token[portAssignments.size()]));
        RecordToken actualParameterTypes = new RecordToken(parameterActorNameList.toArray(new String[parameterActorNameList.size()]), parameterAssignments.toArray(new Token[parameterAssignments.size()]));
        if (((BooleanToken)this.trainingMode.getToken()).booleanValue()) {
            if (NonStrictTest.isRunningNightlyBuild()) {
                throw new IllegalActionException((Nameable)this, "Training Mode set for test actor and isRunningNightlyBuild()\n  returned true, indicating that the\n  ptolemy.ptII.isRunningNightlyBuild property is set.\n  The trainingMode parameter should not be set in files\n  that are checked into the nightly build!  To run the tests in nightly build mode, use     make nightly");
            }
            System.err.println("Warning: '" + this.getFullName() + "' is in training mode, set the trainingMode " + "parameter to false before checking in");
            if (actualPortTypes.length() > 0) {
                this.portTypes.setToken(actualPortTypes);
            } else {
                this.portTypes.setToken((Token)null);
            }
            if (actualParameterTypes.length() > 0) {
                this.parameterTypes.setToken(actualParameterTypes);
            } else {
                this.parameterTypes.setToken((Token)null);
            }
        } else {
            StringToken actualValue;
            StringToken value;
            RecordToken assignment;
            RecordToken correctPortTypes = (RecordToken)this.portTypes.getToken();
            RecordToken correctParameterTypes = (RecordToken)this.parameterTypes.getToken();
            if (correctPortTypes != null) {
                for (String actorName : correctPortTypes.labelSet()) {
                    assignment = (RecordToken)correctPortTypes.get(actorName);
                    for (String name : assignment.labelSet()) {
                        value = (StringToken)assignment.get(name);
                        if (actualPortTypes.get(actorName) == null) {
                            throw new IllegalActionException((Nameable)this, "actualPortTypes.get(" + actorName + ") returned null.  Perhaps there is no " + "actor by that name?");
                        }
                        actualValue = (StringToken)((RecordToken)actualPortTypes.get(actorName)).get(name);
                        if (value.equals(actualValue)) continue;
                        throw new IllegalActionException((Nameable)this, "Type of port " + ((CompositeEntity)this.getContainer()).getEntity(actorName).getFullName() + "." + name + " should have been " + value + " but was " + actualValue + ".");
                    }
                }
            }
            if (correctParameterTypes != null) {
                for (String actorName : correctParameterTypes.labelSet()) {
                    assignment = (RecordToken)correctParameterTypes.get(actorName);
                    for (String name : assignment.labelSet()) {
                        value = (StringToken)assignment.get(name);
                        if (value.equals(actualValue = (StringToken)((RecordToken)actualParameterTypes.get(actorName)).get(name))) continue;
                        throw new IllegalActionException((Nameable)this, "Type of parameter " + ((CompositeEntity)this.getContainer()).getEntity(actorName).getFullName() + "." + name + " should have been " + value + " but was " + actualValue + ".");
                    }
                }
            }
        }
    }
}

