/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.Actor;
import ptolemy.actor.Director;
import ptolemy.actor.TimedActor;
import ptolemy.actor.lib.Source;
import ptolemy.actor.util.Time;
import ptolemy.data.DoubleToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;

public class TimedSource
extends Source
implements TimedActor {
    public Parameter stopTime = new Parameter(this, "stopTime");
    private boolean _executing = false;
    private Time _stopTime;

    public TimedSource(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.stopTime.setExpression("Infinity");
        this.stopTime.setTypeEquals(BaseType.DOUBLE);
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-20\" y=\"-20\" width=\"40\" height=\"40\" style=\"fill:lightGrey\"/>\n<circle cx=\"0\" cy=\"0\" r=\"17\"style=\"fill:white\"/>\n<line x1=\"0\" y1=\"-15\" x2=\"0\" y2=\"-13\"/>\n<line x1=\"0\" y1=\"14\" x2=\"0\" y2=\"16\"/>\n<line x1=\"-15\" y1=\"0\" x2=\"-13\" y2=\"0\"/>\n<line x1=\"14\" y1=\"0\" x2=\"16\" y2=\"0\"/>\n<line x1=\"0\" y1=\"-8\" x2=\"0\" y2=\"0\"/>\n<line x1=\"0\" y1=\"0\" x2=\"11.26\" y2=\"-6.5\"/>\n</svg>\n");
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.stopTime) {
            double newStopTimeValue = ((DoubleToken)this.stopTime.getToken()).doubleValue();
            if (this._executing) {
                Time newStopTime = new Time(this.getDirector(), newStopTimeValue);
                Director director = this.getDirector();
                if (director != null) {
                    Time currentTime = director.getModelTime();
                    if (newStopTime.compareTo(currentTime) > 0) {
                        director.fireAt((Actor)this, newStopTime);
                    } else {
                        throw new IllegalActionException((Nameable)this, "The stop time is earlier than the current time.");
                    }
                }
                this._stopTime = newStopTime;
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    public double getStopTime() {
        return this.getModelStopTime().getDoubleValue();
    }

    public Time getModelStopTime() {
        return this._stopTime;
    }

    public void initialize() throws IllegalActionException {
        super.initialize();
        Director director = this.getDirector();
        if (director == null) {
            throw new IllegalActionException((Nameable)this, "No director!");
        }
        double stopTimeValue = ((DoubleToken)this.stopTime.getToken()).doubleValue();
        this._stopTime = new Time(this.getDirector(), stopTimeValue);
        Time currentTime = director.getModelTime();
        if (!this._stopTime.isInfinite() && this._stopTime.compareTo(currentTime) > 0) {
            director.fireAt((Actor)this, this._stopTime);
            this._executing = true;
        }
    }

    public boolean postfire() throws IllegalActionException {
        Time currentTime = this.getDirector().getModelTime();
        return currentTime.compareTo(this._stopTime) < 0;
    }

    public void wrapup() throws IllegalActionException {
        super.wrapup();
        this._executing = false;
    }
}

