/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.Director;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedCompositeActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.TypedIORelation;
import ptolemy.actor.lib.Publisher;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public class Subscriber
extends TypedAtomicActor {
    public StringParameter channel = new StringParameter(this, "channel");
    public TypedIOPort input;
    public TypedIOPort output;
    protected String _channel;
    protected boolean _updatedLinks = false;
    private TypedIORelation _relation;

    public Subscriber(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.channel.setExpression("channel1");
        this.input = new TypedIOPort(this, "input", true, false);
        this.input.setMultiport(true);
        this.output = new TypedIOPort(this, "output", false, true);
        this.output.setMultiport(true);
        new Parameter((NamedObj)this.input, "_hide", BooleanToken.TRUE);
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.channel) {
            String newValue = this.channel.stringValue();
            if (!newValue.equals(this._channel)) {
                NamedObj container;
                this._channel = newValue;
                if (!this.isWithinClassDefinition() && (container = this.getContainer()) instanceof TypedCompositeActor) {
                    this._updateLinks();
                }
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    protected boolean channelMatches(String channelName) {
        if (this._channel == null) {
            return false;
        }
        return this._channel.equals(channelName);
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        Subscriber newObject = (Subscriber)super.clone(workspace);
        try {
            newObject._updatedLinks = false;
        }
        catch (Throwable throwable) {
            CloneNotSupportedException exception = new CloneNotSupportedException();
            exception.initCause(throwable);
            throw exception;
        }
        return newObject;
    }

    public void fire() throws IllegalActionException {
        super.fire();
        int width = this.input.getWidth();
        if (width == 0) {
            throw new IllegalActionException((Nameable)this, "Subscriber has no matching Publisher.");
        }
        int i = 0;
        while (i < width) {
            if (this.input.hasToken(i)) {
                Token token = this.input.get(i);
                if (i < this.output.getWidth()) {
                    this.output.send(i, token);
                }
            }
            ++i;
        }
    }

    public void preinitialize() throws IllegalActionException {
        super.preinitialize();
        if (!this._updatedLinks) {
            this._updateLinks();
        }
        if (this.input.getWidth() == 0) {
            this._updateLinks();
            if (this.input.getWidth() == 0) {
                throw new IllegalActionException((Nameable)this, "Subscriber has no matching Publisher.");
            }
        }
    }

    protected void _updateLinks() throws IllegalActionException {
        Director director;
        if (this._channel == null) {
            return;
        }
        Publisher publisher = this._findPublisher();
        if (this._relation != null) {
            this.input.unlink(this._relation);
            this._relation = null;
        }
        if (publisher != null) {
            if (publisher._relation == null || !publisher._updatedLinks) {
                publisher._updateLinks();
            }
            this._relation = publisher._relation;
            this.input.liberalLink(this._relation);
        }
        if ((director = this.getDirector()) != null) {
            director.invalidateSchedule();
            director.invalidateResolvedTypes();
        }
        this._updatedLinks = true;
    }

    private Publisher _findPublisher() throws IllegalActionException {
        CompositeEntity container = (CompositeEntity)this.getContainer();
        while (container != null && !container.isOpaque()) {
            container = (CompositeEntity)container.getContainer();
        }
        if (container != null) {
            for (Object actor : container.deepEntityList()) {
                if (!(actor instanceof Publisher) || !this._channel.equals(((Publisher)actor)._channel)) continue;
                return (Publisher)actor;
            }
        }
        return null;
    }
}

