/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.lib.Transformer;
import ptolemy.actor.parameters.PortParameter;
import ptolemy.data.IntToken;
import ptolemy.data.MatrixToken;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public class SubMatrix
extends Transformer {
    public PortParameter column;
    public PortParameter columnSpan;
    public PortParameter row = new PortParameter(this, "row");
    public PortParameter rowSpan;

    public SubMatrix(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.row.setTypeEquals(BaseType.INT);
        this.row.setExpression("0");
        this.column = new PortParameter(this, "column");
        this.column.setTypeEquals(BaseType.INT);
        this.column.setExpression("0");
        this.rowSpan = new PortParameter(this, "rowSpan");
        this.rowSpan.setTypeEquals(BaseType.INT);
        this.rowSpan.setExpression("1");
        this.columnSpan = new PortParameter(this, "columnSpan");
        this.columnSpan.setTypeEquals(BaseType.INT);
        this.columnSpan.setExpression("1");
    }

    public void fire() throws IllegalActionException {
        super.fire();
        if (!this.input.hasToken(0)) {
            return;
        }
        this.row.update();
        this.column.update();
        this.rowSpan.update();
        this.columnSpan.update();
        int columnValue = ((IntToken)this.column.getToken()).intValue();
        int rowValue = ((IntToken)this.row.getToken()).intValue();
        int columnSpanValue = ((IntToken)this.columnSpan.getToken()).intValue();
        int rowSpanValue = ((IntToken)this.rowSpan.getToken()).intValue();
        MatrixToken inputValue = (MatrixToken)this.input.get(0);
        this.output.send(0, inputValue.crop(rowValue, columnValue, rowSpanValue, columnSpanValue));
    }
}

