/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import java.util.ArrayList;
import java.util.List;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.util.ExplicitChangeContext;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.Variable;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.ChangeListener;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.util.MessageHandler;

public class SetVariable
extends TypedAtomicActor
implements ChangeListener,
ExplicitChangeContext {
    public TypedIOPort input = new TypedIOPort(this, "input", true, false);
    public StringAttribute variableName;
    public Parameter delayed;
    public TypedIOPort output = new TypedIOPort(this, "output", false, true);
    private Attribute _attribute;
    private long _attributeVersion = -1L;
    private boolean _setFailed = false;

    public SetVariable(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.variableName = new StringAttribute(this, "variableName");
        this.variableName.setExpression("parameter");
        this.delayed = new Parameter(this, "delayed");
        this.delayed.setTypeEquals(BaseType.BOOLEAN);
        this.delayed.setExpression("true");
    }

    public void changeExecuted(ChangeRequest change) {
    }

    public void changeFailed(ChangeRequest change, Exception exception) {
        this._setFailed = true;
        MessageHandler.error("Failed to set variable.", exception);
    }

    public Entity getContext() {
        try {
            if (this.delayed.getToken().equals(BooleanToken.TRUE)) {
                return (Entity)this.toplevel();
            }
            return this;
        }
        catch (IllegalActionException illegalActionException) {
            return this;
        }
    }

    public Attribute getModifiedVariable() throws IllegalActionException {
        if (this._workspace.getVersion() == this._attributeVersion) {
            return this._attribute;
        }
        NamedObj container = this.getContainer();
        if (container == null) {
            throw new IllegalActionException((Nameable)this, "No container.");
        }
        String variableNameValue = this.variableName.getExpression();
        this._attribute = null;
        while (this._attribute == null && container != null) {
            this._attribute = container.getAttribute(variableNameValue);
            if (this._attribute != null) continue;
            container = container.getContainer();
        }
        if (this._attribute == null) {
            try {
                try {
                    this.workspace().getWriteAccess();
                    this._attribute = new Variable(this.getContainer(), variableNameValue);
                }
                catch (NameDuplicationException ex) {
                    throw new InternalErrorException(ex);
                }
            }
            finally {
                this.workspace().doneWriting();
            }
        }
        this._attributeVersion = this._workspace.getVersion();
        return this._attribute;
    }

    public List getModifiedVariables() throws IllegalActionException {
        Attribute attribute = this.getModifiedVariable();
        ArrayList<Attribute> list = new ArrayList<Attribute>(1);
        if (attribute instanceof Variable) {
            list.add(attribute);
        }
        return list;
    }

    public boolean postfire() throws IllegalActionException {
        if (this.input.hasToken(0)) {
            final Token value = this.input.get(0);
            if (this.delayed.getToken().equals(BooleanToken.TRUE)) {
                if (this._setFailed) {
                    return false;
                }
                ChangeRequest request = new ChangeRequest(this, "SetVariable change request"){

                    protected void _execute() throws IllegalActionException {
                        SetVariable.this._setValue(value);
                    }
                };
                request.setPersistent(false);
                request.addChangeListener(this);
                this.requestChange(request);
            } else {
                this._setValue(value);
            }
            if (this.output.getWidth() > 0) {
                this.output.send(0, value);
            }
        }
        return true;
    }

    public void preinitialize() throws IllegalActionException {
        super.preinitialize();
        Attribute attribute = this.getModifiedVariable();
        if (attribute instanceof Variable) {
            ((Variable)attribute).setTypeAtLeast(this.input);
        }
        this._setFailed = false;
    }

    private void _setValue(Token value) throws IllegalActionException {
        Attribute variable = this.getModifiedVariable();
        if (variable instanceof Variable) {
            ((Variable)variable).setToken(value);
            ((Variable)variable).validate();
        } else if (variable instanceof Settable) {
            ((Settable)((Object)variable)).setExpression(value.toString());
            ((Settable)((Object)variable)).validate();
        } else {
            throw new IllegalActionException((Nameable)this, "Cannot set the value of the variable named: " + this.variableName.getExpression());
        }
    }
}

