/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import java.util.TreeMap;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.SequenceActor;
import ptolemy.actor.lib.Transformer;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public class Sequencer
extends Transformer
implements SequenceActor {
    public TypedIOPort sequenceNumber;
    public Parameter startingSequenceNumber;
    private boolean _fireProducedOutput = false;
    private int _nextSequenceNumber;
    private Token _nextToken;
    private TreeMap _pending = new TreeMap();
    private int _sequenceNumberOfInput;

    public Sequencer(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.sequenceNumber = new TypedIOPort(this, "sequenceNumber", true, false);
        this.sequenceNumber.setTypeEquals(BaseType.INT);
        this.startingSequenceNumber = new Parameter(this, "startingSequenceNumber");
        this.startingSequenceNumber.setExpression("0");
    }

    public void fire() throws IllegalActionException {
        super.fire();
        this._sequenceNumberOfInput = ((IntToken)this.sequenceNumber.get(0)).intValue();
        this._nextToken = this.input.get(0);
        if (this._sequenceNumberOfInput == this._nextSequenceNumber) {
            this.output.send(0, this._nextToken);
            this._fireProducedOutput = true;
        }
    }

    public void initialize() throws IllegalActionException {
        this._fireProducedOutput = false;
        this._nextSequenceNumber = ((IntToken)this.startingSequenceNumber.getToken()).intValue();
        this._pending.clear();
    }

    public boolean postfire() throws IllegalActionException {
        if (this._fireProducedOutput) {
            ++this._nextSequenceNumber;
            if (this._pending.size() > 0) {
                Integer nextKey = (Integer)this._pending.firstKey();
                int next = nextKey;
                while (next == this._nextSequenceNumber) {
                    ++this._nextSequenceNumber;
                    Token token = (Token)this._pending.remove(nextKey);
                    this.output.send(0, token);
                    if (this._pending.size() == 0) break;
                    nextKey = (Integer)this._pending.firstKey();
                    next = nextKey;
                }
            }
            this._fireProducedOutput = false;
        } else {
            this._pending.put(this._sequenceNumberOfInput, this._nextToken);
        }
        return super.postfire();
    }

    public boolean prefire() throws IllegalActionException {
        this._fireProducedOutput = false;
        if (!this.sequenceNumber.hasToken(0)) {
            return false;
        }
        if (!this.input.hasToken(0)) {
            return false;
        }
        return super.prefire();
    }
}

