/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.ArrayToken;
import ptolemy.data.BooleanToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public class Sequence
extends TypedAtomicActor {
    public TypedIOPort enable;
    public Parameter holdLastOutput;
    public TypedIOPort output;
    public Parameter repeat;
    public Parameter values = new Parameter(this, "values");
    private int _currentIndex;
    private boolean _outputProduced;

    public Sequence(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.values.setExpression("{1}");
        this.repeat = new Parameter((NamedObj)this, "repeat", BooleanToken.FALSE);
        this.repeat.setTypeEquals(BaseType.BOOLEAN);
        this.holdLastOutput = new Parameter((NamedObj)this, "holdLastOutput", BooleanToken.FALSE);
        this.holdLastOutput.setTypeEquals(BaseType.BOOLEAN);
        this.enable = new TypedIOPort(this, "enable", true, false);
        this.enable.setTypeEquals(BaseType.BOOLEAN);
        this.output = new TypedIOPort(this, "output", false, true);
        this.output.setTypeAtLeast(ArrayType.elementType(this.values));
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        Sequence newObject = (Sequence)super.clone(workspace);
        try {
            newObject.output.setTypeAtLeast(ArrayType.elementType(newObject.values));
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException(e);
        }
        return newObject;
    }

    public void fire() throws IllegalActionException {
        ArrayToken valuesArray;
        super.fire();
        if ((this.enable.getWidth() == 0 || this.enable.hasToken(0) && ((BooleanToken)this.enable.get(0)).booleanValue()) && this._currentIndex < (valuesArray = (ArrayToken)this.values.getToken()).length()) {
            this.output.send(0, valuesArray.getElement(this._currentIndex));
            this._outputProduced = true;
        }
    }

    public void initialize() throws IllegalActionException {
        this._currentIndex = 0;
        this._outputProduced = false;
        super.initialize();
    }

    public boolean postfire() throws IllegalActionException {
        if (this._outputProduced) {
            this._outputProduced = false;
            ++this._currentIndex;
            ArrayToken valuesArray = (ArrayToken)this.values.getToken();
            if (this._currentIndex >= valuesArray.length()) {
                boolean holdLastOutputValue;
                boolean repeatValue = ((BooleanToken)this.repeat.getToken()).booleanValue();
                this._currentIndex = repeatValue ? 0 : ((holdLastOutputValue = ((BooleanToken)this.holdLastOutput.getToken()).booleanValue()) ? valuesArray.length() - 1 : valuesArray.length());
            }
        }
        return super.postfire();
    }
}

