/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.lib.RandomSource;
import ptolemy.data.DoubleToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class Rician
extends RandomSource {
    public Parameter xMean;
    public Parameter yMean;
    public Parameter standardDeviation;
    private double _current;

    public Rician(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.output.setTypeEquals(BaseType.DOUBLE);
        this.xMean = new Parameter((NamedObj)this, "xMean", new DoubleToken(0.0));
        this.xMean.setTypeEquals(BaseType.DOUBLE);
        this.yMean = new Parameter((NamedObj)this, "yMean", new DoubleToken(0.0));
        this.yMean.setTypeEquals(BaseType.DOUBLE);
        this.standardDeviation = new Parameter((NamedObj)this, "standardDeviation", new DoubleToken(1.0));
        this.standardDeviation.setTypeEquals(BaseType.DOUBLE);
    }

    public void fire() throws IllegalActionException {
        super.fire();
        this.output.send(0, new DoubleToken(this._current));
    }

    protected void _generateRandomNumber() throws IllegalActionException {
        double xMeanValue = ((DoubleToken)this.xMean.getToken()).doubleValue();
        double yMeanValue = ((DoubleToken)this.yMean.getToken()).doubleValue();
        double standardDeviationValue = ((DoubleToken)this.standardDeviation.getToken()).doubleValue();
        double xRawNum = this._random.nextGaussian();
        double yRawNum = this._random.nextGaussian();
        this._current = Math.sqrt(Math.pow(xRawNum * standardDeviationValue + xMeanValue, 2.0) + Math.pow(yRawNum * standardDeviationValue + yMeanValue, 2.0));
    }
}

