/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import ptolemy.actor.lib.Sink;
import ptolemy.data.IntToken;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class Recorder
extends Sink {
    public Parameter capacity = new Parameter((NamedObj)this, "capacity", new IntToken(-1));
    private int _count = 0;
    private List _records;
    Token[] _latest;
    private List _timeRecord;
    private static Token _bottom = new StringToken("_");

    public Recorder(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.capacity.setTypeEquals(BaseType.INT);
    }

    public int getCount() {
        return this._count;
    }

    public List getHistory(int channel) {
        ArrayList<Token> result = new ArrayList<Token>();
        if (this._records != null) {
            result.ensureCapacity(this._records.size());
            for (Token[] record : this._records) {
                if (channel < record.length && record[channel] != null) {
                    result.add(record[channel]);
                    continue;
                }
                result.add(_bottom);
            }
        }
        return result;
    }

    public Token getLatest(int channel) {
        if (this._latest == null || channel >= this._latest.length || this._latest[channel] == null) {
            return _bottom;
        }
        return this._latest[channel];
    }

    public Enumeration getRecord(int channel) {
        return Collections.enumeration(this.getHistory(channel));
    }

    public List getTimeHistory() {
        return this._timeRecord;
    }

    public Enumeration getTimeRecord() {
        return Collections.enumeration(this._timeRecord);
    }

    public void initialize() throws IllegalActionException {
        super.initialize();
        this._records = new LinkedList();
        this._timeRecord = new LinkedList();
        this._latest = null;
        this._count = 0;
    }

    public boolean postfire() throws IllegalActionException {
        int width = this.input.getWidth();
        Token[] record = new Token[width];
        int i = 0;
        while (i < width) {
            if (this.input.hasToken(i)) {
                Token token;
                record[i] = token = this.input.get(i);
                ++this._count;
            }
            ++i;
        }
        int capacityValue = ((IntToken)this.capacity.getToken()).intValue();
        if (capacityValue != 0) {
            this._records.add(record);
            this._timeRecord.add(this.getDirector().getModelTime().getDoubleValue());
            if (capacityValue > 0 && this._records.size() > capacityValue) {
                this._records.remove(0);
                this._timeRecord.remove(0);
            }
        }
        this._latest = record;
        return true;
    }
}

