/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import java.util.LinkedList;
import java.util.List;
import ptolemy.actor.IOPort;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.RecordToken;
import ptolemy.data.Token;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.RecordType;
import ptolemy.data.type.Type;
import ptolemy.graph.Inequality;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public class RecordAssembler
extends TypedAtomicActor {
    public TypedIOPort output = new TypedIOPort(this, "output", false, true);
    private List _typeConstraintList;
    private long _typeConstraintListVersion = -1L;

    public RecordAssembler(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this._attachText("_iconDescription", "<svg>\n<rect x=\"0\" y=\"0\" width=\"6\" height=\"40\" style=\"fill:red\"/>\n</svg>\n");
    }

    public void fire() throws IllegalActionException {
        super.fire();
        Object[] portArray = this.inputPortList().toArray();
        int size = portArray.length;
        String[] labels = new String[size];
        Token[] values = new Token[size];
        int i = 0;
        while (i < size) {
            IOPort port = (IOPort)portArray[i];
            labels[i] = port.getName();
            values[i] = port.get(0);
            ++i;
        }
        RecordToken result = new RecordToken(labels, values);
        this.output.send(0, result);
    }

    public boolean prefire() throws IllegalActionException {
        for (IOPort port : this.inputPortList()) {
            if (port.hasToken(0)) continue;
            return false;
        }
        return true;
    }

    public void preinitialize() throws IllegalActionException {
        super.preinitialize();
        this.typeConstraintList();
    }

    public List typeConstraintList() {
        if (this.workspace().getVersion() == this._typeConstraintListVersion) {
            return this._typeConstraintList;
        }
        Object[] portArray = this.inputPortList().toArray();
        int size = portArray.length;
        String[] labels = new String[size];
        Type[] types = new Type[size];
        int i = 0;
        while (i < size) {
            labels[i] = ((Port)portArray[i]).getName();
            types[i] = BaseType.UNKNOWN;
            ++i;
        }
        RecordType declaredType = new RecordType(labels, types);
        this.output.setTypeEquals(declaredType);
        this._typeConstraintList = new LinkedList();
        RecordType outputType = (RecordType)this.output.getType();
        for (TypedIOPort inputPort : this.inputPortList()) {
            String label = inputPort.getName();
            Inequality inequality = new Inequality(inputPort.getTypeTerm(), outputType.getTypeTerm(label));
            this._typeConstraintList.add(inequality);
        }
        this._typeConstraintListVersion = this.workspace().getVersion();
        return this._typeConstraintList;
    }
}

