/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import java.util.ArrayList;
import java.util.List;
import ptolemy.actor.lib.NonStrictTest;
import ptolemy.actor.lib.Publisher;
import ptolemy.data.ArrayToken;
import ptolemy.data.BooleanToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.SharedParameter;
import ptolemy.util.StringUtilities;

public class PublisherNonStrictTest
extends Publisher {
    public Parameter correctValues = new Parameter(this, "correctValues");
    public Parameter tolerance;
    public SharedParameter trainingMode;
    protected boolean _firedOnce = false;
    protected boolean _initialized = false;
    protected int _iteration;
    protected int _numberOfInputTokensSeen = 0;
    protected double _tolerance;
    protected List _trainingTokens;

    public PublisherNonStrictTest(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.correctValues.setExpression("{true}");
        this.correctValues.setTypeAtLeast(ArrayType.ARRAY_BOTTOM);
        this.tolerance = new Parameter(this, "tolerance");
        this.tolerance.setExpression("1.0E-9");
        this.tolerance.setTypeEquals(BaseType.DOUBLE);
        this.trainingMode = new SharedParameter((NamedObj)this, "trainingMode", this.getClass(), "false");
        this.trainingMode.setTypeEquals(BaseType.BOOLEAN);
        this.input.setMultiport(false);
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.tolerance) {
            this._tolerance = ((DoubleToken)this.tolerance.getToken()).doubleValue();
        } else {
            super.attributeChanged(attribute);
        }
    }

    public void fire() throws IllegalActionException {
        if (this._debugging) {
            this._debug("Called fire()");
        }
        this._firedOnce = true;
        this.input.getWidth();
    }

    public void initialize() throws IllegalActionException {
        super.initialize();
        this._numberOfInputTokensSeen = 0;
        this._iteration = 0;
        this._trainingTokens = null;
        this._firedOnce = false;
        this._initialized = true;
        if (((BooleanToken)this.trainingMode.getToken()).booleanValue()) {
            if (NonStrictTest.isRunningNightlyBuild()) {
                throw new IllegalActionException((Nameable)this, "Training Mode set for test actor and isRunningNightlyBuild()\n  returned true, indicating that the\n  ptolemy.ptII.isRunningNightlyBuild property is set.\n  The trainingMode parameter should not be set in files\n  that are checked into the nightly build!  To run the tests in nightly build mode, use     make nightly");
            }
            System.err.println("Warning: '" + this.getFullName() + "' is in training mode, set the trainingMode " + "parameter to false before checking in");
        }
    }

    public void preinitialize() throws IllegalActionException {
        super.preinitialize();
        if (!this._updatedLinks) {
            this._updateLinks();
        }
    }

    public boolean postfire() throws IllegalActionException {
        if (this.input.getWidth() != 1) {
            throw new IllegalActionException((Nameable)this, "Width of input is " + this.input.getWidth() + " but PublisherNonStrictTest only supports a width of 1.");
        }
        boolean training = ((BooleanToken)this.trainingMode.getToken()).booleanValue();
        if (training) {
            if (this._trainingTokens == null) {
                this._trainingTokens = new ArrayList();
            }
            if (this.input.hasToken(0)) {
                Token token = this.input.get(0);
                this._trainingTokens.add(token);
                this.output.send(0, token);
            }
            return true;
        }
        Token referenceToken = ((ArrayToken)this.correctValues.getToken()).getElement(this._numberOfInputTokensSeen);
        int i = 0;
        while (i < this.input.getWidth()) {
            if (this.input.hasToken(i)) {
                Token token = this.input.get(i);
                ++this._numberOfInputTokensSeen;
                if (!(token.isCloseTo(referenceToken, this._tolerance).booleanValue() || referenceToken.isNil() || NonStrictTest._isCloseToIfNilArrayElement(token, referenceToken, this._tolerance) || NonStrictTest._isCloseToIfNilRecordElement(token, referenceToken, this._tolerance))) {
                    throw new IllegalActionException((Nameable)this, "Test fails in iteration " + this._iteration + ".\n" + "Value was: " + token + ". Should have been: " + referenceToken);
                }
                this.output.send(i, token);
            }
            ++i;
        }
        ++this._iteration;
        return true;
    }

    public void wrapup() throws IllegalActionException {
        super.wrapup();
        boolean training = ((BooleanToken)this.trainingMode.getToken()).booleanValue();
        if (!training && this._initialized) {
            String errorMessage;
            if (!this._firedOnce) {
                errorMessage = "The fire() method of this actor was never called. Usually, this is an error indicating that starvation is occurring.";
                String fireCompatProperty = "ptolemy.actor.lib.NonStrictTest.fire.compat";
                if (StringUtilities.getProperty(fireCompatProperty).length() > 0) {
                    System.err.println("Warning: '" + this.getFullName() + "' " + errorMessage + "\nThis error is being ignored because " + "the " + fireCompatProperty + "property was set.");
                } else {
                    throw new IllegalActionException((Nameable)this, errorMessage);
                }
            }
            if (this._numberOfInputTokensSeen < ((ArrayToken)this.correctValues.getToken()).length()) {
                errorMessage = "The test produced only " + this._numberOfInputTokensSeen + " tokens, yet the correctValues parameter was " + "expecting " + ((ArrayToken)this.correctValues.getToken()).length() + " tokens.";
                System.err.println("Warning: '" + this.getFullName() + "' " + errorMessage);
            }
        }
        this._initialized = false;
        if (training && this._trainingTokens != null && this._trainingTokens.size() > 0) {
            Object[] newValues = this._trainingTokens.toArray();
            int width = this.input.getWidth();
            Token[] newTokens = new Token[newValues.length];
            if (width == 1) {
                int i = 0;
                while (i < newValues.length) {
                    newTokens[i] = newValues[i] instanceof Token[] ? new ArrayToken((Token[])newValues[i]) : (Token)newValues[i];
                    ++i;
                }
            } else {
                int i = 0;
                while (i < newValues.length) {
                    ArrayList entry = (ArrayList)newValues[i];
                    if (entry.size() < 1) {
                        System.err.println("Warning: '" + this.getFullName() + "': Unable to train. " + "Zero tokens received in iteration " + i);
                        return;
                    }
                    Object[] entries = entry.toArray();
                    Token[] newEntry = new Token[entries.length];
                    int j = 0;
                    while (j < entries.length) {
                        newEntry[j] = (Token)entries[j];
                        ++j;
                    }
                    newTokens[i] = new ArrayToken(newEntry);
                    ++i;
                }
            }
            this.correctValues.setToken(new ArrayToken(newTokens));
            this.correctValues.setPersistent(true);
        }
        if (training && (this._trainingTokens == null || this._trainingTokens.size() == 0)) {
            System.err.println("Warning: '" + this.getFullName() + "' The test produced 0 tokens.");
        }
    }
}

