/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.IntToken;
import ptolemy.data.ScalarToken;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Workspace;

public class Minimum
extends TypedAtomicActor {
    public TypedIOPort input = new TypedIOPort(this, "input", true, false);
    public TypedIOPort minimumValue;
    public TypedIOPort channelNumber;

    public Minimum(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.input.setMultiport(true);
        this.minimumValue = new TypedIOPort(this, "minimumValue", false, true);
        this.minimumValue.setMultiport(true);
        this.minimumValue.setTypeAtMost(BaseType.SCALAR);
        this.minimumValue.setTypeAtLeast(this.input);
        this.channelNumber = new TypedIOPort(this, "channelNumber", false, true);
        this.channelNumber.setMultiport(true);
        this.channelNumber.setTypeEquals(BaseType.INT);
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        Minimum newObject = (Minimum)super.clone(workspace);
        newObject.minimumValue.setTypeAtMost(BaseType.SCALAR);
        newObject.minimumValue.setTypeAtLeast(newObject.input);
        newObject.channelNumber.setTypeEquals(BaseType.INT);
        return newObject;
    }

    public void fire() throws IllegalActionException {
        super.fire();
        ScalarToken result = null;
        ScalarToken resultMagnitude = null;
        ScalarToken inMagnitude = null;
        int channelNum = -1;
        int i = 0;
        while (i < this.input.getWidth()) {
            if (this.input.hasToken(i)) {
                ScalarToken in = (ScalarToken)this.input.get(i);
                inMagnitude = in.getType().equals(BaseType.COMPLEX) ? in.absolute() : in;
                if (result == null) {
                    result = in;
                    resultMagnitude = inMagnitude;
                    channelNum = i;
                } else if (inMagnitude.isLessThan(resultMagnitude).booleanValue()) {
                    result = in;
                    resultMagnitude = inMagnitude;
                    channelNum = i;
                }
            }
            ++i;
        }
        if (result != null) {
            this.minimumValue.broadcast(result);
            this.channelNumber.broadcast(new IntToken(channelNum));
        }
    }
}

