/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.Transformer;
import ptolemy.data.DoubleMatrixToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;

public class LinearDifferenceEquationSystem
extends Transformer {
    public TypedIOPort state;
    public Parameter A;
    public Parameter B;
    public Parameter C;
    public Parameter D;
    public Parameter initialStates;
    private Token _x;
    private Token _xPrime;
    private boolean _initialStateChanged;
    private boolean _singleOutput;
    private boolean _singleState;

    public LinearDifferenceEquationSystem(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.input.setMultiport(false);
        this.output.setMultiport(false);
        this.state = new TypedIOPort(this, "state", false, true);
        this.A = new Parameter(this, "A");
        this.A.setExpression("[1.0]");
        this.A.setTypeEquals(BaseType.DOUBLE_MATRIX);
        this.B = new Parameter(this, "B");
        this.B.setExpression("[1.0]");
        this.B.setTypeEquals(BaseType.DOUBLE_MATRIX);
        this.C = new Parameter(this, "C");
        this.C.setExpression("[1.0]");
        this.C.setTypeEquals(BaseType.DOUBLE_MATRIX);
        this.D = new Parameter(this, "D");
        this.D.setExpression("[0.0]");
        this.D.setTypeEquals(BaseType.DOUBLE_MATRIX);
        this.initialStates = new Parameter(this, "initialStates");
        this.initialStates.setExpression("[0.0]");
        this.initialStates.setTypeEquals(BaseType.DOUBLE_MATRIX);
        double[][] zero = new double[][]{{0.0}};
        this._x = new DoubleMatrixToken(zero);
        this._initialStateChanged = true;
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-75\" y=\"-30\" width=\"150\" height=\"60\" style=\"fill:white\"/>\n<text x=\"-70\" y=\"-10\" style=\"font-size:14\">\nx(k+1) = Ax(k) + Bu(k) </text>\n<text x=\"-70\" y=\"10\" style=\"font-size:14\">\n    y(k) = Cx(k) + Du(k)</text>\n</svg>\n");
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.A) {
            DoubleMatrixToken token = (DoubleMatrixToken)this.A.getToken();
            if (token.getRowCount() == 0 || token.getColumnCount() == 0 || token.getRowCount() != token.getColumnCount()) {
                throw new IllegalActionException((Nameable)this, "The A matrix must be a nonempty square matrix.");
            }
        } else if (attribute == this.B) {
            DoubleMatrixToken token = (DoubleMatrixToken)this.B.getToken();
            if (token.getRowCount() == 0 || token.getColumnCount() == 0) {
                throw new IllegalActionException((Nameable)this, "The B matrix must be a nonempty matrix.");
            }
        } else if (attribute == this.C) {
            DoubleMatrixToken token = (DoubleMatrixToken)this.C.getToken();
            if (token.getRowCount() == 0 || token.getColumnCount() == 0) {
                throw new IllegalActionException((Nameable)this, "The C matrix must be a nonempty matrix.");
            }
        } else if (attribute == this.D) {
            DoubleMatrixToken token = (DoubleMatrixToken)this.D.getToken();
            if (token.getRowCount() == 0 || token.getColumnCount() == 0) {
                throw new IllegalActionException((Nameable)this, "The D matrix must be a nonempty matrix.");
            }
        } else if (attribute == this.initialStates) {
            DoubleMatrixToken token = (DoubleMatrixToken)this.initialStates.getToken();
            if (token.getColumnCount() != 1 || token.getRowCount() < 1) {
                throw new IllegalActionException((Nameable)this, "The initialStates must be a column vector.");
            }
            this._initialStateChanged = true;
        } else {
            super.attributeChanged(attribute);
        }
    }

    public void fire() throws IllegalActionException {
        super.fire();
        if (this.input.hasToken(0)) {
            Token u = this.input.get(0);
            Token y = this.C.getToken().multiply(this._x).add(this.D.getToken().multiply(u));
            this._xPrime = this.A.getToken().multiply(this._x).add(this.B.getToken().multiply(u));
            if (this._singleOutput) {
                this.output.send(0, ((DoubleMatrixToken)y).getElementAsToken(0, 0));
            } else {
                this.output.send(0, y);
            }
            if (this._singleState) {
                this.state.send(0, ((DoubleMatrixToken)this._x).getElementAsToken(0, 0));
            } else {
                this.state.send(0, this._x);
            }
        }
    }

    public boolean postfire() throws IllegalActionException {
        if (super.postfire()) {
            this._x = this._xPrime;
            return true;
        }
        return false;
    }

    public boolean prefire() throws IllegalActionException {
        super.prefire();
        if (this._initialStateChanged) {
            this._x = this.initialStates.getToken();
            this._initialStateChanged = false;
        }
        return this.input.hasToken(0);
    }

    public void preinitialize() throws IllegalActionException {
        super.preinitialize();
        DoubleMatrixToken a = (DoubleMatrixToken)this.A.getToken();
        int n = a.getRowCount();
        DoubleMatrixToken b = (DoubleMatrixToken)this.B.getToken();
        if (b.getRowCount() != n) {
            throw new IllegalActionException((Nameable)this, "The number of rows of the B matrix should equal to the number of rows of the A matrix.");
        }
        if (n == 1) {
            this._singleState = true;
            this.state.setTypeEquals(BaseType.DOUBLE);
        } else {
            this._singleState = false;
            this.state.setTypeEquals(BaseType.DOUBLE_MATRIX);
        }
        int m = b.getColumnCount();
        if (m == 1) {
            this.input.setTypeEquals(BaseType.DOUBLE);
        } else {
            this.input.setTypeEquals(BaseType.DOUBLE_MATRIX);
        }
        DoubleMatrixToken c = (DoubleMatrixToken)this.C.getToken();
        if (c.getColumnCount() != n) {
            throw new IllegalActionException((Nameable)this, "The number of columns of the C matrix should equal to the number of rows of the A matrix.");
        }
        int r = c.getRowCount();
        if (r == 1) {
            this._singleOutput = true;
            this.output.setTypeEquals(BaseType.DOUBLE);
        } else {
            this._singleOutput = false;
            this.output.setTypeEquals(BaseType.DOUBLE_MATRIX);
        }
        DoubleMatrixToken d = (DoubleMatrixToken)this.D.getToken();
        if (c.getRowCount() != d.getRowCount()) {
            throw new IllegalActionException((Nameable)this, "The number of rows of the D matrix should equal to the number of rows of the C matrix.");
        }
        DoubleMatrixToken x0 = (DoubleMatrixToken)this.initialStates.getToken();
        if (x0.getRowCount() != n) {
            throw new IllegalActionException((Nameable)this, "The number of initial states should equal to the number of columns of the A matrix.");
        }
        this._initialStateChanged = true;
    }
}

