/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.lib.Transformer;
import ptolemy.data.ArrayToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public class Lattice
extends Transformer {
    public Parameter reflectionCoefficients;
    protected int _order = 0;
    protected double[] _backward = null;
    protected double[] _backwardCache = null;
    protected double[] _forward = null;
    protected double[] _forwardCache = null;
    protected double[] _reflectionCoefficients = null;

    public Lattice(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.input.setTypeEquals(BaseType.DOUBLE);
        this.output.setTypeEquals(BaseType.DOUBLE);
        this.reflectionCoefficients = new Parameter(this, "reflectionCoefficients");
        this.reflectionCoefficients.setExpression("{0.804534, -0.820577, 0.521934, -0.205}");
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.reflectionCoefficients) {
            ArrayToken value = (ArrayToken)this.reflectionCoefficients.getToken();
            this._order = value.length();
            if (this._backward == null || this._order != this._backward.length) {
                this._reallocate();
            }
            int i = 0;
            while (i < this._order) {
                this._reflectionCoefficients[i] = ((DoubleToken)value.getElement(i)).doubleValue();
                ++i;
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    public void fire() throws IllegalActionException {
        super.fire();
        if (this.input.hasToken(0)) {
            DoubleToken in = (DoubleToken)this.input.get(0);
            this._forwardCache[0] = in.doubleValue();
            this._doFilter();
            this._backwardCache[0] = this._forwardCache[0];
            this.output.broadcast(new DoubleToken(this._forwardCache[this._order]));
        }
    }

    public void initialize() throws IllegalActionException {
        int i = 0;
        while (i < this._order + 1) {
            this._forward[i] = 0.0;
            this._forwardCache[i] = 0.0;
            this._backward[i] = 0.0;
            this._backwardCache[i] = 0.0;
            ++i;
        }
    }

    public boolean postfire() throws IllegalActionException {
        System.arraycopy(this._backwardCache, 0, this._backward, 0, this._order + 1);
        System.arraycopy(this._forwardCache, 0, this._forward, 0, this._order + 1);
        return super.postfire();
    }

    public boolean prefire() throws IllegalActionException {
        System.arraycopy(this._backward, 0, this._backwardCache, 0, this._order + 1);
        System.arraycopy(this._forward, 0, this._forwardCache, 0, this._order + 1);
        return super.prefire();
    }

    protected void _doFilter() throws IllegalActionException {
        double k;
        int i = 0;
        while (i < this._order) {
            k = this._reflectionCoefficients[i];
            this._forwardCache[i + 1] = -k * this._backwardCache[i] + this._forwardCache[i];
            ++i;
        }
        i = this._order;
        while (i > 0) {
            k = this._reflectionCoefficients[i - 1];
            this._backwardCache[i] = -k * this._forwardCache[i - 1] + this._backwardCache[i - 1];
            --i;
        }
    }

    protected void _reallocate() {
        this._backward = new double[this._order + 1];
        this._backwardCache = new double[this._order + 1];
        this._forward = new double[this._order + 1];
        this._forwardCache = new double[this._order + 1];
        this._reflectionCoefficients = new double[this._order];
    }
}

