/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.lib.Transformer;
import ptolemy.data.ArrayToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.ArrayType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.Workspace;
import ptolemy.util.CancelException;
import ptolemy.util.MessageHandler;

public class IIR
extends Transformer {
    public Parameter numerator;
    public Parameter denominator;
    private Token[] _numerator = new Token[0];
    private Token[] _denominator = new Token[0];
    private Token[] _stateVector;
    private int _currentTap;
    private Token _latestWindow;

    public IIR(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.numerator = new Parameter(this, "numerator");
        this.numerator.setExpression("{1.0}");
        this.attributeChanged(this.numerator);
        this.denominator = new Parameter(this, "denominator");
        this.denominator.setExpression("{1.0}");
        this.attributeChanged(this.denominator);
        this.output.setTypeAtLeast(ArrayType.elementType(this.numerator));
        this.output.setTypeAtLeast(ArrayType.elementType(this.denominator));
        this.input.setTypeAtLeast(this.output);
        this.output.setTypeAtLeast(this.input);
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.numerator) {
            ArrayToken numeratorValue = (ArrayToken)this.numerator.getToken();
            this._numerator = numeratorValue.arrayValue();
        } else if (attribute == this.denominator) {
            ArrayToken denominatorValue = (ArrayToken)this.denominator.getToken();
            this._denominator = denominatorValue.arrayValue();
            if (!this._denominator[0].isEqualTo(this._denominator[0].one()).booleanValue()) {
                try {
                    MessageHandler.warning("First denominator value is required to be 1. Using 1.");
                }
                catch (CancelException cancelException) {
                    throw new IllegalActionException((Nameable)this, "Canceled parameter change.");
                }
                this._denominator[0] = this._denominator[0].one();
            }
        } else {
            super.attributeChanged(attribute);
            return;
        }
        if (this._numerator != null && this._denominator != null) {
            this._initStateVector();
        }
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        IIR newObject = (IIR)super.clone(workspace);
        try {
            newObject.output.setTypeAtLeast(ArrayType.elementType(newObject.numerator));
            newObject.output.setTypeAtLeast(ArrayType.elementType(newObject.denominator));
            newObject.input.setTypeAtLeast(newObject.output);
            newObject.output.setTypeAtLeast(newObject.input);
        }
        catch (IllegalActionException ex) {
            CloneNotSupportedException throwable = new CloneNotSupportedException();
            throwable.initCause(ex);
            throw throwable;
        }
        return newObject;
    }

    public void fire() throws IllegalActionException {
        super.fire();
        if (this.input.hasToken(0)) {
            Token savedState = this._stateVector[this._currentTap];
            Token yCurrent = this._computeOutput(this.input.get(0));
            this._latestWindow = this._stateVector[this._currentTap];
            this._stateVector[this._currentTap] = savedState;
            this.output.send(0, yCurrent);
        }
    }

    public void initialize() throws IllegalActionException {
        super.initialize();
        this._initStateVector();
        this._currentTap = 0;
    }

    public boolean postfire() throws IllegalActionException {
        this._stateVector[this._currentTap] = this._latestWindow;
        if (--this._currentTap < 0) {
            this._currentTap = this._stateVector.length - 1;
        }
        return super.postfire();
    }

    private Token _computeOutput(Token xCurrent) throws IllegalActionException {
        int j = 1;
        while (j < this._denominator.length) {
            xCurrent = xCurrent.subtract(this._denominator[j].multiply(this._stateVector[(this._currentTap + j) % this._stateVector.length]));
            ++j;
        }
        this._stateVector[this._currentTap] = xCurrent;
        Token yCurrent = this._numerator[0].zero();
        int k = 0;
        while (k < this._numerator.length) {
            yCurrent = yCurrent.add(this._numerator[k].multiply(this._stateVector[(this._currentTap + k) % this._stateVector.length]));
            ++k;
        }
        return yCurrent;
    }

    private void _initStateVector() throws IllegalActionException {
        if (this._numerator.length > 0) {
            int stateSize = Math.max(this._numerator.length, this._denominator.length);
            this._stateVector = new Token[stateSize];
            Token zero = this._numerator[0].zero();
            int j = 0;
            while (j < this._stateVector.length) {
                this._stateVector[j] = zero;
                ++j;
            }
        }
    }
}

