/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import java.io.IOException;
import ptolemy.actor.lib.Writer;
import ptolemy.data.StringToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;

public class FileWriter
extends Writer {
    public Parameter filename = new Parameter(this, "filename");

    public FileWriter(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.filename.setExpression("");
        this.filename.setTypeEquals(BaseType.STRING);
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.filename) {
            try {
                StringToken filenameToken = (StringToken)this.filename.getToken();
                if (filenameToken == null) {
                    this.setWriter(null);
                } else {
                    String newFilename = filenameToken.stringValue();
                    if (newFilename.equals("")) {
                        this.setWriter(null);
                    } else {
                        java.io.FileWriter writer = new java.io.FileWriter(newFilename);
                        this.setWriter(writer);
                    }
                }
            }
            catch (IOException ex) {
                throw new IllegalActionException((Nameable)this, ex, "attributeChanged(" + attribute.getName() + ") failed");
            }
        }
    }

    public void initialize() throws IllegalActionException {
        super.initialize();
        this.attributeChanged(this.filename);
    }

    public void wrapup() throws IllegalActionException {
        super.wrapup();
        this.setWriter(null);
    }
}

