/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.parameters.PortParameter;
import ptolemy.data.ArrayToken;
import ptolemy.data.BooleanToken;
import ptolemy.data.RecordToken;
import ptolemy.data.StringToken;
import ptolemy.data.expr.FileParameter;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.RecordType;
import ptolemy.data.type.Type;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.util.StringUtilities;

public class Exec
extends TypedAtomicActor {
    public PortParameter command = new PortParameter((NamedObj)this, "command", new StringToken("echo \"Hello, world.\""));
    public FileParameter directory;
    public Parameter environment;
    public TypedIOPort error;
    public TypedIOPort input;
    public TypedIOPort output;
    public Parameter throwExceptionOnNonZeroReturn;
    private BufferedWriter _inputBufferedWriter;
    private _StreamReaderThread _errorGobbler;
    private _StreamReaderThread _outputGobbler;
    private Process _process;
    private boolean _stopFireRequested = false;
    private static int _streamReaderThreadCount = 0;

    public Exec(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.command.setStringMode(true);
        new Parameter((NamedObj)this.command.getPort(), "_showName", BooleanToken.TRUE);
        this.directory = new FileParameter(this, "directory");
        this.directory.setExpression("$CWD");
        this.environment = new Parameter(this, "environment");
        String[] labels = new String[]{"name", "value"};
        Type[] values = new Type[]{BaseType.STRING, BaseType.STRING};
        this.environment.setTypeEquals(new ArrayType(new RecordType(labels, values)));
        this.environment.setExpression("{{name = \"\", value = \"\"}}");
        this.error = new TypedIOPort(this, "error", false, true);
        this.error.setTypeEquals(BaseType.STRING);
        new Parameter((NamedObj)this.error, "_showName", BooleanToken.TRUE);
        this.input = new TypedIOPort(this, "input", true, false);
        this.input.setTypeEquals(BaseType.STRING);
        new Parameter((NamedObj)this.input, "_showName", BooleanToken.TRUE);
        this.output = new TypedIOPort(this, "output", false, true);
        this.output.setTypeEquals(BaseType.STRING);
        new Parameter((NamedObj)this.output, "_showName", BooleanToken.TRUE);
        this.throwExceptionOnNonZeroReturn = new Parameter((NamedObj)this, "throwExceptionOnNonZeroReturn", BooleanToken.TRUE);
        this.throwExceptionOnNonZeroReturn.setTypeEquals(BaseType.BOOLEAN);
    }

    public void fire() throws IllegalActionException {
        block13: {
            super.fire();
            String line = null;
            this._exec();
            if (this.input.numberOfSources() > 0 && this.input.hasToken(0) && (line = ((StringToken)this.input.get(0)).stringValue()) != null) {
                if (this._debugging) {
                    this._debug("Exec: Input: '" + line + "'");
                }
                if (this._inputBufferedWriter != null) {
                    try {
                        this._inputBufferedWriter.write(line);
                        this._inputBufferedWriter.flush();
                    }
                    catch (IOException ex) {
                        throw new IllegalActionException((Nameable)this, ex, "Problem writing input '" + this.command + "'");
                    }
                }
            }
            try {
                int processReturnCode = this._process.waitFor();
                if (processReturnCode == 0) break block13;
                String outputString = "";
                String errorString = "";
                try {
                    errorString = this._errorGobbler.getAndReset();
                }
                catch (Exception ex) {
                    errorString = ex.toString();
                }
                try {
                    outputString = this._outputGobbler.getAndReset();
                }
                catch (Exception ex) {
                    outputString = ex.toString();
                }
                boolean throwExceptionOnNonZeroReturnValue = ((BooleanToken)this.throwExceptionOnNonZeroReturn.getToken()).booleanValue();
                if (throwExceptionOnNonZeroReturnValue) {
                    throw new IllegalActionException((Nameable)this, "Executing command \"" + ((StringToken)this.command.getToken()).stringValue() + "\" returned a non-zero return value of " + processReturnCode + ".\nThe last input was: " + line + ".\nThe standard output was: " + outputString + "\nThe error output was: " + errorString);
                }
                this.error.send(0, new StringToken(errorString));
                this.output.send(0, new StringToken(outputString));
            }
            catch (InterruptedException interrupted) {
                throw new InternalErrorException(this, (Throwable)interrupted, "_process.waitFor() was interrupted");
            }
        }
        String outputString = this._outputGobbler.getAndReset();
        String errorString = this._errorGobbler.getAndReset();
        if (this._debugging) {
            this._debug("Exec: Error: '" + errorString + "'");
            this._debug("Exec: Output: '" + outputString + "'");
        }
        this.error.send(0, new StringToken(errorString));
        this.output.send(0, new StringToken(outputString));
    }

    public void stop() {
        super.stop();
        try {
            this._terminateProcess();
        }
        catch (IllegalActionException ex) {
            throw new InternalErrorException(ex);
        }
    }

    public void stopFire() {
        super.stopFire();
        this._stopFireRequested = true;
        try {
            this._terminateProcess();
        }
        catch (IllegalActionException ex) {
            throw new InternalErrorException(ex);
        }
    }

    public void wrapup() throws IllegalActionException {
        this._terminateProcess();
    }

    private void _exec() throws IllegalActionException {
        File directoryAsFile = null;
        try {
            this._stopFireRequested = false;
            if (this._process != null) {
                this._terminateProcess();
            }
            Runtime runtime = Runtime.getRuntime();
            this.command.update();
            String[] commandArray = StringUtilities.tokenizeForExec(((StringToken)this.command.getToken()).stringValue());
            directoryAsFile = this.directory.asFile();
            if (!directoryAsFile.isDirectory()) {
                throw new IllegalActionException("No such directory: " + directoryAsFile);
            }
            if (this._debugging) {
                this._debug("About to exec \"" + ((StringToken)this.command.getToken()).stringValue() + "\"" + "\n in \"" + directoryAsFile + "\"\n with environment:");
            }
            ArrayToken environmentTokens = (ArrayToken)this.environment.getToken();
            if (this._debugging) {
                this._debug("environmentTokens: " + environmentTokens);
            }
            String[] environmentArray = null;
            if (environmentTokens.length() >= 1) {
                environmentArray = new String[environmentTokens.length()];
                int i = 0;
                while (i < environmentTokens.length()) {
                    StringToken nameToken = (StringToken)((RecordToken)environmentTokens.getElement(i)).get("name");
                    StringToken valueToken = (StringToken)((RecordToken)environmentTokens.getElement(i)).get("value");
                    environmentArray[i] = String.valueOf(nameToken.stringValue()) + "=" + valueToken.stringValue();
                    if (this._debugging) {
                        this._debug("  " + i + ". \"" + environmentArray[i] + "\"");
                    }
                    if (i == 0 && environmentTokens.length() == 1 && environmentArray[0].equals("=")) {
                        if (this._debugging) {
                            this._debug("There is only one element, it is a string of length 0,\n so we pass Runtime.exec() an null environment so that we use\n the default environment");
                        }
                        environmentArray = null;
                    }
                    ++i;
                }
            }
            this._process = runtime.exec(commandArray, environmentArray, directoryAsFile);
            this._outputGobbler = new _StreamReaderThread(this._process.getInputStream(), "Exec Stdout Gobbler-" + _streamReaderThreadCount++, this);
            this._errorGobbler = new _StreamReaderThread(this._process.getErrorStream(), "Exec Stderr Gobbler-" + _streamReaderThreadCount++, this);
            this._errorGobbler.start();
            this._outputGobbler.start();
            if (_streamReaderThreadCount > 1000) {
                _streamReaderThreadCount = 0;
            }
            OutputStreamWriter inputStreamWriter = new OutputStreamWriter(this._process.getOutputStream());
            this._inputBufferedWriter = new BufferedWriter(inputStreamWriter);
        }
        catch (IOException ex) {
            throw new IllegalActionException((Nameable)this, ex, "Problem executing the command '" + this.command.getExpression() + "'\n" + "in the directory: " + directoryAsFile);
        }
    }

    private void _terminateProcess() throws IllegalActionException {
        if (this._process != null) {
            this._process.destroy();
            this._process = null;
        }
    }

    private class _StreamReaderThread
    extends Thread {
        private Nameable _actor;
        private InputStream _inputStream;
        private InputStreamReader _inputStreamReader;
        private boolean _inputStreamReaderClosed;
        private StringBuffer _stringBuffer;

        _StreamReaderThread(InputStream inputStream, String name, Nameable actor) {
            super(name);
            this._inputStreamReaderClosed = false;
            this._inputStream = inputStream;
            this._inputStreamReader = new InputStreamReader(this._inputStream);
            this._actor = actor;
            this._stringBuffer = new StringBuffer();
        }

        public String getAndReset() {
            block7: {
                if (Exec.this._debugging) {
                    try {
                        Exec.this._debug("getAndReset: Gobbler '" + this.getName() + "' Ready: " + this._inputStreamReader.ready() + " Available: " + this._inputStream.available());
                    }
                    catch (Exception ex) {
                        throw new InternalErrorException(ex);
                    }
                }
                try {
                    this._read();
                }
                catch (Throwable throwable) {
                    if (!Exec.this._debugging) break block7;
                    Exec.this._debug("WARNING: getAndReset(): _read() threw an exception, which we are ignoring.\n" + throwable.getMessage());
                }
            }
            String results = this._stringBuffer.toString();
            this._stringBuffer = new StringBuffer();
            try {
                this._inputStreamReader.close();
                this._inputStreamReaderClosed = true;
            }
            catch (Exception ex) {
                throw new InternalErrorException(null, (Throwable)ex, String.valueOf(this.getName()) + " failed to close.");
            }
            return results;
        }

        public synchronized void run() {
            if (!this._inputStreamReaderClosed) {
                this._read();
            }
        }

        private synchronized void _read() {
            char[] chars = new char[80];
            try {
                int length;
                while ((length = this._inputStreamReader.read(chars, 0, 80)) != -1 && !Exec.this._stopRequested && !Exec.this._stopFireRequested) {
                    if (Exec.this._debugging) {
                        Exec.this._debug("_read(): Gobbler '" + this.getName() + "' Ready: " + this._inputStreamReader.ready() + " Value: '" + String.valueOf(chars, 0, length) + "'");
                    }
                    this._stringBuffer.append(chars, 0, length);
                }
            }
            catch (Throwable throwable) {
                throw new InternalErrorException(this._actor, throwable, String.valueOf(this.getName()) + ": Failed while reading from " + this._inputStream);
            }
        }
    }
}

